var gulp = require('gulp');
var sass = require('gulp-sass');
var autoprefixer = require('autoprefixer');
var postcss = require('gulp-postcss');
var rename = require('gulp-rename');
var plumber = require('gulp-plumber');
var gutil = require('gulp-util');
var cssnano = require('gulp-cssnano');
var gcmq = require('gulp-group-css-media-queries');
var jshint = require('gulp-jshint');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var sourcemaps = require('gulp-sourcemaps');
var browserSync = require('browser-sync').create();
var reload = browserSync.reload;



var onError = function (err) {
    console.log('An error occurred:', gutil.colors.magenta(err.message));
    gutil.beep();
    this.emit('end');

};



gulp.task('frontcss', function() {
    return gulp.src('./sass/*.scss')
        .pipe(plumber({ errorHandler: onError }))
        .pipe(sass())
        .pipe(postcss([ autoprefixer() ]))
        .pipe(gcmq())
        .pipe(gulp.dest('./css'))
        .pipe(cssnano({zindex:false}))
        .pipe(rename({ suffix: '.min' }))
        .pipe(gulp.dest('./css'));

});





gulp.task('frontjs', function() {
    return gulp.src(['./js/*.js'])
        .pipe(concat('frontend.js'))
        .pipe(gulp.dest('./js'))
        .pipe(uglify())
        .pipe(rename({suffix: '.min'}))
        .pipe(gulp.dest('./js'))

});





gulp.task('watch', function() {
    gulp.watch('sass/**/*.scss', ['frontcss']);
});

