<?php
/**
 * Plugin Name: NetBase Solutions
 * Plugin URI: https://cmsmart.net
 * Description: Plugin that contain a lot of feature in Printshop Solution Package.
 * Version: 1.4.0
 * Author: Netbase-Team
 * Author URI: https://woocommerce.com
 * Text Domain: nbt-solution
 * Domain Path: /languages
 *
 * @package Solutions
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

// Define plugin textdomain & theme templates folder for plugin.
define( 'PREFIX_NBT_SOL', 'nbt-solutions' );
// Define path to plugin directory.
define( 'PREFIX_NBT_SOL_PATH', plugin_dir_path( __FILE__ ) );
// Define URL to plugin directory.
define( 'PREFIX_NBT_SOL_URL', plugin_dir_url( __FILE__ ) );
// Define plugin base file.
define( 'PREFIX_NBT_SOL_BASENAME', plugin_basename( __FILE__ ) );
define( 'PREFIX_NBT_SOL_DEV', true );

class NB_Solution {
    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NB_Solutions
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
	
    /**
     * NB_Solutions constructor.
     *
     * @since 0.0.1
     */
    private function __construct() {		
		// Load the core class.
		require_once PREFIX_NBT_SOL_PATH . 'core/core.php';
		require_once PREFIX_NBT_SOL_PATH . 'api/api.php';
		require_once PREFIX_NBT_SOL_PATH . 'dashboard.php';

		load_plugin_textdomain( 'nbt-solution', false, PREFIX_NBT_SOL_PATH . 'languages' ); 
	}
	
    /**
     * Check Slug Page.
     *
     * @since 0.0.1
     */
	public static function is_page( $slug ) {
		$uri = ltrim( rtrim( $_SERVER['REQUEST_URI'], '/' ), '/');

		return (strpos($uri, $slug) !== false) ? true : false;
	}
}

/**
* Load plugin for NB_Solution
*
* @since 2.5.3
*
* @return void
**/
add_action( 'plugins_loaded', array( 'NB_Solution', 'instance' ) );

// register_activation_hook( __FILE__, array( 'NB_Solution', 'netbase_solutions__activate' ) );
// register_deactivation_hook( __FILE__, array( 'NB_Solution', 'netbase_solutions__deactivate' ) );

if ( ! function_exists('write_log')) {
   function write_log ( $log )  {
      if ( is_array( $log ) || is_object( $log ) ) {
         error_log( print_r( $log, true ) );
      } else {
         error_log( $log );
      }
   }
}
