<?php
class NBT_Social_Login_Settings{
	static $id = 'social-login';

	protected static $initialized = false;

	public static function initialize() {
		// Do nothing if pluggable functions already initialized.
		if ( self::$initialized ) {
			return;
		}

		// State that initialization completed.
		self::$initialized = true;
	}

    public static function get_settings() {
        $settings = array(
            'label_fb' => array(
                'name' => __( 'Facebook', 'nbt-solutions' ),
                'type' => 'label',
                'id'   => 'nbt_'.self::$id.'_label_fb',                
            ),

            'facebook_enable' => array(
                'name' => __( 'Enable?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_facebook_enable',
                'default' => false,
                'label' => ''
            ),
            'facebook_app_id' => array(
                'name' => __( 'Facebook App ID:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_facebook_app_id',
                'default' => '',
                'label' => '',
                'desc_tip' => '<p><a target="_blank" href="https://developers.facebook.com/apps">Get App ID</a> | <span>Valid Oauth redirect URIs: '. site_url().'/wp-login.php?nbtsl_login_id=facebook_check</span></p>'
            ),
            'facebook_app_secret' => array(
                'name' => __( 'Facebook App Secret:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_facebook_app_secret',
                'default' => '',
                'label' => ''
            ),
            /*'profile_img_width' => array(
                'name' => __( 'Profile picture image size width:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_profile_img_width',
                'default' => '',
                'label' => ''
            ),
            'profile_img_height' => array(
                'name' => __( 'Profile picture image size height:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_profile_img_height',
                'default' => '',
                'label' => ''
            ),*/

            'label_twitter' => array(
                'name' => __( 'Twitter', 'nbt-solutions' ),
                'type' => 'label',
                'id'   => 'nbt_'.self::$id.'_label_twitter',                
            ),
            'twitter_enable' => array(
                'name' => __( 'Enable?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_twitter_enable',
                'default' => false,
                'label' => ''
            ),
            'twitter_api_key' => array(
                'name' => __( 'Twitter Api Key:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_twitter_api_key',
                'default' => '',
                'label' => '',
                'desc_tip' => '<p><a target="_blank" href="https://apps.twitter.com/">Get Twitter Api Key</a> | <span>Callback URL: '. site_url().'/wp-login.php?nbtsl_login_id=twitter_check</span></p>'
            ),
            'twitter_api_secret' => array(
                'name' => __( 'Twitter Api Secret:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_twitter_api_secret',
                'default' => '',
                'label' => ''
            ),

            'label_google' => array(
                'name' => __( 'Google', 'nbt-solutions' ),
                'type' => 'label',
                'id'   => 'nbt_'.self::$id.'_label_google',                
            ),
            'google_enable' => array(
                'name' => __( 'Enable?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_google_enable',
                'default' => false,
                'label' => ''
            ),
            'google_client_id' => array(
                'name' => __( 'Client ID:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_google_client_id',
                'default' => '',
                'label' => '',
                'desc_tip' => '<p><a target="_blank" href="https://console.developers.google.com/project">Get Client ID</a> | <span>Rediret uri setup: '. site_url().'/wp-login.php?nbtsl_login_id=google_check</span></p>'
            ),
            'google_client_secret' => array(
                'name' => __( 'Client Secret:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_google_client_secret',
                'default' => '',
                'label' => ''
            ),

            'label_linkedin ' => array(
                'name' => __( 'LinkedIn', 'nbt-solutions' ),
                'type' => 'label',
                'id'   => 'nbt_'.self::$id.'_label_linkedin',                
            ),
            'linkedin_enable' => array(
                'name' => __( 'Enable?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_linkedin_enable',
                'default' => false,
                'label' => ''
            ),
            'linkedin_client_id' => array(
                'name' => __( 'Client ID:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_linkedin_client_id',
                'default' => '',
                'label' => '',
                'desc_tip' => '<p><a target="_blank" href="https://www.linkedin.com/developer/apps">Get the Client ID and Client secret</a> | <span>OAuth 1.0a: '. site_url().'/wp-login.php?nbtsl_login_id=google_check</span></p>'
            ),
            'linkedin_client_secret' => array(
                'name' => __( 'Client Secret:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_linkedin_client_secret',
                'default' => '',
                'label' => ''
            ),

            'label_other_social ' => array(
                'name' => __( 'Other Settings', 'nbt-solutions' ),
                'type' => 'label',
                'id'   => 'nbt_'.self::$id.'_label_other_social',                
            ),

            'title_text_field' => array(
                'name' => __( 'Login text:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_title_text_field',
                'default' => 'Social connect:',
                'label' => ''
            ),
            /*'custom_logout_redirect' => array(
                'name' => __( 'Logout redirect link', 'nbt-solutions' ),
                'type' => 'select',
                'id'   => 'nbt_'.self::$id.'_custom_logout_redirect',
                'default' => 'home',
                'label' => '',
                'options' => array(
                    'home' => __('Home page', 'nbt-solutions'),
                    'current_page' => __('Current page', 'nbt-solutions'),
                    'custom_page' => __('Custom page', 'nbt-solutions'),
                ),
            ),
            'custom_logout_redirect_link' => array(
                'name' => __( 'Logout redirect Custom page:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_custom_logout_redirect_link',
                'default' => '',
                'label' => ''
            ),*/
            'custom_login_redirect' => array(
                'name' => __( 'Login redirect link', 'nbt-solutions' ),
                'type' => 'select',
                'id'   => 'nbt_'.self::$id.'_custom_login_redirect',
                'default' => 'home',
                'label' => '',
                'options' => array(
                    'home' => __('Home page', 'nbt-solutions'),
                    'current_page' => __('Current page', 'nbt-solutions'),
                    'custom_page' => __('Custom page', 'nbt-solutions'),
                ),
            ),

            'custom_login_redirect_link' => array(
                'name' => __( 'Login redirect Custom page:', 'nbt-solutions' ),
                'type' => 'text',
                'id'   => 'nbt_'.self::$id.'_custom_login_redirect_link',
                'default' => '',
                'label' => ''
            ),

            'user_avatar' => array(
                'name' => __( 'User avatar', 'nbt-solutions' ),
                'type' => 'select',
                'id'   => 'nbt_'.self::$id.'_user_avatar',
                'default' => 'default',
                'label' => 'Please choose the options from where you want your users avatar to be loaded from.',
                'options' => array(
                    'default' => __('Use wordpress default avatar', 'nbt-solutions'),
                    'social' => __('Use the profile picture from social media where available', 'nbt-solutions'),
                    
                ),
            ),            

            'login_form_enable' => array(
                'name' => __( 'Display Login Form?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_login_form_enable',
                'default' => true,
                'label' => ''
            ),


            'register_form_enable' => array(
                'name' => __( 'Display Register Form?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_register_form_enable',
                'default' => true,
                'label' => ''
            ),

            'comment_form_enable' => array(
                'name' => __( 'Display Comment Form?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_comment_form_enable',
                'default' => true,
                'label' => ''
            ),

            'wc_enable' => array(
                'name' => __( 'Display woocommerce Login?', 'nbt-solutions' ),
                'type' => 'checkbox',
                'id'   => 'nbt_'.self::$id.'_wc_enable',
                'default' => true,
                'label' => ''
            ),

            'icon_temp' => array(
                'name' => __( 'Icon Template', 'nbt-solutions' ),
                'type' => 'radio_image',
                'id'   => 'nbt_'.self::$id.'_icon_temp',
                'default' => '1',
                'option' => array(
                    '1' => array(
                        'name' => 'temp 1',
                        'src' => NBTSL_IMAGE_DIR . '/preview-1.jpg',
                        'label' => ''
                    ),
                    '2' => array(
                        'name' => 'temp 2',
                        'src' => NBTSL_IMAGE_DIR . '/preview-2.jpg',
                        'label' => ''
                    ),
                    '3' => array(
                        'name' => 'temp 3',
                        'src' => NBTSL_IMAGE_DIR . '/preview-3.jpg',
                        'label' => ''
                    ),
                    '4' => array(
                        'name' => 'temp 4',
                        'src' => NBTSL_IMAGE_DIR . '/preview-4.jpg',
                        'label' => ''
                    ),
                )
            ),

            'send_email_notification' => array(
                'name' => __( 'Send Email Notification', 'nbt-solutions' ),
                'type' => 'select',
                'id'   => 'nbt_'.self::$id.'_send_email_notification',
                'default' => 'yes',
                'label' => 'Here you can configure an options to send email notifications about user registration to site admin and user.',
                'options' => array(
                    'yes' => __('Yes', 'nbt-solutions'),
                    'no' => __('No', 'nbt-solutions'),                    
                ),
            ),
            
        );
        return apply_filters( 'nbt_'.self::$id.'_settings', $settings );
    }
}
