<?php
/**
 * Plugin Name: NB Dashboard
 * Plugin URI: https://woocommerce.com/
 * Description: New dashboard. Beautifully.
 * Version: 1.0.0
 * Author: Automattic
 * Author URI: https://woocommerce.com
 * Text Domain: woocommerce
 * Domain Path: /i18n/languages/
 *
 * @package WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define WC_PLUGIN_FILE.
if ( ! defined( 'NBDB_PLUGIN_FILE' ) ) {
	define( 'NBDB_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'NBDB_ABSPATH' ) ) {
	define( 'NBDB_ABSPATH', dirname( NBDB_PLUGIN_FILE ) . '/' );
}

if ( ! defined( 'NBDB_ABSURL' ) ) {
	define('NBDB_ABSURL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'NBDB_PID' ) ) {
	define( 'NBDB_PID', 1211 );
}

if ( ! defined( 'NBDB_GITLAB_ID' ) ) {
	define( 'NBDB_GITLAB_ID', 9026344 );
}

if ( ! defined( 'NBDB_GITLAB_PRIVATE_TOKEN' ) ) {
	define( 'NBDB_GITLAB_PRIVATE_TOKEN', 'vnY-QKMwzysDdguqQuRv' );
}

final class NB_Dashboard {

	
	public function __construct() {
		$this->hooks();
		$this->includes();
	}
	
	public function hooks() {
		add_action( 'admin_menu', array($this, 'add_admin_menu_settings') );
	}
	
	public function add_admin_menu_settings() {
		add_options_page( 
			'My Options',
			__('Admin UI', 'nb-dashboard'),
			'manage_options',
			'nb-dashboard',
			array('NBD_Settings', 'settings_page')
		);
	}
	
	public function includes() {
		include_once NBDB_ABSPATH . 'includes/functions.php';

		include_once NBDB_ABSPATH . 'classes/class-singleton.php';
		include_once NBDB_ABSPATH . 'classes/class-plugin-updater.php';
		include_once NBDB_ABSPATH . 'classes/class-settings-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-notification-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-analytics-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-remove-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-template-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-ajax-dashboard.php';
		
	}
}

new NB_Dashboard();

if ( ! function_exists('write_log')) {
   function write_log ( $log )  {
      if ( is_array( $log ) || is_object( $log ) ) {
         error_log( print_r( $log, true ) );
      } else {
         error_log( $log );
      }
   }
}
