<?php
if( ! function_exists('nbd_get_screen') ) {
	function nbd_get_screen() {
		$screen = get_current_screen();
		
		if( $screen->post_type ) {
			$slug = $screen->post_type;
		}else {
			$slug = $screen->base;
		}
		
		return $slug;
	}
}


if( ! function_exists('nbd_show_productsales_thisweek') ) {
	function nbd_show_productsales_thisweek() {
		global $wpdb;
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
        	$json = array();
			$week_number = date('W');
			$total_money = 0;
			$year = date('Y');
			for($day=1; $day<=7; $day++)
			{
				$strtotime = strtotime($year."W".$week_number.$day);
			    $date = date('Y-m-d', $strtotime);
				$rev = nbd_get_rev($date, false);
				
			    $json['horizontal'][] = date( get_option('date_format'), $strtotime);
			    $json['vertical'][] = $rev;
				$total_money += $rev;
			}
			$json['rev'] = wc_price($total_money);

			return json_encode($json, TRUE);

		}
	}
}

if( ! function_exists('nbd_show_productsales_lastweek') ) {
	function nbd_show_productsales_lastweek() {
		global $wpdb;
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
        	$json = array();
			$week_number = date('W') - 1;
			$total_money = 0;
			$year = date('Y');
			
			for($day=1; $day<=7; $day++)
			{
				$strtotime = strtotime($year."W".$week_number.$day);
			    $date = date('Y-m-d', $strtotime);
				$rev = nbd_get_rev($date, false);
				
			    $json['horizontal'][] = date( get_option('date_format'), $strtotime);
			    $json['vertical'][] = $rev;
				$total_money += $rev;
			}
			
			$json['rev'] = wc_price($total_money);

			return json_encode($json, TRUE);
		}
	}
}


if( ! function_exists('nbd_show_productsales_thismonth') ) {
	function nbd_show_productsales_thismonth() {
		global $wpdb;
		
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
        	$json = array();
			$end_date = cal_days_in_month(CAL_GREGORIAN, date('m'), date('Y'));
			$start_date = date('Y-m-');
			$total_money = 0;
			
			for($day=1; $day<=$end_date; $day++)
			{
			    $date = $start_date . sprintf("%02d", $day);
				$strtotime = strtotime($date);
				
				$rev = nbd_get_rev($date, false);
			    $json['horizontal'][] = date( get_option('date_format'), $strtotime);
			    $json['vertical'][] = $rev;
				$total_money += $rev;
			}
			
			$json['rev'] = wc_price($total_money);

			return json_encode($json, TRUE);
		}	
	}
}

if( ! function_exists('nbd_show_productsales_lastmonth') ) {
	function nbd_show_productsales_lastmonth() {
		global $wpdb;
		
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$st = strtotime("-1 month");
			
        	$json = array();
			$end_date = cal_days_in_month(CAL_GREGORIAN, date('m', $st), date('Y', $st));
			$start_date = date('Y-m-', $st);
			
			$total_money = 0;
			for($day=1; $day<=$end_date; $day++)
			{
			    $date = $start_date . sprintf("%02d", $day);
				$strtotime = strtotime($date);
				
				$rev = nbd_get_rev($date, false);

			    $json['horizontal'][] = date( get_option('date_format'), $strtotime);
			    $json['vertical'][] = $rev;
				$total_money += $rev;
			}
			
			$json['rev'] = wc_price($total_money);

			return json_encode($json, TRUE);
		}	
	}
}

if( ! function_exists('nbd_show_productsales_range') ) {
	function nbd_show_productsales_range($range_day) {
		global $wpdb;
		
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$start_day = strtotime($range_day[0]);
			$end_day = strtotime($range_day[1]);
			$datediff = $end_day - $start_day;
			$total_day = ($datediff + 86400) / 86400;
			
			$total_money = 0;
			for($day=0; $day < $total_day; $day++)
			{
				$strtotime = strtotime("+" . $day . " day", $start_day);
				$date = date('Y-m-d', $strtotime);

				
				$rev = nbd_get_rev($date, false);
				
				$json['horizontal'][] = date( get_option('date_format'), $strtotime);
				$json['vertical'][] = $rev;
				
				$total_money += $rev;
			}
			
			$json['rev'] = wc_price($total_money);
			
			return json_encode($json, TRUE);
			
		}
	}
}

if( ! function_exists('nbd_get_total_rev')) {

	function nbd_get_total_rev() {
		global $wpdb, $blog_id;

        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

			$query = array();
			$query['fields'] = "SELECT SUM(order_total.meta_value) as price FROM {$wpdb->posts} as posts";
			$query['join']   = "INNER JOIN {$wpdb->prefix}postmeta AS order_total ON posts.ID = order_total.post_id ";
			$query['where']  = "WHERE posts.post_type = 'shop_order' ";
			$query['where']	.= "AND posts.post_status = 'wc-completed' ";
			$query['where']	.= "AND order_total.meta_key = '_order_total' AND order_total.meta_value > 0 ";


			$sql = implode( ' ', apply_filters( 'woocommerce_dashboard_status_widget_top_seller_query', $query ) );


			$total = 0;
			$query_total = $wpdb->get_results( $sql );
			if( $query_total ) {
				foreach ($query_total as $key => $value) {
					$total += $value->price;
				}
			}

			return $total;
		}
	}
}


if( ! function_exists('nbd_get_total_orders')) {

	function nbd_get_total_orders() {
		global $wpdb;

        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

			$query = array();
			$query['fields'] = "SELECT COUNT(posts.ID) as count FROM {$wpdb->posts} as posts";
			$query['where'] = "WHERE posts.post_type = 'shop_order'";
			$query['where'] .= " AND posts.post_status = 'wc-completed'";

			$order = $wpdb->get_row(implode(' ', $query));    

			if(is_null($order->count)) {
				$order->count = 0;
			}
			
			return $order->count;
		}else {
			return 0;
		}
	}
}


if( ! function_exists('nbd_get_total_user')) {

	function nbd_get_total_user() {
		global $wpdb, $blog_id;

		$custom_meta = 'a:1:{s:8:"customer";b:1;}';

		$query = array();
		$query['fields'] = "SELECT COUNT(user.ID) as total_user FROM {$wpdb->base_prefix}usermeta as usermeta";
		$query['join']   = "INNER JOIN {$wpdb->base_prefix}users AS user ON user.ID = usermeta.user_id";
		$query['where']	 = "WHERE usermeta.meta_key LIKE 'wp_" . $wpdb->esc_like($blog_id) . "_capabilities' AND usermeta.meta_value = '". $custom_meta ."' ORDER BY ID DESC";

		$sql = implode(' ', $query);

		$query = $wpdb->get_row( $sql );

		return $query->total_user;
	}
}

if( ! function_exists('nbd_get_rev') ) {

	function nbd_get_rev( $month, $regular = true ) {
		global $wpdb;
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$query = array();

			if( $regular ) {
				$month = date('Y-m', mktime(0, 0, 0, $month, 10));
			}
			
							
			
			

			$query['fields'] = "SELECT SUM(order_total.meta_value) as price FROM {$wpdb->posts} as posts";
			$query['join']   = "INNER JOIN {$wpdb->prefix}postmeta AS order_total ON posts.ID = order_total.post_id ";
			$query['join']   .= "INNER JOIN {$wpdb->prefix}postmeta AS day ON posts.ID = day.post_id ";
			$query['where']  = "WHERE posts.post_type = 'shop_order' ";
			$query['where']	.= "AND posts.post_status = 'wc-completed' ";
			$query['where']	.= "AND order_total.meta_key = '_order_total' AND order_total.meta_value > 0 ";
			$query['where']	.= "AND day.meta_key = '_completed_date' AND day.meta_value LIKE '%" . $month . "%'";

			$sql = implode( ' ', $query );

			$rs = $wpdb->get_row($sql);
			if( ! $rs->price ) {
				$data = 0;
			}else {
				$data = $rs->price;
			}

			return $data;
		}
	}
}

if( ! function_exists('nbd_get_best_buyer')) {
	function nbd_get_best_buyer() {
		global $wpdb, $blog_id;

        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			
			$query = array();
			$query['fields'] = "SELECT SUM(order_total.meta_value) as price, postmeta.meta_value AS customer_user  FROM {$wpdb->posts} as posts";
			$query['join']   = "INNER JOIN {$wpdb->base_prefix}usermeta AS usermeta ON usermeta.meta_key LIKE 'wp_capabilities' ";
			
			$query['join']   .= "INNER JOIN {$wpdb->prefix}postmeta AS order_total ON posts.ID = order_total.post_id ";
			$query['join']   .= "INNER JOIN {$wpdb->prefix}postmeta AS postmeta ON posts.ID = postmeta.post_id";
			$query['where']   = "WHERE posts.post_type = 'shop_order' ";
			$query['where']	 .= "AND posts.post_status IN ( 'wc-" . implode( "','wc-", apply_filters( 'woocommerce_reports_order_statuses', array( 'completed', 'processing', 'on-hold', 'pending' ) ) ) . "' ) ";
			$query['where']	 .= "AND postmeta.meta_key = '_customer_user' AND postmeta.meta_value = usermeta.user_id ";
			$query['where']	 .= "AND order_total.meta_key = '_order_total' AND order_total.meta_value > 0 ";
			$query['groupby'] = "GROUP BY customer_user ORDER BY post_date DESC";

			$sql = implode( ' ', apply_filters( 'woocommerce_dashboard_status_widget_top_seller_query', $query ) );

			return $wpdb->get_results( $sql );
		}
	}
}

if ( ! function_exists('nb_image_upload') )
{
	function nb_image_upload( $value, $name, $name_url = false ) {
		$image = $value ? wp_get_attachment_image_src( $value, 'full' ) : '';
		$image = $image ? $image[0] : NBDB_ABSURL . 'assets/images/placeholder.png';
		?>
		<div class="nb-wrap-image">
			<div class="nb-image-thumbnail" style="float:left;margin-right:10px;">
				<img src="<?php echo esc_url( $image ) ?>" width="60px" height="60px" />
			</div>
			<div style="line-height:60px; position: relative; margin-left: 72px;">
				<input type="hidden" class="nb-image" name="<?php echo $name;?>" value="<?php echo esc_attr( $value ) ?>" />
				<input type="hidden" class="nb-image-url" name="<?php echo $name_url;?>" value="<?php echo $image; ?>" />
				<button type="button" class="nb-upload-image-button button"><?php esc_html_e( 'Upload/Add image', 'wcvs' ); ?></button>
				<button type="button" class="nb-remove-image-button button <?php echo $value ? '' : 'hidden' ?>" style="position: absolute; bottom: 0; left: 0;"><?php esc_html_e( 'Remove image', 'wcvs' ); ?></button>
			</div>
		</div>
		<?php
	}
}

if( ! function_exists('nbd_get_order_status') ) {
	function nbd_get_order_status($status) {
		$statuses = wc_get_order_statuses();
		
		if( isset($statuses['wc-' . $status]) ) {
			return $statuses['wc-' . $status];
		}
	}
}

if( ! function_exists('nbd_get_lists_user')) {
	function nbd_get_lists_user() {
		global $wpdb;
		
	
			$custom_meta = 'a:1:{s:8:"customer";b:1;}';

			$query = array();
			$query['fields'] = "SELECT * FROM {$wpdb->base_prefix}usermeta as usermeta";
			$query['join']   = "INNER JOIN {$wpdb->base_prefix}users AS user ON user.ID = usermeta.user_id";
			$query['where']	 = "WHERE usermeta.meta_key LIKE 'wp_capabilities' AND usermeta.meta_value = '". $custom_meta ."' ORDER BY ID DESC LIMIT 5";

			$sql = implode(' ', $query);
			return $wpdb->get_results( $sql );
			
	
	}
}

if( ! function_exists('nbd_get_changelog')) {
	function nbd_get_changelog() {
		if ( false === ( $changelogs = get_transient( 'nbd_changelogs' ) ) ) {
			$theme_tags = wp_get_theme(get_template())->get('Tags');
			$input = preg_quote('nbd', '~');
			
			if( $tag = preg_grep('~' . $input . '~', $theme_tags) ) {
				$product_id = (int) filter_var($tag[0], FILTER_SANITIZE_NUMBER_INT);
				
				$rs = json_decode(file_get_contents('https://cmsmart.net/api/product_version/netbase/' . $product_id), true);
				if( $rs['result'] ) {
					set_transient( 'nbd_changelogs', $rs['data'], 12 * HOUR_IN_SECONDS );
					$changelogs = $rs['data'];
				}
			}
		}
		
		return $changelogs;
	}
}

if( ! function_exists('nbd_get_video')) {
	function nbd_get_video() {
		if ( false === ( $videos = get_transient( 'nbd_videos' ) ) ) {
			$theme_tags = wp_get_theme(get_template())->get('Tags');
			$input = preg_quote('nbd', '~');
			
			if( $tag = preg_grep('~' . $input . '~', $theme_tags) ) {
				$product_id = (int) filter_var($tag[0], FILTER_SANITIZE_NUMBER_INT);
				
				$rs = json_decode(file_get_contents("https://cmsmart.net/api/product_video/netbase/" . $product_id, false, stream_context_create(array('ssl' => array('verify_peer' => false, 'verify_peer_name' => false)))), true);
				if( $rs['result'] ) {
					// $data = array_slice($rs['data'], 0, 5);
					$new = array();
					foreach($rs['data'] as $k => $v) {
						$new[$k] = array(
							'title' => $v['title'],
							'description' => $v['description']
						);
						if(preg_match("/(https?:\/\/)?(www.)?(player.)?vimeo.com\/([a-z]*\/)*([0-9]{6,11})[?]?.*/", $v['description'], $output_array)) {
							$new[$k]['video_id'] = $output_array[5];
							$new[$k]['type'] = 'vimeo';
							$new[$k]['thumbnail'] = nbd_vimeo_thumbnail($output_array[5]);
						}
						
						if (preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $v['description'], $output_array)) {
							$new[$k]['video_id'] = $output_array[1];
							$new[$k]['type'] = 'youtube';
							$new[$k]['thumbnail'] = 'https://img.youtube.com/vi/'. $output_array[1] .'/maxresdefault.jpg';
						}
					}

					set_transient( 'nbd_videos', $new, 12 * HOUR_IN_SECONDS );
					$videos = $new;
				}
				

			}
		}
		
		return $videos;
	}
}

/**
 * Grab the url of a publicly embeddable video hosted on vimeo
 * @param  str $video_url The "embed" url of a video
 * @return str            The url of the thumbnail, or false if there's an error
 */
if( ! function_exists('nbd_vimeo_thumbnail')) {
	function nbd_vimeo_thumbnail($vimeo_id){
		if( !$vimeo_id ) return false;
		$data = json_decode( file_get_contents( 'http://vimeo.com/api/oembed.json?url=https://vimeo.com/' . $vimeo_id ) );
		if( !$data ) return false;
		return $data->thumbnail_url;
	}
}


/* Function which displays your post date in time ago format */
if( ! function_exists('nbd_get_time_ago') ) {
	function nbd_get_time_ago($time)
	{
	   $periods = array("second", "minute", "hour", "day", "week", "month", "year", "decade");
	   $lengths = array("60","60","24","7","4.35","12","10");

	   $now = time();

	       $difference     = $now - $time;
	       $tense         = "ago";

	   for($j = 0; $difference >= $lengths[$j] && $j < count($lengths)-1; $j++) {
	       $difference /= $lengths[$j];
	   }

	   $difference = round($difference);

	   if($difference != 1) {
	       $periods[$j].= "s";
	   }

	   return "$difference $periods[$j] ago";
	}
}