<?php

class Google_Analytics_Helper {

    /**
     * Init plugin actions.
     *
     */
    public static function init() {
    }

    /**
     * Gets data according to selected GA account.
     *
     * @param boolean $assoc
     *
     * @return mixed
     */
    public static function get_selected_account_data( $assoc = false ) {
        $data	 = json_decode( self::get_option( Google_Analytics_Admin::ALT_GA_SELECTED_ACCOUNT ) );
        $data	 = (!empty( $data ) && count( $data ) == 3 ) ? $data : false;

        if ( $data ) {
            if ( $assoc ) {
                return array(
                    'account_id'		 => $data[ 0 ],
                    'web_property_id'	 => $data[ 1 ],
                    'view_id'			 => $data[ 2 ]
                );
            } else {
                return $data;
            }
        }

        return false;
    }

    /**
     * Wrapper for WordPress method get_option
     *
     * @param string $name Option name
     *
     * @return NULL|mixed|boolean
     */
    public static function get_option( $name ) {
        $opt = get_option( $name );

        return !empty( $opt ) ? $opt : null;
    }

    /**
     * @return string
     */
    public static function get_account_id() {
        $account_id = json_decode( self::get_option( Google_Analytics_Admin::ALT_GA_SELECTED_ACCOUNT ) );

        return ! empty( $account_id[0] ) ? $account_id[0] : '';
    }

    /**
     * Checks whether users is authorized with Google.
     *
     * @return boolean
     */
    public static function is_authorized() {
        return Google_Analytics_Admin::api_client()->get_instance()->is_authorized();
    }

    public static function is_account_selected() {
        return self::get_selected_account_data();
    }

    public static function is_all_feature_disabled() {
        return self::get_option( Google_Analytics_Admin::ALT_GA_DISABLE_ALL_FEATURES );
    }

    public static function are_features_enabled() {
        return self::are_terms_accepted() && !self::is_all_feature_disabled();
    }

    /**
     * Check if terms are accepted
     *
     * @return bool
     */
    public static function are_terms_accepted() {
        return self::get_option( Google_Analytics_Admin::ALT_GA_TERMS_OPTION_NAME );
    }

    /**
     * Loads ga notice HTML code with given message included.
     *
     * @param string $message
     * $param bool $cannot_activate Whether the plugin cannot be activated
     *
     * @return string
     */
    public static function ga_oauth_notice( $message ) {
        echo '<pre>'. $message .'</pre>';
    }
}