jQuery( function( $ ) {

	/**
	 * NBCustomHandler class.
	 */
	var NBD_Dashboard = {
		init: function() {
			this.render_dashboard();
			this.call_daterange();
			this.call_slimscroll();
			$(document).on('click', '.admin-chart-range .value', this.admin_chart_range);
			$(document).on('click', '.admin-range-option span:not(.productsale-custom-range)', this.admin_range_option);
			$(document).on('click', '.productsale-custom-range', this.admin_range_show);
			$(document).on('click', '.player-online .player-thumb', this.play_video);
			$(document).on('click', '.admin-dashboard-video ul li', this.play_video_lists);

			$(window).load(function() {
				var $height = $('.player-online .player-thumb').height();
				$('.player-online .player-thumb').attr('data-height', $height);
			});
		},
		
		play_video_lists: function(e) {
			e.preventDefault();
			var $height = $('.player-online .player-thumb').attr('data-height');
			var $play_video = $(this).find('.player-thumb');
			NBD_Dashboard.embed_video($play_video, $height);
		},
		
		play_video: function() {
			var $height = $('.player-online .player-thumb').attr('data-height');
			NBD_Dashboard.embed_video($(this), $height);
		},
		
		embed_video: function($element, $height) {
			$('.admin-dashboard-video ul li').removeClass('nbd-playing');
			$element.closest('li').addClass('nbd-playing');
			var $video_id = $element.attr('data-id');
			var $type = $element.attr('data-type');
			
			
			if($type == 'youtube') {
				$html = '<iframe width="100%" height="' + $height + '" src="https://www.youtube.com/embed/' + $video_id + '" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>';
			}else {
				$html = '<iframe width="100%" height="' + $height + '" src="https://player.vimeo.com/video/' + $video_id + '?autoplay=1" frameborder="0" title="How to set NBT Solution plugin for Prinshop Solution?" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
			}
			
			$('.player-online .player-thumb').html($html);
			
		},
		
		call_slimscroll: function() {
			
			if(jQuery().slimScroll) {
				$('.admin-dashboard-changelog .admin-dashboard-wrap-scroll').slimScroll({
					height: 425,
					railVisible: true,
					alwaysVisible: true
				});
				
				$('.admin-dashboard-video:not(.no-scroll) .admin-dashboard-wrap-scroll').slimScroll({
					height: 474,
					railVisible: true,
					alwaysVisible: true
				});
				
				$('.admin-dashboard-reviews .admin-dashboard-wrap-scroll').slimScroll({
					height: 300,
					railVisible: true,
					alwaysVisible: true
				});	
			}				
		},
		call_daterange: function() {
			if( jQuery().daterangepicker ) {
				$('input[name="datefilter"]').on('apply.daterangepicker', function(ev, picker) {
					$(this).val(picker.startDate.format('YYYY/MM/DD') + '-' + picker.endDate.format('YYYY/MM/DD'));
					
					$(this).closest('.admin-chart-range').find('.value').html(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY') + '<i class="adminpanel-icon-arrow-down"></i>');
					var w = $(this).closest('.admin-chart-range').find('.value').outerWidth();

					$('input[name="datefilter"]').css("width", w);
					
					NBD_Dashboard.admin_range_chart();

				});

				$('input[name="datefilter"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
				});
				
				$('input[name="datefilter"]').daterangepicker({
					autoUpdateInput: false,
					locale: {
					  cancelLabel: 'Clear'
					}
				});
			}			
		},
		
		admin_range_chart: function() {
			var val = 'custom-range';
			var $date = $('input[name="datefilter"]').val();

			var action_json = nbdashboard.json_url.replace("%action%", "product_sales");
			
			$.ajax({
				url: action_json,
				data: 'range=date&filter=' + $date,
				type: 'POST',
				datatype: 'json',
				success: function( response ) {
					
					$('.admin-price').html(response.rev);

					$('.admin-dashboard-chartsales .admin-dashboard-canvas').html('<canvas id="' + val + '" height="285" style="width: 100%; height: 285px;"></canvas>');

					var canvas = document.getElementById(val);
					var ctx = canvas.getContext("2d");

					var lineChartData = {
						labels : response.horizontal,
						datasets : [
							{
								label: "My Second dataset",
								backgroundColor: "rgb(154, 203, 232, 0.3)",
								borderColor: "rgb(154, 203, 232, 1)",
								borderWidth: 2,
								pointBackgroundColor: "rgb(154, 203, 232, 1)",
								pointBorderColor: "#fff",
								pointBorderWidth: 1,
								pointHoverRadius: 5,
								pointHoverBackgroundColor: "#fff",
								pointHoverBorderColor: "rgb(154, 203, 232, 1)",
								pointHoverBorderWidth: 1,
								pointRadius: 4,
								pointHitRadius: 10,
								data: response.vertical

							}
						]
					}

					var myNewChart = new Chart(ctx , {
						type: "line",
						data: lineChartData,
						responsive: true,
						scaleFontFamily: "'Open Sans'",
						tooltipTitleFontFamily: "'Open Sans'",
						options: {
							responsive: true,
							legend: {
								display: false,
							},
							tooltips: {
								callbacks: {
									label: function(tooltipItem, data) {
										//console.log(tooltipItem);
										price = data['datasets'][0]['data'][tooltipItem['index']];
										price = number_format(price, nbdashboard.decimals, nbdashboard.decimal_separator, nbdashboard.thousand_separator);
										return ' ' + tooltipItem.xLabel + ' (' + nbdashboard.format_money.replace("number", price) + ')';
									},
									title: () => null,
								}
							}
						},
					});

				},
				error:function(){
					alert('There was an error when processing data, please try again !');
					nbt_ajax_cart_load.unblock($li);
				}
			})
		},
		
		admin_range_show: function() {
			$('input[name="datefilter"]').trigger('click');
			$('.admin-range-option').hide();
		},
		
		admin_range_option: function() {
			var $this = $(this);
			var val = $(this).attr('data-value');
			var label = $(this).text();
			
			$this.closest('.admin-chart-range').find('.value').html(label + '<i class="adminpanel-icon-arrow-down"></i>');
			$this.closest('.admin-chart-range').find('.admin-range-option').hide();
			
            var action_json = nbdashboard.json_url.replace("%action%", "product_sales");
			
			$.ajax({
				url: action_json,
				data: 'filter=' + val,
				type: 'POST',
				datatype: 'json',
				success: function( response ) {
					$('.admin-price').html(response.rev);
					$('.admin-dashboard-chartsales .admin-dashboard-canvas').html('<canvas id="' + val + '" height="285" style="width: 100%; height: 285px;"></canvas>');

					var canvas = document.getElementById(val);
					var ctx = canvas.getContext("2d");

					var lineChartData = {
						labels : response.horizontal,
						datasets : [
							{
								label: "My Second dataset",
								backgroundColor: "rgb(154, 203, 232, 0.3)",
								borderColor: "rgb(154, 203, 232, 1)",
								borderWidth: 2,
								pointBackgroundColor: "rgb(154, 203, 232, 1)",
								pointBorderColor: "#fff",
								pointBorderWidth: 1,
								pointHoverRadius: 5,
								pointHoverBackgroundColor: "#fff",
								pointHoverBorderColor: "rgb(154, 203, 232, 1)",
								pointHoverBorderWidth: 1,
								pointRadius: 4,
								pointHitRadius: 10,
								data: response.vertical

							}
						]
					}

					var myNewChart = new Chart(ctx , {
						type: "line",
						data: lineChartData,
						responsive: true,
						scaleFontFamily: "'Open Sans'",
						tooltipTitleFontFamily: "'Open Sans'",
						options: {
							responsive: true,
							legend: {
								display: false,
							},
							tooltips: {
								callbacks: {
									label: function(tooltipItem, data) {
										//console.log(tooltipItem);
										price = data['datasets'][0]['data'][tooltipItem['index']];
										price = number_format(price, nbdashboard.decimals, nbdashboard.decimal_separator, nbdashboard.thousand_separator);
										return ' ' + tooltipItem.xLabel + ' (' + nbdashboard.format_money.replace("number", price) + ')';
									},
									title: () => null,
								}
							}
						},
					});

				},
				error:function(){
					alert('There was an error when processing data, please try again !');
				}
			})
		},
		
		admin_chart_range: function() {
			if( $(this).hasClass('active') ) {
				$(this).removeClass('active');
				$('.admin-range-option').hide();
			}else {
				$(this).addClass('active');
				$('.admin-range-option').show();
			}
		},
		
		render_dashboard: function() {
			var $wrap = $('#dashboard-widgets-wrap').closest('.wrap');
			var $tpl = $('#tpl-nb-dashboard').html();
			
			$wrap.attr('id', 'nb-dashboard-wrap');
			$wrap.html($tpl);
			
			$('.notice, .woocommerce-message').remove();
		}
	}
	
	NBD_Dashboard.init();
	
});