jQuery( function( $ ) {
	
	var ajax_notification = false;

	/**
	 * NBCustomHandler class.
	 */
	var NBD_Admin = {
		init: function() {
			
			this.render_menubar();
			this.render_menumain();
			this.render_menubar_scroll();
			
			$( window ).resize(function() {
				NBD_Admin.render_menubar_scroll();
			});
			
			$(document).on( 'click', 'body.wp-admin:not(.folded) #adminmenu > li.wp-has-submenu > a:not(.toplevel_page_dashboard)', this.click_menu_left);
			$(document).on('click', '.nb-upload-image-button', this.upload_image);
			$(document).on( 'click', '.nb-remove-image-button', this.remove_upload_image);
			$(document).on('click', '#alt_ga_authorize_google', this.authorize);
			$(document).on('click', '.pc-has-sublink', this.show_profiles_menu);
			$(document).on('click', '.link-logout', this.link_logout);
			$(document).on('change', '#nb_dashboard_cf7', this.change_wpcf7);
			$(document).on('hover', '.pc-notifications', this.read_notification);
			$(document).on('click', '.hamburger--elastic', this.menu_hamburger);
			
			
			$(window).load(function() {
				NBD_Admin.heading();
				$('.nbd-loading').remove();
			});
			
			$('#admin-search').keyup(function(e) {
				clearTimeout($.data(this, 'timer'));
				if (e.keyCode == 13)
				  search(true);
				else
				  $(this).data('timer', setTimeout(NBD_Admin.trigger_search, 500));
			});
			
			$(document).mouseup(function(e) 
			{
				if($(".nbd-search-rs").length){
				    var container = $(".nbd-search-rs");

				    if ( ! container.is(e.target) && container.has(e.target).length === 0 ) 
				    {
						container.hide();
						$('#admin-search').val('');
				    }
				}
			});
		},
		
		trigger_search: function(force) {
			var action_json = nbdashboard.json_url.replace("%action%", "live_search");
			var existingString = $("#admin-search").val();
			if (!force && existingString.length < 3) return; //wasn't enter, not > 2 char
				$.ajax({
					url: action_json,
					data: { search: existingString },
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {		
							$('.pc-admin-header-search .nbd-search-rs ul').html(response.html);
							$('.pc-admin-header-search .nbd-search-rs').show();
						}
					},
					error: function() {
						//alert('There was an error when processing data, please try again !');
					}
				});
		},
		
		menu_hamburger: function() {
			if( $(this).hasClass('is-active') ) {
				$(this).removeClass('is-active');
				$('#wpwrap').removeClass('wp-responsive-open');
			}else {
				$(this).addClass('is-active');
				$('#wpwrap').addClass('wp-responsive-open');
			}
			
		},
		
		
		read_notification: function() {
			var count = $(this).attr('data-count');

			if( ! ajax_notification ) {
				ajax_notification = true;
				
				var action_json = nbdashboard.json_url.replace("%action%", "read_notification");

				$.ajax({
					url: action_json,
					data: {},
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {
							$('.pc-notifications-count').text(response.count);
						}
					},
					error: function() {
						//alert('There was an error when processing data, please try again !');
					}
				});
				
			}
		},
		
		change_wpcf7: function(e) {
			e.preventDefault();
			
			var $cf7id = $(this).val();
			
			if( $cf7id ) {
				
				var action_json = nbdashboard.json_url.replace("%action%", "cf7field");

				$.ajax({
					url: action_json,
					data: { id: $cf7id},
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {
							$('#nb_dashboard_cf7_field').find('select').html(response.fields);
							$('#nb_dashboard_cf7_field').show();
						}
					},
					error: function() {
						alert('There was an error when processing data, please try again !');
					}
				});
			}else{
				$('#nb_dashboard_cf7_field').hide();
			}
		},
		
        link_logout: function(event) {
            event.isDefaultPrevented();

            var action_json = nbdashboard.json_url.replace("%action%", "logout");

            $.ajax({
                url: action_json,
                data: {},
                type: 'POST',
                datatype: 'json',
                success: function( response ) {
					if( response.complete != undefined ) {
                        window.location.href = response.location;
					}
                },
                error: function() {
                    alert('There was an error when processing data, please try again !');
                }
            })
		},
		
		show_profiles_menu: function(event) {
			event.preventDefault();
			$('.admin-submenu').hide();

			var $this = $(this).closest('li');
			if( $(this).hasClass('active') ) {
				$(this).removeClass('active');
				$this.find('.admin-submenu').hide();
			}else {
				$(this).addClass('active')
				$this.find('.admin-submenu').show();
			}
		},
		
		authorize: function (e, url) {
            console.log(nbdashboard.authorize);
            e.preventDefault();
            const p_width = Math.round(screen.width / 2);
            const p_height = Math.round(screen.height / 2);
            const p_left = Math.round(p_width / 2);
            const p_top = 200;
            window.open(nbdashboard.authorize, 'ga_auth_popup', 'width=' + p_width + ',height='
                + p_height + ',top=' + p_top + ',left=' + p_left);
        },
		
		upload_image: function(e){
			e.preventDefault();
			var $button = $( this ).closest('.nb-wrap-image');

			// If the media frame already exists, reopen it.
			if ( frame ) {
				frame.open();
				return;
			}
			
			// Create the media frame.
			var frame = wp.media.frames.downloadable_file = wp.media({
				title   : 'NB Dashboard Logo',
				button  : {
					text: 'Use image'
				},
				multiple: false
			});
			
			console.log(frame);


			// When an image is selected, run a callback.
			frame.on( 'select', function () {
				var attachment = frame.state().get( 'selection' ).first().toJSON();
				$button.addClass('class_name' + attachment.id);
				$button.find( 'input.nb-image' ).val( attachment.id );
				$button.find( 'input.nb-image-url' ).val( attachment.sizes.full.url );
				$button.find( '.nb-remove-image-button' ).show();
				$button.find( 'img' ).attr( 'src', attachment.sizes.thumbnail.url );
			} );

			// Finally, open the modal.
			frame.open();
		},
		
		remove_upload_image: function(){
			var $button = $( this );

			$button.siblings( 'input.nb-image' ).val( '' );
			$button.siblings( '.nb-remove-image-button' ).show();
			$button.parent().prev( '.nb-image-thumbnail' ).find( 'img' ).attr( 'src', $( this ).closest('tr').attr('data-src') );

			return false;
		},
		
		heading: function() {
			if( $('#nb-dashboard-wrap').length <= 0 ) {
				$('.wp-heading-inline, .page-title-action, .wrap > h1').addClass('page-section');
				$( ".page-section" ).wrapAll( "<div class='admin-heading' />");	
			}
			
			if( $('.wrap h1.page-section').length > 0 ) {
				$('.wrap').addClass('wrap-top');
			}
			
			$('.admin-heading h1').append('<div class="hamburger hamburger--elastic" tabindex="0" aria-label="Menu" role="button" aria-controls="navigation"><div class="hamburger-box"><div class="hamburger-inner"></div></div><span class="hamburger-label">Menu</span></div>');
		},
		
		
		
		render_menubar: function() {
			var $tpl = $('#tpl-nb-dashboard-menubar').html();
			$('#wpadminbar').html($tpl);
		},
		
		
		render_menubar_scroll: function() {
			if(jQuery().slimScroll) {
				var $width = $(window).width();
				var $height = $(window).height() - $('#wpadminbar').outerHeight();
				

				
				if( $width > 960 ) {
                    $('#adminmenu').slimScroll({
                        height: $height,
                        railVisible: true,
                        alwaysVisible: true
                    });
				}
				
				if( $width < 782 ) {
                    $('#adminmenu').slimScroll({
                        height: $height,
                        railVisible: true,
                        alwaysVisible: true
                    });
				}
				
				if( $( ".pc-notifications-submenu ul li" ).length > 5 ) {
					var $notificationScroll = $('.pc-notifications-submenu ul').slimScroll({
						height: 450,
						railVisible: true,
						alwaysVisible: true
					});
					
					// $notificationScroll.slimScroll().bind('slimscrolling', function (e, pos) {
						// var $height = $('.pc-notifications-submenu .slimScrollDiv').height();
						// var docViewTop = $('.pc-notifications-submenu ul').scrollTop();
						// var docViewBottom = docViewTop + $('.pc-notifications-submenu ul').height();
						

						
						// var fruits = [];
						// $( ".pc-notifications-submenu li" ).each(function( index ) {
							// var elemTop = $(this).offset().top;
							// var elemBottom = elemTop + $(this).height();

							// if(docViewBottom >= elemTop && docViewTop <= elemBottom) {
								// fruits.push($(this).attr('id'));
							// }
						// });
						// console.log(max);
						// console.log(docViewTop);
						
						
						// var action_json = nbdashboard.json_url.replace("%action%", "read_notification");
						// console.log(action_json );
						// $.ajax({
							// url: action_json,
							// data: { data: JSON.parse(JSON.stringify(fruits)) },
							// type: 'POST',
							// datatype: 'json',
							// success: function( response ) {
								// if( response.complete != undefined ) {
									// window.location.href = response.location;
								// }
							// },
							// error: function() {
								// //alert('There was an error when processing data, please try again !');
							// }
						// });
					// });
				}
			}
		},
		
		render_menumain: function() {
			$('.wp-menu-separator').remove();
			$('#adminmenu .wp-has-submenu .wp-menu-name').append('<i class="adminpanel-icon-arrow-right"></i>');
		},
		
		click_menu_left: function() {
			var $ul = $(this).next();
			var $li = $(this).closest('li');

			if( $li.hasClass('menu-current') ) {
				if( $li.hasClass('menu-current') ) {
					$ul.slideUp();
					$li.removeClass('menu-current');
				}else {
					$ul.slideDown();
					$li.addClass('menu-current');
				}
			}else {
				if( $li.hasClass('wp-menu-open') ) {
					console.log(22222222);
					$ul.slideUp();
					$li.removeClass('wp-menu-open');
				}else {
					$ul.slideDown();
					$li.addClass('wp-menu-open');
				}
				
				NBD_Admin.render_menubar_scroll();
			}

			return false;
		}
		
	}
	
	NBD_Admin.init();
	
});