<?php
/*
	Plugin Name: Netbase Tour
	Plugin URI: http://netbaseteam.com/
	Description: Portfolio Plugin for NBCORE theme.
	Version: 1.0
	Author: NBTeam
	Text Domain: nb-tour
	Author URI: http://themeforest.net/user/netbaseteam
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

define( 'NBT_TOUR_DIR', dirname( __FILE__) );
define( 'NBT_TOUR_ASSET_JS', plugins_url( 'js', __FILE__ ) );
define( 'NBT_TOUR_ASSET_CSS', plugins_url( 'css', __FILE__ ) );
define( 'NBT_TOUR_ASSET_IMG', plugins_url( 'img', __FILE__ ) );

class NB_Tour {
	
    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NBT_Envato_API
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
	
    /**
     * SmartDesk constructor.
     *
     * @since 0.0.1
     */
    private function __construct() {
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue_scripts' ) );
		add_action('wp_enqueue_scripts', array( __CLASS__, 'embed_style') );
		
		include NBT_TOUR_DIR . '/inc/frontend.php';
		include NBT_TOUR_DIR . '/inc/backend.php';

		nbTour_Frontend::instance();
		nbTour_Backend::instance();
	}
	
	public static function admin_enqueue_scripts() {
		wp_enqueue_style( 'jquery-nbtour', NBT_TOUR_ASSET_CSS . '/nbtour.css' );
		wp_enqueue_script( 'js-cookie', NBT_TOUR_ASSET_JS . '/js.cookie.min.js' , '', '', true );
		
		wp_enqueue_script( 'js-md5', NBT_TOUR_ASSET_JS . '/jquery.md5.js' , array(), '', true );
		
		wp_enqueue_script( 'jquery-nbtourjs', NBT_TOUR_ASSET_JS . '/jquery.nbtour.js' , array() );
		wp_localize_script( 'jquery-nbtourjs', 'nbtour_params', array(
			'data' => apply_filters( 'nbtour_backend', array() )
		));
		
		wp_enqueue_script( 'jquery-nbtour-custom', NBT_TOUR_ASSET_JS . '/nbtour-admin.js' , '', '', true );
	}
	
	public static function embed_style() {
		wp_enqueue_style( 'jquery-nbtour', NBT_TOUR_ASSET_CSS . '/nbtour.css',false,'1.1','all');
		
		wp_enqueue_script( 'js-cookie', NBT_TOUR_ASSET_JS . '/js.cookie.min.js' , '', '', true );
		wp_enqueue_script( 'js-md5', NBT_TOUR_ASSET_JS . '/jquery.md5.js' , '', '', true );
		wp_enqueue_script( 'jquery-nbtourjs', NBT_TOUR_ASSET_JS . '/jquery.nbtour.js' , '', '', true );
		
		wp_localize_script( 'jquery-nbtourjs', 'nbtour_params', array(
			'data' => apply_filters( 'nbtour_frontend', array() ),
			'clicker' => NBT_TOUR_ASSET_IMG . '/clicker.png'
		));
		
		wp_enqueue_script( 'jquery-nbtour-custom', NBT_TOUR_ASSET_JS . '/nbtour-custom.js' , '', '', true );
	}
}

add_action( 'plugins_loaded', array( 'NB_Tour', 'instance' ) );