jQuery( function( $ ) {
	var nb_effect = 'bounceIn';
	
	function nbtour_remove() {
		$('.nbtour-backdrop, .nbtour-step-background, .nbt-tour-pop, .nbtour-tooltips-center-button').remove();
		$('.nbtour-step-backdrop').removeClass('nbtour-step-backdrop');
		$('.has-nbtour').removeClass('has-nbtour');
		$('.nbtour-step-backdrop').removeAttr('style');
		$('.nbtour-hand').remove();	
	}
	
	/* Event OK GOT IT */
	$(document).on('click', '.ok-got-it', function() {
		var $el = $('.nbtour-tooltips-center-button .ok-got-it').attr('data-element');
		Cookies.set( $.md5($el), $el);
		nbtour_remove();
	});
	
	/* Event SKIP INTRO */
	$(document).on('click', '.skip-intro', function() {
		nbtour_remove();
	});
	
	/* Save click */
	$(document).on('click', '.nbtour-step-click', function() {
		console.log('%c--- NBTOUR: EVEN CLICK ---', 'background: #ccc; color: #444; padding: 5px 15px;' );
		
		var step = parseInt( $(this).attr('data-next-step') );
		var data = nbtour_params.data[Cookies.get('nbtour_key')];

		Cookies.set('nbtour_element', data[step].element);
		Cookies.set('nbtour_step', step);
	});
	
	
	/* START: Event click LIST BULLET */
	$(document).on('click', '.nbtour-bullets li', function() {
		console.log('%c--- NBTOUR: JUMP BULLET ---', 'background: #222; color: #bada55; padding: 5px 15px;' );
		
		var index = $('.nbtour-bullets li.active').index();
		var stepnumber = ($(this).find('a').attr('data-stepnumber') - 1);

		/* Init Action */
		$.each(nbtour_params.data, function(element, array) {
			var nbtour_key = Cookies.get( 'nbtour_key');

			if( nbtour_key == element ) {
				var skip_data = array[stepnumber];
				
				if( $( skip_data.element ).length ) {
					$( skip_data.element ).nbTour({
						backdrop: true,
						data: array,
						step: stepnumber,
						key: nbtour_key,
						cookie: true
					});
				}
			}
		});
	});
	/* END: Event click LIST BULLET */
	
	/* START: Trigger event Prev, Next keyboard */
	$(document).keyup(function(event) {
		if( event.which == 37) {
			$('.nbt-tour-pop [data-role="prev"]').trigger('click');
		}
		
		if( event.which == 39) {
			$('.nbt-tour-pop [data-role="next"]').trigger('click');
		}
	});
	/* END: Trigger event Prev, Next keyboard */
		
	/* START: End tour */
	$(document).on('click', '.nbt-tour-pop [data-role="end"]', function() {
		Cookies.set('nbtour_tour', ( parseInt(Cookies.get('nbtour_key')) + 1) );
		Cookies.set('nbtour_step', 0 );
		Cookies.set('nbtour_element', '' );
		
		nbtour_remove();
		
		return false;
	});
	/* END: End tour */
		
	$.fn.nbTour = function(options) {
    	var defaults = {
			backdrop: false,
			backdrop_html_all: '<div class="nbtour-backdrop"></div>',
			backdrop_html_bg: '<div id="1" class="nbtour-step-background"><span class="nbtour-number">1</span></div>',
			lists_li: '<li><a role="button" tabindex="0" data-stepnumber="1">&nbsp;</a></li>',
			backdrop_html: '<div class="nbtour-backdrop"></div><div class="nbtour-step-background"><span class="nbtour-number">1</span></div>',
			template: '<div id="1" class="nbt-tour-pop"><div class="nbtour-arrow"></div><h3 class="nbtour-title"></h3><div class="nbtour-content"></div><div class="nbtour-bullets"><ul></ul></div><div class="nbtour-navigation"><div class="btn-group"><button class="btn btn-sm btn-default disabled" data-role="prev" disabled="" tabindex="-1"><span>«</span> Prev</button> <button class="btn btn-sm btn-default" data-role="next">Next <span>»</span></button></div><button class="btn btn-sm btn-default" data-role="end">End tour</button></div></div>',
			template_center: '<div class="nbtour-tooltips-center-button"><a class="ok-got-it" role="button">Got It</a><a class="skip-intro" role="button">Skip</a></div>',
			template_hand: '<div class="nbtour-hand"><img src="' + nbtour_params.clicker + '"></div>',
			data: false,
			step: 0,
			key: 0,
			scroll: true,
			cookie: false,
			toggle: false
        };
		
		var $this = $(this);
		var settings = $.extend(defaults, options);

		
		/* Repeater Li */
		if( typeof settings.data[0].toggle == 'undefined' ) {
			if( settings.backdrop && ! $('.nbtour-backdrop').length ) {
				$('body').append(defaults.backdrop_html);
			}
			
			if( ! $('.nbt-tour-pop').length ) {
				$('body').append(defaults.template);
			}
			
			if( ! $('.nbtour-hand').length ) {
				$('body').append(defaults.template_hand);
			}
			
			var bullets = '';
			$.each(settings.data, function( index, value ) {
				lists_li = defaults.lists_li.replace(/data-stepnumber="([0-9])"/g, 'data-stepnumber="' + (index + 1) + '"');
				
				if( index == 0) {
					bullets += lists_li.replace(/<li>/g, '<li class="active">');
				}else {
					bullets += lists_li;
				}
			});
			
			$('.nbt-tour-pop ul').html(bullets);
			Cookies.set('nbtour_data', settings.step);
			$('.nbtour-number').text( settings.step + 1 );
			$this.myfunction($this, settings, settings.data[settings.step], settings.step, settings.data[0].element);
		}else {
			$('.nbtour-bullets').remove();
			$this.nbtour_show($this, settings, settings.data[settings.step], settings.step, settings.data[0].element);
		}

		var evt = settings.data[0].type;
		
		/* Add next step */
		
		var fstep = settings.step + 1;
		if( typeof settings.data[fstep] != 'undefined' && settings.data[fstep].type == 'click') {
			console.log('%c--- NBTOUR: ADD NEXT STEP ---', 'background: #ccc; color: #444; padding: 5px 15px;' );
			console.log('KEY: ' + settings.key);
			
			$('.nbtour-step-backdrop').addClass('nbtour-step-click');
			$('.nbtour-step-backdrop').attr('data-next-step', fstep);
		}
		Cookies.set('nbtour_key', settings.key);
		
		

		/* On click */
		$(document).on('click', '.btn-group .btn', function() {
			var $wrapper = $('.nbt-tour-pop');
			var role = $(this).attr('data-role');
			var step = parseInt($wrapper.attr('data-step'));
			var total = settings.data.length;

			console.log('---------CLICK----------');
			console.log(step);
			
			/* Next Tour */
			if( role == 'next' ) {
				$('.nbtour-step-backdrop').removeAttr('style');
				var next_step = (step + 1);
				var evt = settings.data[step].type;

				// if( next_step > 0) {
					// $('.nbt-tour-pop [data-role="prev"]').removeClass('disabled');
					// $('.nbt-tour-pop [data-role="prev"]').prop('disabled', false);
				// }

				if( settings.data[next_step] != undefined ) {
					var $element = settings.data[next_step];
					
					if( $($element.element).length > 0 ) {
						/* Event Click */
						if( $element.type == 'link' ) {
							console.log('--------- EVENT CLICK JUMP PAGE ----------');
							
							Cookies.set('nbtour_data', settings.data[0].element);
							Cookies.set('nbtour_element', $element.element);
							Cookies.set('nbtour_step', next_step);
							
							window.location.href = $element.link;
							
							return;
						}
						
						$('.nbtour-step-backdrop').removeClass('nbtour-step-backdrop');
						$('.nbTour-active').removeClass('nbTour-active');
						
						$this.myfunction($($element.element), settings, $element, next_step, $element.element);
						
						// if(next_step == (total-1) ) {
							// $('.nbt-tour-pop [data-role="next"]').addClass('disabled');
							// $('.nbt-tour-pop [data-role="next"]').prop('disabled', true);
						// }
					}else {
						console.log(nb_effect);
						/* Not found element */
						if( ! $('.nbtour-step-backdrop').hasClass('nbTour-active') ) {
							$('.nbtour-step-backdrop').addClass(nb_effect + ' animated');
							
							setTimeout(function(){
								$('.nbtour-step-backdrop').removeClass(nb_effect + ' animated');
							}, 1000);

							return;
						}
					}
				}
				//$('.nbtour-bullets li').removeClass('active');
				//$('.nbtour-bullets li:nth-child(' + (next_step + 1) + ')').addClass('active');
				
			}
			
			
			if( role == 'prev' ) {
				var prev_step = (step - 1);
				
				if( settings.data[prev_step] != undefined) {
					var $element = settings.data[prev_step];
					

					// var fixed = $('.nbtour-step-backdrop').attr('data-margin-top');
					// if( fixed ) {
						// $('.nbtour-step-backdrop').css("margin-top", fixed);
						// console.log(fixed);	
					// }
	
					
					$this.myfunction( $($element.element), settings, $element, prev_step, $element.element );
					
					// $('.nbt-tour-pop [data-role="next"]').removeClass('disabled');
					// $('.nbt-tour-pop [data-role="next"]').prop('disabled', false);
						
					// if(prev_step == 0 ) {
						// $('.nbt-tour-pop [data-role="prev"]').addClass('disabled');
						// $('.nbt-tour-pop [data-role="prev"]').prop('disabled', true);
					// }
				}
					
				var current_step = parseInt( $('.nbt-tour-pop').attr('data-step') );
				var fixed = $(settings.data[current_step].element).attr('data-margin-top');
				if(fixed) {
					$(settings.data[current_step].element).css("margin-top", fixed);
					console.log('%c--- NBTOUR: PREV ---', 'background: #ccc; color: #444; padding: 5px 15px;' );
					console.log(current_step);
					console.log('-----------------------------------');
				}

			}
		});
		


        return this;
	}
	
	$.fn.myfunction = function ($this, settings, data, step, el) {
		
		/* Check element exists */
		if( $this.length <= 0 ) {
			
			if( typeof data.link != 'undefined' ) {
				Cookies.set('nbtour_step', step);
				
				window.location.href = data.link;
				
				return;
			}
			
		}
		
		
		
		$('body').addClass('has-nbtour');
		$this.addClass('nbtour-step-backdrop');

		/* Set Message */
		if( data.title ) {
			$('.nbtour-title').html(data.title);
		}else {
			$('.nbtour-title').hide();
		}
		
		if( data.content ) {
			$('.nbtour-content').html(data.content);
		}
		
		$('.nbtour-navigation button[data-role="end"]').attr('data-element', el);
		
		var $wrapper = $('.nbt-tour-pop');
		var $hand = $('.nbtour-hand');
		var pos = $this.offset();
		var pos_width = $this.outerWidth();
		var pos_height = $this.outerHeight();

		data_top = parseInt( pos.top );
		data_left = parseInt( pos.left );
		
		$wrapper.attr('data-step', step);
		$wrapper.css({ display: 'block' });
		
        actualWidth = $wrapper[0].offsetWidth;
        actualHeight = $wrapper[0].offsetHeight;

		
		var offset_background_popup = 0;
		if( typeof data.offset_popup != 'undefined' && data.offset_popup ) {
			if( typeof data.offset_popup.top != 'undefined' && data.offset_popup.top ) {
				var offset_background_popup = data.offset_popup.top;
			}
		}
		
		var admin_height = 0;
		if( $('#wpadminbar').length ) {
			admin_height = -32;
		}
		
        switch ( data.position ) {
          case 'bottom':
			arrow = 'top';
            tp = {top: (data_top + pos_height)+10, left: data_left + pos_width / 2 - actualWidth / 2}
            break
          case 'top':
			arrow = 'bottom';
            tp = {top: (data_top - actualHeight)-20, left: data_left + pos_width / 2 - actualWidth / 2}
            break
          case 'left':
			arrow = 'right';
            tp = {top: (data_top + pos_height / 2 - actualHeight / 2)-10, left: (data_left - actualWidth)-20}
            break
          case 'right':
			arrow = 'left';
            tp = {top: ((data_top + pos_height / 2 - actualHeight / 2) + offset_background_popup) + admin_height, left: (data_left + pos_width)+25}
            break
        }

		$wrapper.removeClass('right left top right').addClass(arrow);
		$wrapper.attr('data-type', data.type);
		
		var backdrop_height = $this.height() / 2;
		var backdrop_offset_top = parseInt( $this.offset().top );
		var backdrop_offset_left = parseInt( $this.offset().left );
		
		
		var data_top = $this.attr('data-top');
		if (typeof data_top !== typeof undefined && data_top !== false) {
			backdrop_offset_top = parseInt(data_top);
		}else {
			$this.attr('data-top', backdrop_offset_top);
		}
		
		if( settings.backdrop ) {
			var offset_background_top = 0;
			if( typeof data.offset_background != 'undefined' && data.offset_background ) {
				if( typeof data.offset_background.top != 'undefined' && data.offset_background.top ) {
					var offset_background_top = data.offset_background.top;
				}
			}
			$('.nbtour-step-background').removeClass('left right top bottom');
			$('.nbtour-step-background').addClass(arrow);
			$('.nbtour-step-background').css({
				width: (pos_width + 28),
				height: (pos_height + 28),
				display: 'block',
				top: (backdrop_offset_top + offset_background_top) + admin_height,
				left: backdrop_offset_left - 15
			});
		}
		
		if( typeof data.hand != 'undefined' ) {
			$('.nbtour-hand').show();
			var $el_hand = $(data.hand);
			var $hand_width = parseInt($('.nbtour-hand').width()) + 23;
			
			var $hand_top = parseInt($el_hand.offset().top) - 9;
			var $hand_left = parseInt($el_hand.offset().left) - $hand_width;

			$hand.css({top: $hand_top, left: $hand_left });
			
			console.log($el_hand.height());
		}else {
			$('.nbtour-hand').hide();
		}

		
		$wrapper.css(tp);
		
		

		
		setTimeout(function(){
			var estep = parseInt(step) + 1;
			$('.nbtour-number').text( estep );
			$('.nbtour-step-backdrop').not($this).removeClass('nbTour-active');
			$('.nbtour-step-backdrop').not($this).removeClass('nbtour-step-backdrop');
		}, 200);
		
		if( settings.scroll ) {
			$('html, body').animate({ scrollTop: ($this.offset().top - actualHeight)}, 1000);
		}
		
		/* Write Event */
		var evt = data.type;
		$(document).on(evt, '.nbtour-step-backdrop', function() {
			var next_step = parseInt(step) + 1;
			$(this).addClass('nbTour-active');
			
			if( settings.data[next_step].element != undefined ) {
				Cookies.set('nbtour_data', settings.data[0].element);
				Cookies.set('nbtour_element', settings.data[next_step].element);
				Cookies.set('nbtour_step', next_step);
			}
		});
		
		var tooltips_count = (settings.data.length - 1);
		
		/* Prev, Next style */
		console.log('%c--- NBTOUR: PREV, NEXT BUTTON ---', 'background: #ccc; color: #444; padding: 5px 15px;' );
		var prev_step = parseInt(step) - 1;
		var current_step = parseInt(step) + 1;
		
		
		/* Prev Button */
		if( prev_step < 0 ) {
			$('.nbt-tour-pop [data-role="prev"]').addClass('disabled');
			$('.nbt-tour-pop [data-role="prev"]').prop('disabled', true);
			
			$('.nbt-tour-pop [data-role="next"]').removeClass('disabled');
			$('.nbt-tour-pop [data-role="next"]').prop('disabled', false);
			console.log('PREV ẨN');
		}else {
			$('.nbt-tour-pop [data-role="prev"]').removeClass('disabled');
			$('.nbt-tour-pop [data-role="prev"]').prop('disabled', false);
		}
		
		/* Next Button */
		if( current_step > tooltips_count ) {
			$('.nbt-tour-pop [data-role="next"]').addClass('disabled');
			$('.nbt-tour-pop [data-role="next"]').prop('disabled', true);
			
			$('.nbt-tour-pop [data-role="prev"]').removeClass('disabled');
			$('.nbt-tour-pop [data-role="prev"]').prop('disabled', false);
			console.log('NEXT ẨN');
		}else {
			$('.nbt-tour-pop [data-role="next"]').removeClass('disabled');
			$('.nbt-tour-pop [data-role="next"]').prop('disabled', false);
		}
		
		/* Bullet CSS */
		console.log('%c--- NBTOUR: BULLET CSS ---', 'background: #ccc; color: #444; padding: 5px 15px;' );
		$('.nbtour-bullets li').removeClass('active');
		$('.nbtour-bullets li:nth-child(' + current_step + ')').addClass('active');
		
		
		/* Set next Tour */
		if( parseInt(step) >= tooltips_count ) {
			console.log('%c--- NBTOUR: NEXT TOUR ---', 'background: #ccc; color: #444; padding: 5px 15px;' );
			Cookies.set('nbtour_tour', ( parseInt(settings.key) + 1) );
			Cookies.set('nbtour_step', 0 );
			Cookies.set('nbtour_element', '' );
		}
		
		return this;
	};
	
	$.fn.nbtour_show = function ($this, settings, data, step, el) {
		
		$('body').append( settings.backdrop_html_all );
		
		var i = 1;
		$.each(settings.data, function(element, array) {			
			var $t = $(array.element);
			var $md5 = $.md5( array.element );
			
			$t.addClass('nbtour-step-backdrop');
			
			
			var backdrop_html_bg = settings.backdrop_html_bg.replace(/id="1"/g, 'id="background-' + $md5 + '"');
			$('body').append(backdrop_html_bg);
			$('#background-' + $md5).find('.nbtour-number').text(i);
			
			var template = settings.template.replace(/id="1"/g, 'id="pop-' + $md5 + '"');
			$('body').append(template);
			$('.nbtour-bullets, .nbtour-navigation').remove();
			
			var $background = $('#background-' + $md5);
			var $wrapper = $('#pop-' + $md5);
			/* Set Message */
			if( array.title ) {
				$wrapper.find('.nbtour-title').html(array.title);
			}else {
				$wrapper.find('.nbtour-title').hide();
			}
			
			if( array.content ) {
				$wrapper.find('.nbtour-content').html(array.content);
			}
			
			var pos = $t.offset();
			var pos_width = $t.outerWidth();
			var pos_height = $t.outerHeight();
			
			data_top = parseInt( pos.top );
			data_left = parseInt( pos.left );
			
			actualWidth = $wrapper.outerWidth();
			actualHeight = $wrapper.outerHeight();

			
			$wrapper.css({ display: 'block' });
			
			var offset_background_popup = 0;
			if( typeof array.offset_popup != 'undefined' && array.offset_popup ) {
				if( typeof array.offset_popup.top != 'undefined' && array.offset_popup.top ) {
					var offset_background_popup = array.offset_popup.top;
				}
			}
		
			switch ( array.position ) {
			  case 'bottom':
				arrow = 'top';
				tp = {top: (data_top + pos_height)+10, left: data_left + pos_width / 2 - actualWidth / 2}
				break
			  case 'top':
				arrow = 'bottom';
				tp = {top: (data_top - actualHeight)-20, left: data_left + pos_width / 2 - actualWidth / 2}
				break
			  case 'left':
				arrow = 'right';
				tp = {top: (data_top + pos_height / 2 - actualHeight / 2)-10, left: (data_left - actualWidth)-20}
				break
			  case 'right':
				arrow = 'left';
				tp = {top: ((data_top + pos_height / 2 - actualHeight / 2) + offset_background_popup) + admin_height, left: (data_left + pos_width)+25}
				break
			}
				
			var admin_height = 0;
			if( $('#wpadminbar').length ) {
				admin_height = -32;
			}
			
			var backdrop_height = $t.height() / 2;
			var backdrop_offset_top = parseInt( $t.offset().top );
			var backdrop_offset_left = parseInt( $t.offset().left );
			
			if( settings.backdrop ) {
				var offset_background_top = 0;
				if( typeof array.offset_background != 'undefined' && array.offset_background ) {
					if( typeof array.offset_background.top != 'undefined' && array.offset_background.top ) {
						var offset_background_top = array.offset_background.top;
					}
				}
				
				$background.addClass(arrow);
				$background.css({
					width: (pos_width + 28),
					height: (pos_height + 28),
					display: 'block',
					top: (backdrop_offset_top + offset_background_top) + admin_height,
					left: backdrop_offset_left - 15
				});
			}
			
			
			$wrapper.removeClass('right left top right').addClass(arrow);
			$wrapper.css(tp);
			
			i++;
		});
		
		$('body').append( settings.template_center );
		$('.nbtour-tooltips-center-button .ok-got-it').attr('data-element', settings.data[0].element);
	}
});


 