<?php
// Register and load the widget
function wpb_load_recentposts_widget() {
    register_widget( 'printshop_recent_posts_widget' );
}
add_action( 'widgets_init', 'wpb_load_recentposts_widget' );
 
// Creating the widget 
class printshop_recent_posts_widget extends WP_Widget {
 
	function __construct() {
		parent::__construct(
		 
			// Base ID of your widget
			'printshop_recent_posts_widget', 
			 
			// Widget name will appear in UI
			__('Printshop: Recent Posts Widget', 'printshop'), 
			 
			// Widget description
			array( 'description' => __( 'Sample widget based on WPBeginner Tutorial', 'printshop' ), ) 
		);
	}
 
	// Creating widget front-end
	public function widget( $args, $instance ) {
		global $post;
		$title = apply_filters( 'widget_title', $instance['title'] );
		 
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) )
			if($title){
				echo $args['before_title'] . $title . $args['after_title'];
			}

	    $args = array(
	      'posts_per_page'    => 8,
	      'post_type' => 'post',
	    );

	    // The Query
	    $the_query = new WP_Query( $args );

	    if ( $the_query->have_posts() ) {?>
	    <ul class="widget-post-lists">
	    	<?php while ( $the_query->have_posts() ) {
            $the_query->the_post();
            $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');?>
	    	<li>
	    		<a href="<?php echo esc_url( get_permalink( $post->ID ) );?>"><img src="<?php echo esc_url( $thumbnail[0] );?>"></a>
	    		<div class="wpl-info">
					<h6><a href="<?php echo esc_url( get_permalink( $post->ID ) );?>"><?php echo esc_attr( $post->post_title );?></a></h6>
					<p>March 13, 2016</p>
	    		</div>
	    	</li>
	    	<?php }?>
	    </ul>

		<?php
		}
		wp_reset_postdata();
		
		echo $args['after_widget'];
	}
         
	// Widget Backend 
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'New title', 'wpb_widget_domain' );
		}
		// Widget admin form
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<?php 
	}
     
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}
} // Class wpb_widget ends here