<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Video extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ) );
        add_shortcode( 'netbase_element_video', array( $this, 'shortcode_element_video' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
       
        vc_map(array(
            'name' => esc_html__('Video', 'nb-element'),
            'base' => 'netbase_element_video',
            'category' => esc_html__('PrintCart', 'nb-element'),
            'description' => esc_html__('Display video.', 'nb-element'),
            'params' => array(
                array(
                    'param_name'  => 'source',
                    'heading'     => esc_html__( 'Video Source', 'nb-element' ),
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'value'       => array(
                        __( 'Youtube', 'nb-element' ) => 'youtube',
                        __( 'Vimeo', 'nb-element' )   => 'vimeo',
                    ),
                ),
                array(
                    'param_name' => 'url',
                    'heading'    => esc_html__( 'Link To Video', 'nb-element' ),
                    'type'       => 'textfield',
                ),
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Style', 'nb-element' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Video Screen Preview', 'nb-element' ) => 'screen',
                        __( 'Player Icon', 'nb-element' )          => 'icon',
                        __( 'Image Thumbnail', 'nb-element' )      => 'image',
                    ),
                ),
                array(
                    'param_name' => 'icon_color',
                    'heading'    => esc_html__( 'Icon Color', 'nb-element' ),
                    'type'       => 'colorpicker',
                    'value'      => '#2d2d2d2',
                    'dependency' => array(
                        'element' => 'style',
                        'value'   => array( 'image', 'icon' ),
                    ),
                ),
                array(
                    'param_name'  => 'width',
                    'heading'     => esc_html__( 'Video Width (number only)', 'nb-element' ),
                    'description' => esc_html__( 'This parameter is not work on video popup', 'nb-element' ),
                    'type'        => 'textfield',
                    'value'       => 500,
                ),
                array(
                    'param_name' => 'graphic',
                    'heading'    => esc_html__( 'Upload image', 'nb-element' ),
                    'type'       => 'attach_image',
                    'dependency' => array(
                        'element' => 'style',
                        'value'   => 'image',
                    ),
                ),
                /* array(
                     'param_name' => 'align',
                     'heading'    => esc_html__( 'Video Align', 'nb-element' ),
                     'type'       => 'dropdown',
                     'value'      => array(
                         __( 'Left', 'nb-element' )   => 'tl',
                         __( 'Center', 'nb-element' ) => 'tc',
                         __( 'Right', 'nb-element' )  => 'tr',
                     ),
                 ),*/
                array(
                    'param_name' => 'shadow',
                    'heading'    => esc_html__( 'Shadow', 'nb-element' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'None', 'nb-element' )    => '',
                        __( 'Style 1', 'nb-element' ) => '1',
                        __( 'Style 2', 'nb-element' ) => '2',
                        __( 'Style 3', 'nb-element' ) => '3',
                        __( 'Style 4', 'nb-element' ) => '4',
                        __( 'Style 5', 'nb-element' ) => '5',
                        __( 'Style 6', 'nb-element' ) => '6',
                        __( 'Style 7', 'nb-element' ) => '7',
                        __( 'Style 8', 'nb-element' ) => '8',
                        __( 'Style 9', 'nb-element' ) => '9',
                    ),
                    'dependency' => array(
                        'element' => 'style',
                        'value'   => array( 'image' )
                    ),
                ),
                array(
                    'param_name' => 'popup',
                    'heading'    => esc_html__( 'Play in popup?', 'nb-element' ),
                    'type'       => 'checkbox',
                    'dependency' => array(
                        'element' => 'style',
                        'value'   => 'image',
                    ),
                ),
                array(
                    'param_name' => 'control',
                    'heading'    => esc_html__( 'Enable Control', 'nb-element' ),
                    'type'       => 'checkbox',
                    'dependency' => array(
                        'element' => 'source',
                        'value'   => 'youtube',
                    ),
                ),
                array(
                    'param_name' => 'autoplay',
                    'heading'    => esc_html__( 'Enable Auto Play', 'nb-element' ),
                    'type'       => 'checkbox',
                    'dependency' => array(
                        'element' => 'style',
                        'value'   => array( 'screen' ),
                    ),
                ),
                array(
                    'param_name'  => 'extra_class',
                    'heading'     => esc_html__( 'Extra Class Name', 'nb-element' ),
                    'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nb-element' ),
                    'type'        => 'textfield',
                ),

            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_element_video($atts, $content = null)
    {
        $html = $id = $frame_style = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'source'          => 'youtube',
                    'url'             => '',
                    'style'           => 'screen',
                    'icon_color'      => '#2d2d2d',
                    'width'           => 500,
                    'graphic'         => '',
                    /*'align'           => '',*/
                    'shadow'          => '',
                    'popup'           => '',
                    'control'         => '',
                    'autoplay'        => '',
                    'extra_class'     => '',

                ),
                $atts
            )
        );

        // Generate custom ID
        $idbox = uniqid('netbase_toolkit_video_');


        $classes = array( 'sc-video' );

        if ( $extra_class ) {
            $classes[] = $extra_class;
        }

        /*if ( $align ) {
            $classes[] = $align;
        }*/

        if ( ! empty( $shadow ) ) {
            $classes[] = 'shadow-' . $shadow;
        }

        if ( $style == 'screen' ) {
            $frame_style = 'style="max-width:' . esc_attr( $width ) . 'px";';
        }

        // Generate HTML code.

        $html .= '<div id="' . esc_attr($idbox) . '" class="netbase-toolkit ' . esc_attr( implode( ' ', $classes ) ) . '" ' . $frame_style . '>';

        if ( $source == 'youtube' ) {
            $url = explode( 'v=', $url );
            if ( isset( $url[1] ) ) {
                $url = explode( '&', $url[1] );

                $id = $url[0];

                if ( ! $id ) {
                    $url = explode( '/', $url );
                    $id = $url[ count( $url ) - 1 ];
                }
            }

            if ( $id ) {
                if ( $style == 'screen' ) {
                    $html .= '<div class="fluid-iframe pr">';
                    $html .= '<iframe class="pa" type="text/html" width="' . esc_attr( $width ) . '" height="' . intval( $width / 1.777 ) . '" src="https://www.youtube.com/embed/' . $id . '?rel=0' . ( $control ? '&controls=1' : '&controls=0' ) . ( $autoplay ? '&autoplay=1' : '' ) . '" frameborder="0"/>';
                    $html .= '</div>';
                } elseif ( $style == 'icon' ) {
                    $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup" href="https://www.youtube.com/watch?v=' . $id . '">';
                    $html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                    $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                    $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                    $html .= '</svg>';
                    $html .= '</a>';
                } else {
                    if ( ! empty( $graphic ) ) {
                        $image_id = preg_replace( '/[^\d]/', '', $graphic );
                        $image    = wp_get_attachment_image_src( $image_id, 'full' );

                        $html .= '<div class="sc-video-thumb dib pr">';
                        if ( $popup ) {
                            $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup pr" href="https://www.youtube.com/watch?v=' . $id . '">';
                            $html .= '<img  src="' . esc_url( $image[0] ) . '" width="' . esc_attr( $width ) . '" height="' . esc_attr( $image[2] ) . '" alt="Video Thumbnail" />';
                            $html .= '<svg class="pa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                            $html .= '</svg>';
                            $html .= '</a>';
                        } else {
                            $html .= '<a class="sc-yt-trigger" href="#">';
                            $html .= '<img src="' . esc_url( $image[0] ) . '" width="' . esc_attr( $width ) . '" height="' . esc_attr( $image[2] ) . '" alt="Video Thumbnail" />';
                            $html .= '<svg class="pa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                            $html .= '</svg>';
                            $html .= '</a>';
                            $html .= '<iframe class="pa" type="text/html" src="https://www.youtube.com/embed/' . $id . '?showinfo=0&enablejsapi=1' . ( $control ? '&controls=1' : '&controls=0' ) . '" frameborder="0"/>';
                        }
                        $html .= '</div>';
                    }
                }
            }
        } elseif ( $source == 'vimeo' ) {
            if ( $url ) {
                $id = (int) substr( parse_url( $url, PHP_URL_PATH ), 1 );
            }
            if ( $id ) {
                if ( $style == 'screen' ) {
                    $html .= '<div class="fluid-iframe pr">';
                    $html .= '<iframe class="pa" src="//player.vimeo.com/video/' . $id . '?rel=0' . ( $autoplay ? '&autoplay=1' : '' ) . '" width="' . esc_attr( $width ) . '" height="' . intval( $width / 1.777 ) . '" frameborder="0"></iframe>';
                    $html .= '</div>';
                } elseif ( $style == 'icon' ) {
                    $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup" href="https://www.vimeo.com/' . $id . '">';
                    $html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                    $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                    $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                    $html .= '</svg>';
                    $html .= '</a>';
                } else {
                    if ( ! empty( $graphic ) ) {
                        $image_id = preg_replace( '/[^\d]/', '', $graphic );
                        $image    = wp_get_attachment_image_src( $image_id, 'full' );
                        $html .= '<div class="sc-video-thumb dib ">';
                        if ( $popup ) {
                            $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup pr" href="https://www.vimeo.com/' . $id . '">';
                            $html .= '<img src="' . esc_url( $image[0] ) . '" width="' . esc_attr( $width ) . '" height="' . esc_attr( $image[2] ) . '" alt="Video Thumbnail" />';
                            $html .= '<svg class="pa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                            $html .= '</svg>';
                            $html .= '</a>';
                        } else {
                            $html .= '<a class="sc-vm-trigger" href="#">';
                            $html .= '<img src="' . esc_url( $image[0] ) . '" width="' . esc_attr( $width ) . '" height="' . esc_attr( $image[2] ) . '" alt="Video Thumbnail" />';
                            $html .= '<svg class="pa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                            $html .= '</svg>';
                            $html .= '</a>';
                            $html .= '<iframe class="pa" type="text/html" src="//player.vimeo.com/video/' . $id . '"?api=1 frameborder="0" />';
                            wp_enqueue_script( 'froogaloop' );
                        }
                        $html .= '</div>';
                    }
                }
            }
        }

        $html .= '</div>';

        return apply_filters('netbase_shortcode_element_video', force_balance_tags($html));
    }

}
new NB_Element_Video();
}