<?php
if (!defined('ABSPATH'))
  exit;

if (class_exists("WPBakeryShortCode")) {
  class NB_Element_Leadership extends WPBakeryShortCode {
    function __construct() {
      add_action( 'init', array( $this, 'map' ) );
      add_shortcode( 'vc_printshop_leadership', array( $this, 'vc_printshop_leadership' ) );
    }

    public function map() {
      vc_map( array(
        "name" => __( "Leadership Team", "printshop" ),
        "base" => "vc_printshop_leadership",
        "class" => "",
        "category" => __( "PrintCart", "printshop"),
        "params" => array(
          array(
            'type' => 'param_group',
            'value' => '',
            'heading' => __('Lists', 'nb-fw'),
            'param_name' => 'add_vc_leadership_lists',
            'group' => __('Content Options', 'nb-fw'),
            // Note params is mapped inside param-group:
            'params' => array(
              array(
                "type" => "attach_image",
                'group' => __('Content Options', 'nb-fw'),
                "heading" => __( "Avatar", "printshop" ),
                "param_name" => "add_vc_leadership_avatar",
                "value" => '',
              )
            )
          ),
          array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __( "Limit", "printshop" ),
            "param_name" => "vc_tab_product_limit",
            "value" => 8,
          )
        )
     ));
    }

    public function vc_printshop_leadership($atts, $content = null) {
      extract( shortcode_atts( array(
        'vc_tab_product_limit' => 8
      ), $atts ) );
    
    
      ob_start();
      $add_vc_leadership_lists = vc_param_group_parse_atts($atts['add_vc_leadership_lists']);
      if($add_vc_leadership_lists) {
      ?>
      <div class="vc-leadership vc-getto-info">
          <div class="vc-getto-para">
            <h2 class="vc-heading-title">The Leadership Team</h2>
            <p>Meet our leadership team – the senior brains behind the brand. Each member of our top team are united by a love of print and great design.</p>
          </div>
    
          <div class="vc-leadership-lists">
            <?php foreach ($add_vc_leadership_lists as $key => $feature) {
                $feature_thumb = wp_get_attachment_image_src($feature['add_vc_leadership_avatar'], 'full');
                ?>
                <div class="vc-leadership-item">
                  <div class="vc-leadership-wrap">
                      <img src="<?php echo esc_url($feature_thumb[0]);?>" />
    
                      <div class="vc-leadership-overlay">
                        <div class="vc-leadership-overlay-wrap">
                            <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.</p>
                            <div class="vc-leadership-social">
                              <a href="#"><i class="icon-facebook"></i></a>
                              <a href="#"><i class="icon-linkedin2"></i></a>
                              <a href="#"><i class="icon-twitter"></i></a>
                            </div>
                        </div>
    
                
                      </div>
                      <div class="vc-leadership-info">
                        <h4>Philip Demarco</h4>
                        <p>Business Analyst</p>
                      </div>
                  </div>
    
    
    
                </div>
                <?php
            }?>
          </div>
      </div>
      <?php
      }
      
      return ob_get_clean();
    }
  }
  
  new NB_Element_Leadership();
}