<?php
if (!defined('ABSPATH'))
exit;

if (class_exists("WPBakeryShortCode")) {
    class NB_Element_Intro_Image extends WPBakeryShortCode {
        function __construct() {
            add_action( 'init', array( $this, 'map' ) );
            add_shortcode( 'vc_info_image', array( $this, 'vc_shortcode' ) );
        }

        public function map() {
            vc_map( array(
                "name" => __( "Intro Image", "printshop" ),
                "base" => "vc_info_image",
                "class" => "",
                "category" => __( "PrintCart", "printshop"),
          
                "params" => array(
                  array(
                      'type' => 'attach_image',
                      'heading' => __('Background Image', 'printshop'),
                      'param_name' => 'vc_im_bg',
                      'value' => '',
                      'description' => __('Select image from media library.', 'printshop'),
                      'admin_label' => true,
                  ),
                   array(
                      "type" => "colorpicker",
                      "class" => "",
                      "heading" => __( "Background Color", "printshop" ),
                      "param_name" => "vc_im_color",
                      "value" => '#FF0000', //Default Red color
                      "description" => __( "Choose text color", "printshop" )
                   ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Heading", "printshop" ),
                      "param_name" => "vc_im_heading",
                      "value" => __( "Business Cards", "printshop" ),
                      "description" => __( "Description for foo param.", "printshop" )
                  ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Sales", "printshop" ),
                      "param_name" => "vc_im_sales",
                      "value" => __( "Now 25% off.", "printshop" ),
                      "description" => __( "Description for foo param.", "printshop" )
                  ),
                   array(
                      "type" => "textarea",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Description", "printshop" ),
                      "param_name" => "vc_im_desc",
                      "value" => __( "Savings on select products starting<br />at 25% off. Discount percentages<br />may vary on options, upgrades,<br />& accessories.", "printshop" ),
                      "description" => __( "Description for foo param.", "printshop" )
                  ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Link", "printshop" ),
                      "param_name" => "vc_im_href",
                      "value" => __( "#", "printshop" ),
                      "description" => __( "Description for foo param.", "printshop" )
                  ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Label of link", "printshop" ),
                      "param_name" => "vc_im_label",
                      "value" => __( "Shop Now!", "printshop" ),
                      "description" => __( "Description for foo param.", "printshop" )
                  )
                )
            ));
        }

        public function vc_shortcode($atts, $content = null) {
            extract( shortcode_atts( array(
                'vc_im_bg' => '',
                'vc_im_color' => '',
                'vc_im_heading' => 'Business Cards',
                'vc_im_sales' => 'Now 25% off.',
                'vc_im_desc' => 'Savings on select products starting<br />at 25% off. Discount percentages<br />may vary on options, upgrades,<br />& accessories.',
                'vc_im_href' => '#',
                'vc_im_label' => 'Shop Now!'
            ), $atts ) );
          
            $img_src = wp_get_attachment_image_src($vc_im_bg, 'full');
          
            $html = '<div class="vc-im-wrapper" style="background-image: url('. esc_url($img_src[0]) . '); background-color: '. esc_attr($vc_im_color).'">';
                $html .= '<h4>'. esc_attr( $vc_im_heading ) .'</h4>';
                $html .= '<div class="vc-im-sales">'. esc_attr( $vc_im_sales ) .'</div>';
                $html .= '<h5>' . wp_kses( $vc_im_desc, array( 'br' => array() ) ) .'</h5>';
                $html .= '<a href="' . esc_url($vc_im_href) . '" class="btn btn-shop-now">' . esc_attr( $vc_im_label ) . '</a>';
            $html .= '</div>';
            
            return $html;
        }
    }
    new NB_Element_Intro_Image();
}