<?php
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
    class NB_Element_Step extends WPBakeryShortCode {
        function __construct() {
            add_action( 'init', array( $this, 'map' ) );
            add_shortcode( 'vc_printshop_step', array( $this, 'vc_printshop_step' ) );
        }

        public function map() {
            vc_map( array(
                "name" => __( "Step", "printshop" ),
                "base" => "vc_printshop_step",
                "class" => "",
                "category" => __( "PrintCart", "printshop"),
          
                "params" => array(
                  array(
                      'type' => 'param_group',
                      'value' => '',
                      'heading' => __('Step', 'nb-fw'),
                      'param_name' => 'add_vc_step_lists',
                      'group' => __('Content Options', 'nb-fw'),
                      // Note params is mapped inside param-group:
                      'params' => array(
                         array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Icon", "printshop" ),
                            "param_name" => "add_vc_step_icon",
                            "value" => '',
                        ),
                         array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Label", "printshop" ),
                            "param_name" => "add_vc_step_label",
                            "value" => '',
                        ), 
                         array(
                            "type" => "textarea",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Description", "printshop" ),
                            "param_name" => "add_vc_step_description",
                            "value" => '',
                        ),
                      )
                   )
                )
            ));
        }

        public function vc_printshop_step($atts, $content = null) {
            extract( shortcode_atts( array(
                'vc_tab_product_limit' => 8
            ), $atts ) );
        
        
            ob_start();
            $add_vc_step_lists = vc_param_group_parse_atts($atts['add_vc_step_lists']);
            if($add_vc_step_lists) {
        
            ?>
            <div class="vc-printshop-step">
                <div class="container">
                    <div class="vc-printshop-step-wrapper">
                        <div class="vc-printshop-step-image"></div>
                        <div class="vc-printshop-step-content">
                        <ul>
                            <?php foreach ($add_vc_step_lists as $key => $step) {?>
                            <li>
                                <div class="ib-shape"><div class="icon"> <i class="<?php echo esc_attr($step['add_vc_step_icon']);?>"></i></div></div>
                                <div class="ib-content">
                                    <h4><?php echo esc_attr($step['add_vc_step_label']);?></h4>
                                    <p><?php echo esc_attr($step['add_vc_step_description']);?></p>
                                </div>
                            </li>
                            <?php }?>
                        </ul>
                        </div>
                    </div>
                </div>
        
            </div>
            <?php
            }
            
            return ob_get_clean();
        }
    }

    new NB_Element_Step();
}