<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Brands_List extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ) );
        add_shortcode( 'netbase_brands_list', array( $this, 'shortcode_brands_list' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }        
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'List Brands', 'nb-fw' ),
            'base'        => 'netbase_brands_list',
            'icon' => 'icon-wpb-wp',
            'category' => __('PrintCart', 'nb-fw'),
            'description' => esc_html__( 'Display List Brands.', 'nb-fw' ),

            'params'      => array(
                array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Block title', 'nb-fw' ),
                        'param_name'    => 'title',
                        'admin_label'   => true,
                        'value'         => '',
                        'description'   => ''
                ),
                array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Show Per page', 'nb-fw' ),
                        'value' => 12,
                        'save_always' => true,
                        'admin_label'   => true,
                        'param_name' => 'per_page',
                        'description' => esc_html__( 'How many brand to show on the page', 'nb-fw' ),
                ),
                array(
                    'param_name'  => 'items_per_slide',
                    'heading'     => esc_html__( 'Items per slide', 'nb-fw' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( '1', 'nb-fw' )  => '1',
                        __( '2', 'nb-fw' ) => '2',
                        __( '3', 'nb-fw' ) => '3',
                        __( '4', 'nb-fw' ) => '4',
                        __( '5', 'nb-fw' ) => '5',
                        __( '6', 'nb-fw' ) => '6',
                        __( '7', 'nb-fw' ) => '7',
                        __( '8', 'nb-fw' ) => '8',
                    ),
                    'std'         => '1',
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'type' => 'dropdown',
                        'heading' => __('Item Align', 'nb-fw'),
                        'param_name' => 'item_align',                        
                        'value' => array(
                                'Center' => 'text-center',
                                'Right' => 'text-right',
                                'Left' => 'text-left',
                                
                        ),
                        'std' => 'text-center',
                        'save_always' => true,                            
                ), 

                /*array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-elements'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),  */
                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'nb-elements' ),
                        'type'       => 'checkbox',                                                
                        /*'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),*/
                    ),
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'nb-elements' ),
                        'type'       => 'checkbox',                        
                        /*'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),*/
                ), 
                
               /* array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'nb-elements' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), */
                array(
                        'param_name' => 'loop',
                        'heading'    => esc_html__( 'Enable Loop', 'nb-elements' ),
                        'type'       => 'checkbox',                        
                        /*'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),*/
                ),

                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'nb-elements' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'nb-elements' )  => '1',
                            __( '2 columns', 'nb-elements' ) => '2',
                            __( '3 columns', 'nb-elements' ) => '3',
                            __( '4 columns', 'nb-elements' ) => '4',
                            __( '5 columns', 'nb-elements' ) => '5',
                            __( '6 columns', 'nb-elements' ) => '6',
                            __( '7 columns', 'nb-elements' ) => '7',
                            __( '8 columns', 'nb-elements' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-elements' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'nb-elements' )  => '',
                            __( '1 column', 'nb-elements' )  => '1',
                            __( '2 columns', 'nb-elements' ) => '2',
                            __( '3 columns', 'nb-elements' ) => '3',
                            __( '4 columns', 'nb-elements' ) => '4',
                            __( '5 columns', 'nb-elements' ) => '5',
                            __( '6 columns', 'nb-elements' ) => '6',
                            __( '7 columns', 'nb-elements' ) => '7',
                            __( '8 columns', 'nb-elements' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                        'param_name'  => 'columnsmobile',
                        'heading'     => esc_html__( 'Number of columns displayed Mobile', 'nb-elements' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'nb-elements' )  => '',
                            __( '1 column', 'nb-elements' )  => '1',
                            __( '2 columns', 'nb-elements' ) => '2',
                            __( '3 columns', 'nb-elements' ) => '3',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Border image brand', 'nb-elements'),
                    'param_name' => 'border_img',
                    'std' => true,                    
                ),
                array(
                    'param_name'  => 'dot_style',
                    'heading'     => esc_html__( 'Dot Style', 'nb-elements' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( 'Style 1', 'nb-elements' )  => 'style1',
                        __( 'Style 2', 'nb-elements' ) => 'style2',

                    ),
                    'std'         => 'style1',
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                    'dependency' => array(
                        'element' => 'pagination',
                        'value'   => 'true',
                    ),
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-elements' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-elements' ),
                ),
               
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_brands_list($atts, $content = null)
    {
        global $woocommerce;
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'         => '',                    
                    'per_page'  => '',
                    'item_align' => 'text-center',
                    'navigation'   => '',
                    /*'slider'                => true,*/
                    'pagination'   => '',
                    /*'autoplay'     => '',*/
                    'loop'         => '',
                    'columns' => '3',                  
                    'columnstablet' =>'', 
                    'columnsmobile' =>'',
                    'border_img' => true,
                    'items_per_slide'=>'1',
                    'dot_style' => 'style1',
                    'css' => '',
                ),
                $atts
            )
        );

        $id = uniqid('netbase_custom_css_');
        $classes = array();
        $css_class = '';

        $classesc  = $attr = array();

        if($items_per_slide > 1){
            $classesc[] = ' group';
        }

        /*if ( ! empty( $slider ) ) {*/
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet": "' . ( int ) $columnstablet . '"';
            }
            if ( ! empty( $columnsmobile ) ) {
                $attr[] = '"mobile": "' . ( int ) $columnsmobile . '"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }
            /*if($autoplay){
                $attr[] = '"autoplay": "true"';
            }*/
            if($loop){
                $attr[] = '"loop": "true"';
            }
            if ( $navigation ) {
                $attr[] = '"nav": "true"';
            }
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }            

            $classesc[] = 'nbfw-carousel owl-carousel owl-loaded owl-drag';
        /*}*/
        if ( ! empty( $border_img ) ) {
            $classesc[] = ' border-img';
        }
        if ( ! empty( $dot_style ) ) {
            $classesc[] = ' '.$dot_style;
        }
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_brands_list', $atts ); 

        $per_page = absint($per_page);

        $terms = get_terms( array(
                'taxonomy' => 'product_brand',
                'hide_empty' => false,
            ) );
        ob_start();
        if($terms){
            $i = 0;
            foreach ($terms as $key => $term) {

                $brands_thumbnail = get_term_meta( $term->term_id, 'brands_thumbnail', true );
                    $brands_thumbnail = wp_get_attachment_image_src($brands_thumbnail);

                    $brands_target = get_term_meta( $term->term_id, 'brands_target', true );
                    $brands_type = get_term_meta( $term->term_id, 'brands_type', true );
                    $brands_link  = get_term_link($term, 'product_brand');
                    if($brands_type == 'url'){
                        $brands_link = get_term_meta( $term->term_id, 'brands_url', true );
                    }
                if( ($items_per_slide > 1) && ($i % $items_per_slide == 0)) {
                    echo '<li class="carousel-wrap">';
                    echo '<ul>';
                }
                ?>
                        <li>
                            <div class="b-thumb">
                                <a href="<?php echo $brands_link;?>" target="<?php echo $brands_target;?>">
                                    <img src="<?php echo $brands_thumbnail[0];?>" class="img1" alt="<?php echo $term->name;?>" alt="print">
                                </a>
                            </div>
                        </li>
                <?php
                $i++;
                if(($items_per_slide > 1) && ($i % $items_per_slide == 0) ) {
                    echo '</ul>';
                    echo '</li>';
                }
            }
        }                   

        $html .= '<ul id="' . esc_attr($id) . '" class="brands-list '. esc_attr( implode( ' ', $classesc ) ) .' '.esc_attr( $css_class ).'"  '.$data_owlcarousel.'>' . ob_get_clean() . '</ul>';
        
        // End HTML code.
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_brands_list', force_balance_tags($html));
    }
   
    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {
            for ( $i = $pos; $i < count( $array ); $i ++ ) {
                if ( $array[ $i ]->category_parent == $parent_id ) {
                    $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                    $value = $array[ $i ]->slug;
                    $dropdown[] = array(
                        'label' => $name,
                        'value' => $value,
                    );
                    $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
                }
            }
        }
     
} // End Element Class
 
// Element Class Init
new NB_Element_Brands_List(); 
}
