<?php
class NBT_Ajax_Search_Shortcode {

	/**
	* @ since 01-01-2018
	**/
	function __construct() {
		add_shortcode( 'nbt_ajax_search', array($this, 'shortcode_ajax_search'), 10, 1 );

		add_action( 'nbt_ajax_search_html', array($this, 'nbt_ajax_search_html'), 10, 1 );
	}

	public function shortcode_ajax_search($args = array()) {
		$args = apply_filters( 'nbt_ajax_search_args', array(
			'form_action' => home_url(),
			'form_class' => 'form-search',
			'form_id' => 'nbt-ajax-search',
			'input_class' => 'nbt-input-search'
		), $args );

		$form_attr = array();
		$form_attr[] = isset($args['form_id']) && !empty($args['form_id']) ? 'id="' . esc_html($args['form_id']) .'"' : "";
		$form_attr[] = isset($args['form_class']) && !empty($args['form_class']) ? 'class="' . esc_html($args['form_class']) .'"' : "";
		$form_attr[] = isset($args['form_action']) && !empty($args['form_action']) ? 'action="' . esc_html($args['form_action']) .'"' : "";
		$form_attr = array_filter($form_attr);
		?>
		<form <?php echo implode(' ', $form_attr);?> method="GET">
			<?php do_action( 'nbt_ajax_search_html', $args);?>
		</form>
		<?php

		if ( ! defined( 'PREFIX_NBT_SOLS' ) ) {
			wp_enqueue_script('nbt-ajax-search');
		}
	}

	public function nbt_ajax_search_html($args) {
		global $product, $post;
		?>
		<div class="field searchbox">
			<div class="control">
				<div class="input-content">
					<input type="text" name="s" class="input-searchbox <?php echo esc_attr($args['input_class']);?>" placeholder="Enter keywords to search..." maxlength="128" role="combobox" aria-haspopup="false" aria-autocomplete="both" autocomplete="off" aria-expanded="false">
				</div>

				<div class="select-cat">
					<?php $args = array(
						'show_option_all'    => '',
						'show_option_none'   => __('All Categories', 'printshop'),
						'option_none_value'  => '-1',
						'orderby'            => 'ID',
						'order'              => 'ASC',
						'show_count'         => 0,
						'hide_empty'         => 1,
						'child_of'           => 0,
						'exclude'            => '',
						'include'            => '',
						'echo'               => 1,
						'selected'           => 0,
						'hierarchical'       => 0,
						'name'               => 'cat',
						'id'                 => '',
						'class'              => 'cat searchbox-cat',
						'depth'              => 0,
						'tab_index'          => 0,
						'taxonomy'           => 'product_cat',
						'hide_if_empty'      => false,
						'value_field'        => 'term_id',
					);
					wp_dropdown_categories( $args );?>
				</div>

				<div id="searchbox_autocomplete" class="rs-search rs-search-autocomplete nbt-results">
					<ul>
						<?php
						$args = array(
							'posts_per_page'    => 8,
							'post_type' => 'product',
						);

					    // The Query
						$the_query = new WP_Query( $args );

						if ( $the_query->have_posts() ) {
							while ( $the_query->have_posts() ) {
								$the_query->the_post();

								$product = wc_get_product($post->ID);
								$product_thumbnail =  wp_get_attachment_image_src( get_post_thumbnail_id( $product->get_id() ), 'shop_thumbnail'); ?>
								<li>
									<a href="<?php echo esc_url( get_permalink($post->ID) );?>">
										<?php the_post_thumbnail('shop-thumbnail', ['alt' => esc_attr($post->post_title)]); ?>

										<div class="rs-search-info">
											<h4><?php echo esc_attr($post->post_title);?></h4>
											<?php
											if ( 'no' === get_option( 'woocommerce_enable_review_rating' ) ) {
												return;
											}

											$rating_count = $product->get_rating_count();
											$review_count = $product->get_review_count();
											$average      = $product->get_average_rating();

											if ( $rating_count > 0 ) : ?>

												<div class="woocommerce-product-rating">
													<?php echo wc_get_rating_html( $average, $rating_count ); ?>
												</div>

												<?php else: ?>
													<div class="woocommerce-product-rating wc-zero-rating">
														<?php
														$html  = '<div class="star-rating">';
														$html .= wc_get_star_rating_html( $rating, $count );
														$html .= '</div>';
														echo $html;
														?>
													</div>
												<?php endif; ?>
												<p class="price"><?php echo $product->get_price_html(); ?></p>
											</div>

										</a>
									</li>
									<?php
								}
							}
							wp_reset_postdata();?>
						</ul>
					</div>                   
				</div>
			</div>
			<div class="actions">
				<button type="submit" title="Search" class="button btn-searchbox"><i class="pt-icon-search"></i></button>
			</div>
			<?php
		}

		public function shortcode_assets() {
			wp_register_script( 'nbt-ajax-search', AJAX_SEARCH_URL . 'assets/js/frontend.js' );

		// Localize the script with new data
		// if( file_exists(AJAX_SEARCH_PATH .'inc/localize_script.php') ) {
		// 	$localize_content = include AJAX_SEARCH_PATH .'inc/localize.php';
		// 	wp_localize_script( 'nbt-ajax-search', 'nbtsearch', $localize_content );
		// }

		}
	}

	new NBT_Ajax_Search_Shortcode();