<?php

abstract class Google_Analytics_API {

	/**
	 * Keeps error messages.
	 * @var array
	 */
	protected $errors = array();

	/**
	 * Returns errors array.
	 * @return array
	 */
	public function get_errors() {
		return $this->errors;
	}

	/**
	 * Calls private API method from context client.
	 *
	 * @param $callback
	 * @param $args
	 *
	 * @return Google_Analytics_API_Response
	 */
	abstract function call_api_method( $callback, $args );

	/**
	 * Calls api methods.
	 *
	 * @param string $callback
	 * @param mixed $args
	 *
	 * @return mixed
	 */
	public function call( $callback, $args = null ) {
		try {
			return $this->call_api_method( $callback, $args );
		} catch ( Google_Analytics_API_Exception $e ) {
			$this->add_error( $e );

			return new Google_Analytics_API_Response( Google_Analytics_API_Response::$empty_response );
		} catch ( Google_Analytics_API_Request_Exception $e ) {
			$this->add_error( $e );

			return new Google_Analytics_API_Response( Google_Analytics_API_Response::$empty_response );
		} catch ( Exception $e ) {
			$this->add_error( $e );

			return new Google_Analytics_API_Response( Google_Analytics_API_Response::$empty_response );
		}
	}

	/**
	 * Prepares error data.
	 *
	 * @param Exception $e
	 *
	 */
	protected function add_error( Exception $e ) {
		$this->errors[ $e->getCode() ] = array( 'class' => get_class( $e ), 'message' => $e->getMessage() );
		do_action( 'st_support_save_error', $e );
	}

	public function add_own_error( $code, $message, $class = '' ) {
		$this->errors[ $code ] = array( 'class' => $class, 'message' => $message );
	}

}

class Google_Analytics_API_Exception extends Exception {

}
