<?php

class Google_Analytics_Admin {
    const ALT_GA_OAUTH_AUTH_CODE_OPTION_NAME = 'alt_ga_oauth_auth_code';
    const ALT_GA_OAUTH_AUTH_TOKEN_OPTION_NAME = 'alt_ga_oauth_auth_token';
    const ALT_GA_PRINTCART_API_ALIAS = 'alt_ga';
    const ALT_GA_SELECTED_ACCOUNT = 'alt_ga_selected_account';
    const ALT_GA_DISABLE_ALL_FEATURES = 'alt_ga_disable_all_features';
    const ALT_GA_TERMS_OPTION_NAME = 'alt_ga_terms';
    const ALT_GA_ACCOUNT_DATA_OPTION_NAME  = 'alt_ga_account_data';
    const ALT_GA_WEB_PROPERTY_ID_OPTION_NAME = 'alt_ga_web_property_id';

    /**
     * Gets dashboard data.
     *
     * @return array
     */
    public static function generate_stats_data() {
        $selected = Google_Analytics_Helper::get_selected_account_data( true );

        $query_params	 = Google_Analytics_Stats::get_query( 'main_chart', $selected[ 'view_id' ], date('Y-m-') . '01' );

        $stats_data		 = Google_Analytics_Admin::api_client()->call( 'ga_api_data', array(
            $query_params
        ) );

        $chart = !empty( $stats_data ) ? Google_Analytics_Stats::get_chart( $stats_data->getData() ) : array();

        return $chart;
    }

    /**
     * Save access token.
     *
     * @param Ga_Lib_Api_Response $response
     *
     * @return boolean
     */
    public static function save_access_token( $response, $refresh_token = '' ) {
        $access_token = $response->getData();
        if ( !empty( $access_token ) ) {
            $access_token[ 'created' ] = time();
        } else {
            return false;
        }

        if ( !empty( $refresh_token ) ) {
            $access_token[ 'refresh_token' ] = $refresh_token;
        }

        return update_option( self::ALT_GA_OAUTH_AUTH_TOKEN_OPTION_NAME, wp_json_encode( $access_token ) );
    }

    /**
     * Saves Google Analytics account data.
     *
     * @param $data
     *
     * @return array
     */
    public static function save_ga_account_summaries( $data ) {
        $return = array();
        if ( !empty( $data[ 'items' ] ) ) {

            foreach ( $data[ 'items' ] as $item ) {
                $tmp			 = array();
                if ( isset($item[ 'webProperties' ]) && is_array( $item[ 'webProperties' ] ) ) {
                    $tmp[ 'id' ]	 = $item[ 'id' ];
                    $tmp[ 'name' ]	 = $item[ 'name' ];
                    foreach ( $item[ 'webProperties' ] as $property ) {
                        $profiles = array();
                        if ( is_array( $property[ 'profiles' ] ) ) {
                            foreach ( $property[ 'profiles' ] as $profile ) {
                                $profiles[] = array(
                                    'id'	 => $profile[ 'id' ],
                                    'name'	 => $profile[ 'name' ]
                                );
                            }
                        }

                        $tmp[ 'webProperties' ][] = array(
                            'webPropertyId'	 => $property[ 'id' ],
                            'name'			 => $property[ 'name' ],
                            'profiles'		 => $profiles
                        );
                    }
                }

                $return[] = $tmp;
            }

            $return = array_filter($return);

            update_option( self::ALT_GA_ACCOUNT_DATA_OPTION_NAME, wp_json_encode( $return ) );
        } else{
            update_option( self::ALT_GA_ACCOUNT_DATA_OPTION_NAME, "" );
        }

        //update_option( self::ALT_GA_WEB_PROPERTY_ID_OPTION_NAME, "" );

        return $return;
    }

    /**
     * Instantiate API client.
     *
     * @return Ga_Lib_Google_Api_Client|null
     */
    public static function api_client( $type = '' ) {
        if ( $type === self::ALT_GA_PRINTCART_API_ALIAS ) {
            $instance = Ga_Lib_Sharethis_Api_Client::get_instance();
        } else {

            $instance	 = Google_Analytics_API_Client::get_instance();
            $token		 = Google_Analytics_Helper::get_option( self::ALT_GA_OAUTH_AUTH_TOKEN_OPTION_NAME );

            try {
                if ( !empty( $token ) ) {
                    $token = json_decode( $token, true );
                    $instance->set_access_token( $token );
                }
            } catch ( Exception $e ) {
                echo $e->getMessage();
            }
        }

        return $instance;
    }
}