<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists('NBD_Settings') ) {
	class NBD_Settings extends NBD_Singleton {

	    /**
	     * NPC_Register constructor.
	     *
	     * @since 0.1.0
	     */
	    public function __construct() {

	    }
		
		public function settings_page() {
			$ga_authorize_code = $notice_msg = '';
			
			if( isset($_POST['submit']) ) {
				
				if( isset($_POST['nb_dashboard']) && $nb_dashboard = $_POST['nb_dashboard'] ) {
					foreach( $_POST['nb_dashboard'] as $k => $data ) {
						update_option( 'nb_dashboard_'. $k, str_replace('\\', '', $data));
					}
				}
				
				if( isset($_POST['ga_authorize_code']) ) {
					$ga_authorize_code = $_POST['ga_authorize_code'];
					$response = Google_Analytics_Admin::api_client()->call( 'ga_auth_get_access_token', $ga_authorize_code );

					if ( empty( $response ) ) {
						return false;
					}

					if ( ! Google_Analytics_Admin::save_access_token( $response ) ) {
						$notice_msg = '<div id="setting-error-settings_updated" class="updated settings-error notice is-dismissible"><p>Please check token again.</p></div>';
					}else {
						$notice_msg = '<div id="setting-error-settings_updated" class="updated settings-error notice is-dismissible"><p>Updated</p></div>';
						update_option(Google_Analytics_Admin::ALT_GA_OAUTH_AUTH_CODE_OPTION_NAME, $ga_authorize_code);
					}
				}
				
                if( isset($_POST['alt_ga_selected_account']) && !empty($_POST['alt_ga_selected_account']) ) {
                    $selected_account = explode('_', $_POST['alt_ga_selected_account']);
                    update_option( Google_Analytics_Admin::ALT_GA_WEB_PROPERTY_ID_OPTION_NAME, $selected_account[1] );
                    update_option( Google_Analytics_Admin::ALT_GA_SELECTED_ACCOUNT, wp_json_encode($selected_account) );
                }
			}
			
			$authorize_code = Google_Analytics_Helper::get_option( Google_Analytics_Admin::ALT_GA_OAUTH_AUTH_CODE_OPTION_NAME );

			include_once NBDB_ABSPATH . 'templates/settings-page.php';
		}
	}

}





