<?php
class nbTour_Frontend {
    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NBT_Envato_API
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
	
    /**
     * nbTour constructor.
     *
     * @since 0.0.1
     */
    private function __construct() {
		add_filter( 'nbtour_frontend', array( __CLASS__, 'nbtour_frontend' ) );
	}
	
	public static function nbtour_frontend() {
		
		$array = array();
		
		$array[] = array(
			array(
				'element' => 'body.home .post-38',
				'position' => 'right',
				'type' => 'text',
				'title' => 'Step 1',
				'content' => 'Choose the product  integrated "Order upload" feature',
				'offset_background' => array(
					'top' => -20
				),
				'offset_popup' => array(
					'top' => -10
				)
			),
			array(
				'element' => '.nbt-upload-zone',
				'position' => 'left',
				'type' => 'click',
				'title' => 'Step 2',
				'content' => 'Upload your file here',
				'offset_background' => array(
					'top' => -13
				),
				'offset_popup' => array(
					'top' => -10
				),
				//'link' => home_url('product/travel-agency-flyer/')
			),
			array(
				'element' => '.single_add_to_cart_button',
				'position' => 'right',
				'type' => 'click',
				'title' => 'Step 3',
				'content' => 'Choose the quantity and then click "Add to cart" button.',
				'offset_background' => array(
					'top' => -13
				),
				'offset_popup' => array(
					'top' => -8
				)
			),
			array(
				'element' => '.single-product .woocommerce-message .wc-forward',
				'position' => 'left',
				'type' => 'text',
				'title' => 'Step 4',
				'content' => 'Click on "View cart" button',
				'offset_background' => array(
					'top' => -14
				),
				'offset_popup' => array(
					'top' => 0
				)
			)
		);
		
		$array[] = array(
			array(
				'element' => 'body.home .post-364',
				'position' => 'right',
				'type' => 'click',
				'title' => 'Step 1',
				'content' => 'Choose the product integrated "Price Matrix" feature.',
				'offset_background' => array(
					'top' => -20
				)
			),
			array(
				'element' => '.postid-364 .load-table-pm',
				'position' => 'right',
				'type' => 'text',
				'title' => 'Step 2',
				'content' => 'Select the price and you can see the attibute in the dropdown.',
				'offset_background' => array(
					'top' => -14
				)
			),
			array(
				'element' => '.postid-364 .single_add_to_cart_button',
				'position' => 'right',
				'type' => 'click',
				'title' => 'Step 3',
				'content' => 'Choose the quantity and then click "Add to cart" button.',
				'offset_background' => array(
					'top' => -13
				)
			),
			array(
				'element' => '.single-product .woocommerce-message .wc-forward',
				'position' => 'left',
				'type' => 'text',
				'title' => 'Step 4',
				'content' => 'Click on "View cart" button',
				'offset_background' => array(
					'top' => -14
				),
				'offset_popup' => array(
					'top' => 0
				)
			)
		);
		
		$array[] = array(
			array(
				'element' => 'body.home .post-113',
				'position' => 'right',
				'type' => 'click',
				'title' => 'Step 1',
				'content' => 'Choose the product integrated "Color Swatches" feature.',
				'offset_background' => array(
					'top' => -20
				)
			),
			array(
				'element' => '.postid-113 .nbt-variations .variations',
				'position' => 'right',
				'type' => 'text',
				'title' => 'Step 2',
				'content' => 'Fillfull the information before checkout.',
				'offset_background' => array(
					'top' => -14
				)
			),
			array(
				'element' => '.postid-113 .single_add_to_cart_button',
				'position' => 'right',
				'type' => 'click',
				'title' => 'Step 3',
				'content' => 'Choose the quantity and then click "Add to cart" button.',
				'offset_background' => array(
					'top' => -13
				)
			),
			array(
				'element' => '.single-product .woocommerce-message .wc-forward',
				'position' => 'left',
				'type' => 'text',
				'title' => 'Step 4',
				'content' => 'Click on "View cart" button',
				'offset_background' => array(
					'top' => -14
				),
				'offset_popup' => array(
					'top' => 0
				)
			)
		);
		
		return $array;
	}
}