<?php if ( ! defined( 'ABSPATH' ) ) { exit;} ?>
<div class="nbo_options_panel" id="nbd-local-settings" style="display: none;">
    <div class="postbox" style="margin: 10px;">
        <button type="button" class="handlediv" aria-expanded="false">
            <span class="screen-reader-text"><?php _e( 'Toggle panel: Local settings', 'web-to-print-online-designer' ); ?></span><span class="toggle-indicator" aria-hidden="false"></span>
        </button>
        <h2 style="box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);"><span><b><?php _e( 'Local settings', 'web-to-print-online-designer' ); ?></b></span></h2>
        <div class="inside">
            <div class="nbo-form-field">
                <label><b><?php _e( 'Override global settings', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <input type="hidden" value="0" name="_nbls_enable"/>
                    <input type="checkbox" value="1" name="_nbls_enable" id="_nbls_enable" data-ls-toggle="nbls-main-settings" <?php checked( $nbls_enable ); ?> class="short" />
                    <label for="_nbls_enable"><?php _e('Enable', 'web-to-print-online-designer'); ?></label>
                </div>
            </div>
            <div style="padding: 5px 20px 5px 12px; margin:  9px 0;">
                <b><?php _e( 'Note:', 'web-to-print-online-designer' ); ?></b>
                <br />
                <i><?php _e( 'Bellow settings will be override ', 'web-to-print-online-designer' ); echo sprintf(__( '<a target="_blank" href="%s">global settings</a>', 'web-to-print-online-designer'), esc_url(admin_url('admin.php?page=nbdesigner&tab=frontend'))) ?>.</i>
            </div>
            <hr />
            <div class="nbls-main-settings" id="nbls-main-settings">
                <div style="padding: 5px 20px 5px 12px; margin:  9px 0;">
                    <select id="nbls_setting_id">
                        <option value=""><?php _e( '-- Choose setting --', 'web-to-print-online-designer' ); ?></option>
                        <?php foreach( $settings['group_titles'] as $gkey => $gtext ): ?>
                        <optgroup label="<?php echo $gtext; ?>">
                            <?php 
                                foreach( $settings['option_groups'][$gkey] as $option ):
                                    $show = true;
                                    if( isset( $option['layout'] ) ){
                                        $show = nbd_check_availaible_option( $option['layout'] );
                                    }
                                    if( isset( $option['local'] ) && $option['local'] == false ){
                                        $show = false;
                                    }
                                    if( $show ){
                            ?>
                            <option value="<?php echo $option['id']; ?>"><?php echo $option['title']; ?></option>
                            <?php } endforeach; ?>
                        </optgroup>
                        <?php endforeach; ?>
                    </select>
                    <input type="button" class="button " value="<?php _e( 'Add', 'web-to-print-online-designer' ); ?>" id="nbls_add_setting">
                </div>
                <hr />
                <div style="padding: 10px;">
                    <input type="hidden" value="<?php echo implode( "|", array_keys( $local_settings ) ); ?>" id="nbls_keys_string" name="_nbls_keys_string"/>
                    <input type="hidden" value="" id="nbls_options_string" name="_nbls_options_string"/>
                    <table class="form-table" id="nbls_settings_table">
                        <thead>
                            <tr>
                                <th style="width: 30%"><?php _e( 'Option name', 'web-to-print-online-designer' ); ?></th>
                                <th style="width: 60%"><?php _e( 'Option value', 'web-to-print-online-designer' ); ?></th>
                                <th style="width: 10%"><?php _e( 'Action', 'web-to-print-online-designer' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                foreach( $keys_arr as $key_setting ){
                                    $this->build_option_output( $key_setting, $settings, $post_id );
                                }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="postbox closed" style="margin: 10px;">
        <button type="button" class="handlediv" aria-expanded="true">
            <span class="screen-reader-text"><?php _e( 'Toggle panel: Extra settings', 'web-to-print-online-designer' ); ?></span><span class="toggle-indicator" aria-hidden="false"></span>
        </button>
        <h2 style="box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);"><span><b><?php _e( 'Extra settings', 'web-to-print-online-designer' ); ?></b></span></h2>
        <div class="inside">
            <div class="nbo-form-field">
                <label><b><?php _e( 'Clipart settings', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <input type="hidden" value="0" name="_nbes_enable_settings[clipart]"/>
                    <input type="checkbox" value="1" name="_nbes_enable_settings[clipart]" id="_nbes_clipart_category_enable" data-ls-toggle="nbes_clipart_cats" <?php checked( $nbes_enable_settings['clipart'] ); ?> class="short" />
                    <label for="_nbes_clipart_category_enable"><?php _e('Enable', 'web-to-print-online-designer'); ?></label>
                </div>
            </div>
            <div class="nbo-form-field nbes-depend" id="nbes_clipart_cats">
                <label><b><?php _e( 'Select clipart category', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <select name="_nbes_settings[clipart_cats][]" multiple class="nbes-slect-woo">
                        <?php 
                            foreach( $art_cats as $art_cat ): 
                                $selected = ( $select_all_clipart_cat || in_array( $art_cat->id, $nbes_settings['clipart_cats'] ) ) ? ' selected="selected" ' : '';
                        ?>
                        <option value="<?php echo $art_cat->id; ?>" <?php echo $selected; ?>><?php echo $art_cat->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <hr />
            <div class="nbo-form-field">
                <label><b><?php _e( 'Font settings', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <input type="hidden" value="0" name="_nbes_enable_settings[font]"/>
                    <input type="checkbox" value="1" name="_nbes_enable_settings[font]" id="_nbes_font_category_enable" data-ls-toggle="nbes_font_cats" <?php checked( $nbes_enable_settings['font'] ); ?> class="short" />
                    <label for="_nbes_font_category_enable"><?php _e('Enable', 'web-to-print-online-designer'); ?></label>
                </div>
            </div>
            <div class="nbo-form-field nbes-depend" id="nbes_font_cats">
                <label><b><?php _e( 'Select font category', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <select name="_nbes_settings[font_cats][]" multiple class="nbes-slect-woo">
                        <?php 
                            foreach( $font_cats as $font_cat ): 
                                $selected = ( $select_all_font_cat || in_array( $font_cat->id, $nbes_settings['font_cats'] ) ) ? ' selected="selected" ' : '';
                        ?>
                        <option value="<?php echo $font_cat->id; ?>" <?php echo $selected; ?>><?php echo $font_cat->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <hr />
            <div class="nbo-form-field">
                <label><b><?php _e( 'Background settings', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <input type="hidden" value="0" name="_nbes_enable_settings[background]"/>
                    <input type="checkbox" value="1" name="_nbes_enable_settings[background]" id="_nbes_background_color_enable" data-ls-toggle="nbes_background_color" <?php checked( $nbes_enable_settings['background'] ); ?> class="short" />
                    <label for="_nbes_background_color_enable"><?php _e('Enable', 'web-to-print-online-designer'); ?></label>
                </div>
            </div>
            <div class="nbo-form-field nbes-depend" id="nbes_background_color">
                <label><b><?php _e( 'Select background colors', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <table class="nbd_nbes" data-row="<tr><td class='sort'></td><td><input type='checkbox'></td><td><input type='text' name='_nbes_settings[background_colors][codes][]' value='#ffffff' class='nbes-color-picker'></td><td><input type='text' name='_nbes_settings[background_colors][names][]' value='' class='short'></td></tr>">
                        <thead>
                            <tr>
                                <th class='sort'>&nbsp;</th>
                                <th class="check-column">
                                    <input type="checkbox" >
                                </th>
                                <th>
                                    <span class="column-title" data-text="<?php _e( 'Color', 'web-to-print-online-designer' ); ?>"><?php _e( 'Color', 'web-to-print-online-designer' ); ?></span>
                                </th>
                                <th>
                                    <span><?php _e('Color name', 'web-to-print-online-designer'); ?></span>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach( $nbes_settings['background_colors']['codes'] as $index => $code ): ?>
                            <tr>
                                <td class='sort'></td>
                                <td><input type='checkbox'></td>                         
                                <td><input type='text' name='_nbes_settings[background_colors][codes][]' value="<?php echo $code; ?>" class="nbes-color-picker"></td>
                                <td><input type="text" name='_nbes_settings[background_colors][names][]' value="<?php echo $nbes_settings['background_colors']['names'][$index]; ?>" class="short"></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4">
                                    <button type="button" data-type="quantity" class="button button-primary nbd_nbes-add-rule"><?php _e( 'Add Color', 'web-to-print-online-designer' ); ?></button>
                                    <button type="button" class="button button-secondary nbd_nbes-delete-rules"><?php _e( 'Delete Selected', 'web-to-print-online-designer' ); ?></button>
                                </th>
                            </tr>
                        </tfoot>            
                    </table>
                </div>
            </div>
            <hr />
            <div class="nbo-form-field">
                <label><b><?php _e( 'Foreground settings', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <input type="hidden" value="0" name="_nbes_enable_settings[foreground]"/>
                    <input type="checkbox" value="1" name="_nbes_enable_settings[foreground]" id="_nbes_foreground_color_enable" data-ls-toggle="nbes_foreground_color" <?php checked( $nbes_enable_settings['foreground'] ); ?> class="short" />
                    <label for="_nbes_foreground_color_enable"><?php _e('Enable', 'web-to-print-online-designer'); ?></label>
                </div>
            </div>
            <div class="nbo-form-field nbes-depend" id="nbes_foreground_color">
                <label><b><?php _e( 'Select foreground colors', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <table class="nbd_nbes" data-row="<tr><td class='sort'></td><td><input type='checkbox'></td><td><input type='text' name='_nbes_settings[foreground_colors][codes][]' value='#ffffff' class='nbes-color-picker'></td><td><input type='text' name='_nbes_settings[foreground_colors][names][]' value='' class='short'></td></tr>">
                        <thead>
                            <tr>
                                <th class='sort'>&nbsp;</th>
                                <th class="check-column">
                                    <input type="checkbox" >
                                </th>
                                <th>
                                    <span class="column-title" data-text="<?php _e( 'Color', 'web-to-print-online-designer' ); ?>"><?php _e( 'Color', 'web-to-print-online-designer' ); ?></span>
                                </th>
                                <th>
                                    <span><?php _e('Color name', 'web-to-print-online-designer'); ?></span>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach( $nbes_settings['foreground_colors']['codes'] as $index => $code ): ?>
                            <tr>
                                <td class='sort'></td>
                                <td><input type='checkbox'></td>                         
                                <td><input type='text' name='_nbes_settings[foreground_colors][codes][]' value="<?php echo $code; ?>" class="nbes-color-picker"></td>
                                <td><input type="text" name='_nbes_settings[foreground_colors][names][]' value="<?php echo $nbes_settings['foreground_colors']['names'][$index]; ?>" class="short"></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4">
                                    <button type="button" data-type="quantity" class="button button-primary nbd_nbes-add-rule"><?php _e( 'Add Color', 'web-to-print-online-designer' ); ?></button>
                                    <button type="button" class="button button-secondary nbd_nbes-delete-rules"><?php _e( 'Delete Selected', 'web-to-print-online-designer' ); ?></button>
                                </th>
                            </tr>
                        </tfoot>            
                    </table>
                    <div style="margin-top: 15px;">
                        <input type="hidden" value="0" name="_nbes_settings[force_fg]"/>
                        <input type="checkbox" value="1" name="_nbes_settings[force_fg]" id="_nbes_settings_force_fg" <?php checked( $nbes_settings['force_fg'] ); ?> class="short" />
                        <label for="_nbes_settings_force_fg"><?php _e('Force foreground color for all layers', 'web-to-print-online-designer'); ?></label>
                    </div>
                </div>
            </div>
            <hr />
            <div class="nbo-form-field">
                <label><b><?php _e( 'Color combination settings', 'web-to-print-online-designer' ); ?></b> <?php echo wc_help_tip( __( 'This setting will be force color of all layers to foreground color, override background and foreground settings.', 'web-to-print-online-designer' ) ); ?></label>
                <div class="nbo-option-val">
                    <input type="hidden" value="0" name="_nbes_enable_settings[combination]"/>
                    <input type="checkbox" value="1" name="_nbes_enable_settings[combination]" id="_nbes_combination_color_enable" data-ls-toggle="nbes_combination_color" <?php checked( $nbes_enable_settings['combination'] ); ?> class="short" />
                    <label for="_nbes_combination_color_enable"><?php _e('Enable', 'web-to-print-online-designer'); ?></label>
                </div>
            </div>
            <div class="nbo-form-field nbes-depend" id="nbes_combination_color">
                <label><b><?php _e( 'Select combination colors', 'web-to-print-online-designer' ); ?></b></label>
                <div class="nbo-option-val">
                    <table class="nbd_nbes" data-row="<tr><td class='sort'></td><td><input type='checkbox'></td><td><input type='text' name='_nbes_settings[combination_colors][bg_codes][]' value='#ffffff' class='nbes-color-picker'><input type='text' name='_nbes_settings[combination_colors][bg_names][]' value='' class='short'></td><td><input type='text' name='_nbes_settings[combination_colors][fg_codes][]' value='' class='nbes-color-picker'><input type='text' name='_nbes_settings[combination_colors][fg_names][]' value='' class='short'></td></tr>">
                        <thead>
                            <tr>
                                <th class='sort'>&nbsp;</th>
                                <th class="check-column">
                                    <input type="checkbox" >
                                </th>
                                <th>
                                    <span class="column-title" data-text="<?php _e( 'Background Color', 'web-to-print-online-designer' ); ?>"><?php _e( 'Background Color', 'web-to-print-online-designer' ); ?></span>
                                </th>
                                <th>
                                    <span><?php _e('Foreground color', 'web-to-print-online-designer'); ?></span>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach( $nbes_settings['combination_colors']['bg_codes'] as $index => $bg_code ): ?>
                            <tr>
                                <td class='sort'></td>
                                <td><input type='checkbox'></td>
                                <td>
                                    <input type='text' name='_nbes_settings[combination_colors][bg_codes][]' value="<?php echo $bg_code; ?>" class="nbes-color-picker">
                                    <input type='text' name='_nbes_settings[combination_colors][bg_names][]' value="<?php echo $nbes_settings['combination_colors']['bg_names'][$index]; ?>" class="short">
                                </td>
                                <td>
                                    <input type="text" name='_nbes_settings[combination_colors][fg_codes][]' value="<?php echo $nbes_settings['combination_colors']['fg_codes'][$index]; ?>" class="nbes-color-picker">
                                    <input type="text" name='_nbes_settings[combination_colors][fg_names][]' value="<?php echo $nbes_settings['combination_colors']['fg_names'][$index]; ?>" class="short">
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4">
                                    <button type="button" data-type="quantity" class="button button-primary nbd_nbes-add-rule"><?php _e( 'Add', 'web-to-print-online-designer' ); ?></button>
                                    <button type="button" class="button button-secondary nbd_nbes-delete-rules"><?php _e( 'Delete Selected', 'web-to-print-online-designer' ); ?></button>
                                </th>
                            </tr>
                        </tfoot>            
                    </table>
                </div>
            </div>
            <?php do_action( 'after_nbes_settings', $post_id ); ?>
        </div>
    </div>
</div>