<?php
if (!defined('ABSPATH')) exit;
$class                          = nbdesigner_get_option('nbdesigner_class_design_button_detail'); 
$_enable_upload                 = get_post_meta($pid, '_nbdesigner_enable_upload', true);
$_enable_upload_without_design  = get_post_meta($pid, '_nbdesigner_enable_upload_without_design', true);
$label                          = apply_filters('nbd_start_design_label', __('Start Design', 'web-to-print-online-designer'));
if( $_enable_upload ){
    $label = apply_filters('nbd_start_design_and_upload_label', __('Start and upload design', 'web-to-print-online-designer'));
}
if( $_enable_upload_without_design ){
    $label = apply_filters('nbd_upload_design_label', __('Upload Design', 'web-to-print-online-designer'));
}else{
    $_enable_upload_without_design = 0;
}
$layout                       = nbd_get_product_layout($pid);
$show_button_use_our_template = 0;
if( nbdesigner_get_option('nbdesigner_button_link_product_template', 'no') == 'yes' ){
    $templates = nbd_get_templates( $pid, 0, '', false, 0 );
    if( count( $templates ) > 0 ) $show_button_use_our_template = 1;
}
$show_button_hide_us = 0;
if( nbdesigner_get_option('nbdesigner_button_hire_designer', 'no') == 'yes' ){
    $artwork_action = get_transient( 'nbo_action_'.$pid );
    if( false !== $artwork_action ){
        $show_button_hide_us            = 1;
        $show_button_use_our_template   = 0;
    }
}
$nbu_ui_mode = 1;
?>
<style>
    .nbd-save-for-later, .nbd-download-pdf {
        border: 1px solid #ddd !important;
        background: #fff !important;
        color: #333333 !important;
        padding: 1em 2em;
        font-weight: bold;
        font-size: 0.875rem;
        line-height: 1em;  
        border-radius: 2em;
    }
    a.nbd-save-for-later svg {
        display: none;
        margin-right: 10px;
    }
    a.nbd-save-for-later:focus {
        outline: none;
    }
    a.nbd-save-for-later.saved {
        pointer-events: none;
    }
    .nbd-social {
        width: 36px;
        height: 36px;
        display: inline-block;
        padding: 5px;
        border: 1px solid #ddd;
        margin: 0px;
        opacity: 0.8;
        -webkit-transition: all 0.4s;
        -moz-transition: all 0.4s;
        transition: all 0.4s;
        background: #fff;
        cursor: pointer;
    }    
    .nbd-save-loading, .nbd-pdf-loading {
        display: inline-block;
        margin-right: 10px;
        vertical-align: middle;
    }
    .nbd-save-loading.hide, .nbd-pdf-loading.hide {
        display: none;
    }
    #nbdesigner-preview-title {
        margin-top: 15px;
    }
    #nbd_processing {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        -webkit-transition: all .4s;
        -moz-transition: all .4s;
        -o-transition: all .4s;
        transition: all .4s;
        z-index: 1;
    }
    .nbd-m-custom-design-wrap,
    .nbd-m-upload-design-wrap {
        position: absolute;
        z-index: -1;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        visibility: hidden;
        background: #fff;
    }
    .nbd-m-custom-design-wrap.is-visible,
    .nbd-m-upload-design-wrap.is-visible {
        opacity: 1;
        visibility: visible; 
        z-index: 1;
    }    
    .nbd-custom-design-wrap {
        position: relative;
        width: 100%;
        height: 100%;
    }
    .nbd-custom-design-wrap iframe {
        left: 0;
        top: 0;
        position: absolute;
    }
    .nbd-m-upload-design-wrap {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;        
    }
    .inputfile {
        width: 0.1px;
        height: 0.1px;
        opacity: 0;
        overflow: hidden;
        position: absolute;
        z-index: -1;
    }    
    .inputfile + label {
        width: 320px;
        flex-direction: column;
        display: flex;
        text-align: center;
        justify-content: center;
        align-items: center;
        border: 2px dashed #ddd;
        border-radius: 4px;
        color: #394264;
        cursor: pointer;
        padding: 10px;
        margin: 0 auto;
    } 
    .inputfile + label.highlight {
        border-color: #394264;
    }
    .inputfile + label svg {
        width: 2em;
        height: 2em;
        vertical-align: middle;
        fill: currentColor;
        margin-top: -0.25em;
        margin-right: 0.25em;
    }
    .upload-zone span {
        display: block;
        line-height: 12px;
    }
    .nbd-upload-items {
        width: 150px;
        height: 150px;
        display: inline-block;
        margin: 15px;        
    }
    .nbd-upload-items-inner {
        display: flex;
        align-items: flex-end;
        justify-content: center;
        width: 100%;
        height: 100%;
        text-align: center;
        position: relative;
        overflow: hidden;
    } 
    .nbd-upload-item {
        max-width: 100%;
        max-height: 100%;
    }
    .nbd-upload-item-title {
        position: absolute;
        border: 0;
        background: #fff;
        width: 100%;
        height: 30px;
        line-height: 30px;
        text-overflow: ellipsis;
        overflow: hidden;
        padding: 0 5px;
        white-space: nowrap;
        font-weight: bold;
        background: rgba(255, 255, 255, 0.75);
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px;        
    }
    .nbd-upload-items-inner span {
        position: absolute;
        z-index: 2;
        width: 30px;
        height: 30px;
        cursor: pointer;
        background: #fff;
        line-height: 30px;
        -webkit-transform: translateY(30px);
        -moz-transform: translateY(30px);
        transform: translateY(30px);
        -webkit-transition: all 0.4s;
        -moz-transition: all 0.4s;
        transition: all 0.4s;
        border-radius: 50%;
        font-size: 20px;
        color: #cc324b;
    }
    .nbd-upload-items-inner:hover span {
        -webkit-transform: translateY(-10px);
        -moz-transform: translateY(-10px);
        transform: translateY(-10px);
    }
    .upload-design-preview {
        margin: 15px;
        max-height: 300px;
        max-width: 720px;
        position: relative;
        overflow: hidden;
    }    
    .submit-upload-design:hover {
        box-shadow: 0 11px 15px -7px rgba(0,0,0,.2), 0 24px 38px 3px rgba(0,0,0,.14), 0 9px 46px 8px rgba(0,0,0,.12);
    }
    .submit-upload-design {
        height: 40px;
        border-radius: 20px;
        background: #fff;
        padding: 0 15px;
        color: #394264;
        text-transform: uppercase;
        font-weight: bold;
        line-height: 40px;
        cursor: pointer;
        display: inline-block;
        margin-top: 15px;
        box-shadow: 0 5px 6px -3px rgba(0,0,0,.2), 0 9px 12px 1px rgba(0,0,0,.14), 0 3px 16px 2px rgba(0,0,0,.12);
    }    
    .upload-zone {
        position: relative;
    }
    .upload-zone .nbd-upload-loading {
        position: absolute;
        top: 50%;
        left: 50%;
        -webkit-transform: translate(-50%, -50%);
        -moz-transform: translate(-50%, -50%);
        transform: translate(-50%, -50%);
        z-index: -1;
        visibility: hidden;
        opacity: 0;
    }
    .upload-zone .nbd-upload-loading.is-visible {
        visibility: visible;
        z-index: 2;
        opacity: 1;
    }
    .inputfile + label.is-loading {
        opacity: 0.75;
    }
    .nbd-m-upload-design-wrap.is-loading {
        pointer-events: none;
    }
    #container-online-designer {
        position: fixed; 
        top: 0; 
        left: 0; 
        bottom: 0;
        left: 0;
        width: 100vw; 
        height: 100vh; 
        z-index: -1; 
        opacity: 0;
        visibility: hidden;
        -webkit-transition: opacity 400ms 0ms, visibility 0ms 0ms, z-index 0ms 0ms;
        -moz-transition: opacity 400ms 0ms, visibility 0ms 0ms, z-index 0ms 0ms;
        transition: opacity 400ms 0ms, visibility 0ms 0ms, z-index 0ms 0ms;        
    }
    #container-online-designer.is-visible {
        opacity: 1;
        z-index: 999999999; 
        visibility: visible;
        -webkit-transition: opacity 200ms 0ms, visibility 0ms 0ms, z-index 0ms 0ms;
        -moz-transition: opacity 200ms 0ms, visibility 0ms 0ms, z-index 0ms 0ms;
        transition: opacity 200ms 0ms, visibility 0ms 0ms, z-index 0ms 0ms;        
    } 
    @media screen and (max-width: 768px){
        #container-online-designer {
            height: 100%;
        }
    }
</style>
<script type="text/javascript">
    var nbd_layout = '<?php echo $layout; ?>';
    var is_nbd_upload = '<?php echo $_enable_upload; ?>';
    var use_our_template = <?php echo $show_button_use_our_template; ?>;
    var hide_us_design_for_you = <?php echo $show_button_hide_us; ?>;
    var is_nbd_upload_without_design = <?php echo $_enable_upload_without_design; ?>;
</script>
<?php do_action('before_nbdesigner_frontend_container', $pid, $option); ?>
<div class="nbdesigner_frontend_container">
    <input name="nbd-add-to-cart" type="hidden" value="<?php echo $pid; ?>" />
    <p>
        <a class="button nbdesigner_disable alt nbdesign-button <?php echo $class; ?>" id="triggerDesign" >
            <img class="nbdesigner-img-loading hide" src="<?php echo NBDESIGNER_PLUGIN_URL.'assets/images/loading.gif' ?>"/>
            <?php echo $label; ?>
        </a>
    </p>   
    <h4 id="nbdesigner-preview-title" style="display: none;"><?php _e('Custom design', 'web-to-print-online-designer'); ?></h4>    
    <div id="nbd-actions" style="display: none;">
    <?php
        if( $layout == 'c' ){
            if( nbdesigner_get_option( 'nbdesigner_save_for_later', 'no' ) == 'yes' ) include('classic-layout-save-for-later.php');
            if( nbdesigner_get_option( 'nbdesigner_share_design', 'no' ) == 'yes' ) include('classic-layout-share-design.php');
        }
    ?>
    </div>    
    <div id="nbdesigner_frontend_area"></div>
    <h4 id="nbdesigner-upload-title" style="display: none;"><?php _e('Upload file', 'web-to-print-online-designer'); ?></h4>
    <div id="nbdesigner_upload_preview" style="margin-bottom: 15px;"></div>
    <?php if($extra_price != ''): ?>
    <p><?php _e('Extra price for design', 'web-to-print-online-designer'); ?> + <?php echo $extra_price; ?></p>
    <?php endif; ?>
    <?php do_action('nbd_after_single_product_design_section', $pid, $option); ?>
</div>
<?php do_action('after_nbdesigner_frontend_container', $pid, $option); ?>
<div style="" id="container-online-designer" data-iframe="<?php echo $src; ?>">
    <?php if($layout == 'c'): ?>
    <div id="nbd-custom-design-wrap" class="nbd-custom-design-wrap">
        <div id="nbd_processing">
            <div class="atom-loading">
                <div class="loading__ring">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><path d="M85.5,42c-0.2-0.8-0.5-1.7-0.8-2.5c-0.3-0.9-0.7-1.6-1-2.3c-0.3-0.7-0.6-1.3-1-1.9c0.3,0.5,0.5,1.1,0.8,1.7  c0.2,0.7,0.6,1.5,0.8,2.3s0.5,1.7,0.8,2.5c0.8,3.5,1.3,7.5,0.8,12c-0.4,4.3-1.8,9-4.2,13.4c-2.4,4.2-5.9,8.2-10.5,11.2  c-1.1,0.7-2.2,1.5-3.4,2c-0.5,0.2-1.2,0.6-1.8,0.8s-1.3,0.5-1.9,0.8c-2.6,1-5.3,1.7-8.1,1.8l-1.1,0.1L53.8,84c-0.7,0-1.4,0-2.1,0  c-1.4-0.1-2.9-0.1-4.2-0.5c-1.4-0.1-2.8-0.6-4.1-0.8c-1.4-0.5-2.7-0.9-3.9-1.5c-1.2-0.6-2.4-1.2-3.7-1.9c-0.6-0.3-1.2-0.7-1.7-1.1  l-0.8-0.6c-0.3-0.1-0.6-0.4-0.8-0.6l-0.8-0.6L31.3,76l-0.2-0.2L31,75.7l-0.1-0.1l0,0l-1.5-1.5c-1.2-1-1.9-2.1-2.7-3.1  c-0.4-0.4-0.7-1.1-1.1-1.7l-1.1-1.7c-0.3-0.6-0.6-1.2-0.9-1.8c-0.2-0.5-0.6-1.2-0.8-1.8c-0.4-1.2-1-2.4-1.2-3.7  c-0.2-0.6-0.4-1.2-0.5-1.9c-0.1-0.6-0.2-1.2-0.3-1.8c-0.3-1.2-0.3-2.4-0.4-3.7c-0.1-1.2,0-2.5,0.1-3.7c0.2-1.2,0.3-2.4,0.6-3.5  c0.1-0.6,0.3-1.1,0.4-1.7l0.1-0.8l0.3-0.8c1.5-4.3,3.8-8,6.5-11c0.8-0.8,1.4-1.5,2.1-2.1c0.9-0.9,1.4-1.3,2.2-1.8  c1.4-1.2,2.9-2,4.3-2.8c2.8-1.5,5.5-2.3,7.7-2.8s4-0.7,5.2-0.6c0.6-0.1,1.1,0,1.4,0s0.4,0,0.4,0h0.1c2.7,0.1,5-2.2,5-5  c0.1-2.7-2.2-5-5-5c-0.2,0-0.2,0-0.3,0c0,0-0.2,0.1-0.6,0.1c-0.4,0-1,0-1.8,0.1c-1.6,0.1-4,0.4-6.9,1.2c-2.9,0.8-6.4,2-9.9,4.1  c-1.8,1-3.6,2.3-5.4,3.8C26,21.4,25,22.2,24.4,23c-0.2,0.2-0.4,0.4-0.6,0.6c-0.2,0.2-0.5,0.4-0.6,0.7c-0.5,0.4-0.8,0.9-1.3,1.4  c-3.2,3.9-5.9,8.8-7.5,14.3l-0.3,1l-0.2,1.1c-0.1,0.7-0.3,1.4-0.4,2.1c-0.3,1.5-0.4,2.9-0.5,4.5c0,1.5-0.1,3,0.1,4.5  c0.2,1.5,0.2,3,0.6,4.6c0.1,0.7,0.3,1.5,0.4,2.3c0.2,0.8,0.5,1.5,0.7,2.3c0.4,1.6,1.1,3,1.7,4.4c0.3,0.7,0.7,1.4,1.1,2.1  c0.4,0.8,0.8,1.4,1.2,2.1c0.5,0.7,0.9,1.4,1.4,2s0.9,1.3,1.5,1.9c1.1,1.3,2.2,2.7,3.3,3.5l1.7,1.6c0,0,0.1,0.1,0.1,0.1c0,0,0,0,0,0  c0,0,0,0,0,0l0.1,0.1l0.1,0.1h0.2l0.5,0.4l1,0.7c0.4,0.2,0.6,0.5,1,0.7l1.1,0.6c0.8,0.4,1.4,0.9,2.1,1.2c1.4,0.7,2.9,1.5,4.4,2  c1.5,0.7,3.1,1,4.6,1.5c1.5,0.3,3.1,0.7,4.7,0.8c1.6,0.2,3.1,0.2,4.7,0.2c0.8,0,1.6-0.1,2.4-0.1l1.2-0.1l1.1-0.1  c3.1-0.4,6.1-1.3,8.9-2.4c0.8-0.3,1.4-0.6,2.1-0.9s1.3-0.7,2-1.1c1.3-0.7,2.6-1.7,3.7-2.5c0.5-0.4,1-0.9,1.6-1.3l0.8-0.6l0.2-0.2  c0,0,0.1-0.1,0.1-0.1c0.1-0.1,0,0,0,0v0.1l0.1-0.1l0.4-0.4c0.5-0.5,1-1,1.5-1.5c0.3-0.3,0.5-0.5,0.8-0.8l0.7-0.8  c0.9-1.1,1.8-2.2,2.5-3.3c0.4-0.6,0.7-1.1,1.1-1.7c0.3-0.7,0.6-1.2,0.9-1.8c2.4-4.9,3.5-9.8,3.7-14.4C87.3,49.7,86.6,45.5,85.5,42z"></path></svg>
                </div>
                <div class="loading__ring">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><path d="M85.5,42c-0.2-0.8-0.5-1.7-0.8-2.5c-0.3-0.9-0.7-1.6-1-2.3c-0.3-0.7-0.6-1.3-1-1.9c0.3,0.5,0.5,1.1,0.8,1.7  c0.2,0.7,0.6,1.5,0.8,2.3s0.5,1.7,0.8,2.5c0.8,3.5,1.3,7.5,0.8,12c-0.4,4.3-1.8,9-4.2,13.4c-2.4,4.2-5.9,8.2-10.5,11.2  c-1.1,0.7-2.2,1.5-3.4,2c-0.5,0.2-1.2,0.6-1.8,0.8s-1.3,0.5-1.9,0.8c-2.6,1-5.3,1.7-8.1,1.8l-1.1,0.1L53.8,84c-0.7,0-1.4,0-2.1,0  c-1.4-0.1-2.9-0.1-4.2-0.5c-1.4-0.1-2.8-0.6-4.1-0.8c-1.4-0.5-2.7-0.9-3.9-1.5c-1.2-0.6-2.4-1.2-3.7-1.9c-0.6-0.3-1.2-0.7-1.7-1.1  l-0.8-0.6c-0.3-0.1-0.6-0.4-0.8-0.6l-0.8-0.6L31.3,76l-0.2-0.2L31,75.7l-0.1-0.1l0,0l-1.5-1.5c-1.2-1-1.9-2.1-2.7-3.1  c-0.4-0.4-0.7-1.1-1.1-1.7l-1.1-1.7c-0.3-0.6-0.6-1.2-0.9-1.8c-0.2-0.5-0.6-1.2-0.8-1.8c-0.4-1.2-1-2.4-1.2-3.7  c-0.2-0.6-0.4-1.2-0.5-1.9c-0.1-0.6-0.2-1.2-0.3-1.8c-0.3-1.2-0.3-2.4-0.4-3.7c-0.1-1.2,0-2.5,0.1-3.7c0.2-1.2,0.3-2.4,0.6-3.5  c0.1-0.6,0.3-1.1,0.4-1.7l0.1-0.8l0.3-0.8c1.5-4.3,3.8-8,6.5-11c0.8-0.8,1.4-1.5,2.1-2.1c0.9-0.9,1.4-1.3,2.2-1.8  c1.4-1.2,2.9-2,4.3-2.8c2.8-1.5,5.5-2.3,7.7-2.8s4-0.7,5.2-0.6c0.6-0.1,1.1,0,1.4,0s0.4,0,0.4,0h0.1c2.7,0.1,5-2.2,5-5  c0.1-2.7-2.2-5-5-5c-0.2,0-0.2,0-0.3,0c0,0-0.2,0.1-0.6,0.1c-0.4,0-1,0-1.8,0.1c-1.6,0.1-4,0.4-6.9,1.2c-2.9,0.8-6.4,2-9.9,4.1  c-1.8,1-3.6,2.3-5.4,3.8C26,21.4,25,22.2,24.4,23c-0.2,0.2-0.4,0.4-0.6,0.6c-0.2,0.2-0.5,0.4-0.6,0.7c-0.5,0.4-0.8,0.9-1.3,1.4  c-3.2,3.9-5.9,8.8-7.5,14.3l-0.3,1l-0.2,1.1c-0.1,0.7-0.3,1.4-0.4,2.1c-0.3,1.5-0.4,2.9-0.5,4.5c0,1.5-0.1,3,0.1,4.5  c0.2,1.5,0.2,3,0.6,4.6c0.1,0.7,0.3,1.5,0.4,2.3c0.2,0.8,0.5,1.5,0.7,2.3c0.4,1.6,1.1,3,1.7,4.4c0.3,0.7,0.7,1.4,1.1,2.1  c0.4,0.8,0.8,1.4,1.2,2.1c0.5,0.7,0.9,1.4,1.4,2s0.9,1.3,1.5,1.9c1.1,1.3,2.2,2.7,3.3,3.5l1.7,1.6c0,0,0.1,0.1,0.1,0.1c0,0,0,0,0,0  c0,0,0,0,0,0l0.1,0.1l0.1,0.1h0.2l0.5,0.4l1,0.7c0.4,0.2,0.6,0.5,1,0.7l1.1,0.6c0.8,0.4,1.4,0.9,2.1,1.2c1.4,0.7,2.9,1.5,4.4,2  c1.5,0.7,3.1,1,4.6,1.5c1.5,0.3,3.1,0.7,4.7,0.8c1.6,0.2,3.1,0.2,4.7,0.2c0.8,0,1.6-0.1,2.4-0.1l1.2-0.1l1.1-0.1  c3.1-0.4,6.1-1.3,8.9-2.4c0.8-0.3,1.4-0.6,2.1-0.9s1.3-0.7,2-1.1c1.3-0.7,2.6-1.7,3.7-2.5c0.5-0.4,1-0.9,1.6-1.3l0.8-0.6l0.2-0.2  c0,0,0.1-0.1,0.1-0.1c0.1-0.1,0,0,0,0v0.1l0.1-0.1l0.4-0.4c0.5-0.5,1-1,1.5-1.5c0.3-0.3,0.5-0.5,0.8-0.8l0.7-0.8  c0.9-1.1,1.8-2.2,2.5-3.3c0.4-0.6,0.7-1.1,1.1-1.7c0.3-0.7,0.6-1.2,0.9-1.8c2.4-4.9,3.5-9.8,3.7-14.4C87.3,49.7,86.6,45.5,85.5,42z"></path></svg>
                </div>
            </div>  
        </div>
    </div>
    <?php
        else: 
        $product    = wc_get_product($pid);
        $option     = unserialize(get_post_meta($pid, '_nbdesigner_upload', true));
    ?>
    <script type="text/javascript">
        var nbd_allow_type  = "<?php echo $option['allow_type']; ?>",
        nbd_disallow_type   = "<?php echo $option['disallow_type']; ?>",
        nbd_number          = parseInt(<?php echo $option['number']; ?>),
        nbd_minsize         = parseInt(<?php echo $option['minsize']; ?>),
        nbd_maxsize         = parseInt(<?php echo $option['maxsize']; ?>);
    </script>
    <div class="nbd-m-custom-design-wrap" id="nbd-m-custom-design-wrap">
        <div id="nbd_processing">
            <div class="atom-loading">
                <div class="loading__ring">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><path d="M85.5,42c-0.2-0.8-0.5-1.7-0.8-2.5c-0.3-0.9-0.7-1.6-1-2.3c-0.3-0.7-0.6-1.3-1-1.9c0.3,0.5,0.5,1.1,0.8,1.7  c0.2,0.7,0.6,1.5,0.8,2.3s0.5,1.7,0.8,2.5c0.8,3.5,1.3,7.5,0.8,12c-0.4,4.3-1.8,9-4.2,13.4c-2.4,4.2-5.9,8.2-10.5,11.2  c-1.1,0.7-2.2,1.5-3.4,2c-0.5,0.2-1.2,0.6-1.8,0.8s-1.3,0.5-1.9,0.8c-2.6,1-5.3,1.7-8.1,1.8l-1.1,0.1L53.8,84c-0.7,0-1.4,0-2.1,0  c-1.4-0.1-2.9-0.1-4.2-0.5c-1.4-0.1-2.8-0.6-4.1-0.8c-1.4-0.5-2.7-0.9-3.9-1.5c-1.2-0.6-2.4-1.2-3.7-1.9c-0.6-0.3-1.2-0.7-1.7-1.1  l-0.8-0.6c-0.3-0.1-0.6-0.4-0.8-0.6l-0.8-0.6L31.3,76l-0.2-0.2L31,75.7l-0.1-0.1l0,0l-1.5-1.5c-1.2-1-1.9-2.1-2.7-3.1  c-0.4-0.4-0.7-1.1-1.1-1.7l-1.1-1.7c-0.3-0.6-0.6-1.2-0.9-1.8c-0.2-0.5-0.6-1.2-0.8-1.8c-0.4-1.2-1-2.4-1.2-3.7  c-0.2-0.6-0.4-1.2-0.5-1.9c-0.1-0.6-0.2-1.2-0.3-1.8c-0.3-1.2-0.3-2.4-0.4-3.7c-0.1-1.2,0-2.5,0.1-3.7c0.2-1.2,0.3-2.4,0.6-3.5  c0.1-0.6,0.3-1.1,0.4-1.7l0.1-0.8l0.3-0.8c1.5-4.3,3.8-8,6.5-11c0.8-0.8,1.4-1.5,2.1-2.1c0.9-0.9,1.4-1.3,2.2-1.8  c1.4-1.2,2.9-2,4.3-2.8c2.8-1.5,5.5-2.3,7.7-2.8s4-0.7,5.2-0.6c0.6-0.1,1.1,0,1.4,0s0.4,0,0.4,0h0.1c2.7,0.1,5-2.2,5-5  c0.1-2.7-2.2-5-5-5c-0.2,0-0.2,0-0.3,0c0,0-0.2,0.1-0.6,0.1c-0.4,0-1,0-1.8,0.1c-1.6,0.1-4,0.4-6.9,1.2c-2.9,0.8-6.4,2-9.9,4.1  c-1.8,1-3.6,2.3-5.4,3.8C26,21.4,25,22.2,24.4,23c-0.2,0.2-0.4,0.4-0.6,0.6c-0.2,0.2-0.5,0.4-0.6,0.7c-0.5,0.4-0.8,0.9-1.3,1.4  c-3.2,3.9-5.9,8.8-7.5,14.3l-0.3,1l-0.2,1.1c-0.1,0.7-0.3,1.4-0.4,2.1c-0.3,1.5-0.4,2.9-0.5,4.5c0,1.5-0.1,3,0.1,4.5  c0.2,1.5,0.2,3,0.6,4.6c0.1,0.7,0.3,1.5,0.4,2.3c0.2,0.8,0.5,1.5,0.7,2.3c0.4,1.6,1.1,3,1.7,4.4c0.3,0.7,0.7,1.4,1.1,2.1  c0.4,0.8,0.8,1.4,1.2,2.1c0.5,0.7,0.9,1.4,1.4,2s0.9,1.3,1.5,1.9c1.1,1.3,2.2,2.7,3.3,3.5l1.7,1.6c0,0,0.1,0.1,0.1,0.1c0,0,0,0,0,0  c0,0,0,0,0,0l0.1,0.1l0.1,0.1h0.2l0.5,0.4l1,0.7c0.4,0.2,0.6,0.5,1,0.7l1.1,0.6c0.8,0.4,1.4,0.9,2.1,1.2c1.4,0.7,2.9,1.5,4.4,2  c1.5,0.7,3.1,1,4.6,1.5c1.5,0.3,3.1,0.7,4.7,0.8c1.6,0.2,3.1,0.2,4.7,0.2c0.8,0,1.6-0.1,2.4-0.1l1.2-0.1l1.1-0.1  c3.1-0.4,6.1-1.3,8.9-2.4c0.8-0.3,1.4-0.6,2.1-0.9s1.3-0.7,2-1.1c1.3-0.7,2.6-1.7,3.7-2.5c0.5-0.4,1-0.9,1.6-1.3l0.8-0.6l0.2-0.2  c0,0,0.1-0.1,0.1-0.1c0.1-0.1,0,0,0,0v0.1l0.1-0.1l0.4-0.4c0.5-0.5,1-1,1.5-1.5c0.3-0.3,0.5-0.5,0.8-0.8l0.7-0.8  c0.9-1.1,1.8-2.2,2.5-3.3c0.4-0.6,0.7-1.1,1.1-1.7c0.3-0.7,0.6-1.2,0.9-1.8c2.4-4.9,3.5-9.8,3.7-14.4C87.3,49.7,86.6,45.5,85.5,42z"></path></svg>
                </div>
                <div class="loading__ring">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><path d="M85.5,42c-0.2-0.8-0.5-1.7-0.8-2.5c-0.3-0.9-0.7-1.6-1-2.3c-0.3-0.7-0.6-1.3-1-1.9c0.3,0.5,0.5,1.1,0.8,1.7  c0.2,0.7,0.6,1.5,0.8,2.3s0.5,1.7,0.8,2.5c0.8,3.5,1.3,7.5,0.8,12c-0.4,4.3-1.8,9-4.2,13.4c-2.4,4.2-5.9,8.2-10.5,11.2  c-1.1,0.7-2.2,1.5-3.4,2c-0.5,0.2-1.2,0.6-1.8,0.8s-1.3,0.5-1.9,0.8c-2.6,1-5.3,1.7-8.1,1.8l-1.1,0.1L53.8,84c-0.7,0-1.4,0-2.1,0  c-1.4-0.1-2.9-0.1-4.2-0.5c-1.4-0.1-2.8-0.6-4.1-0.8c-1.4-0.5-2.7-0.9-3.9-1.5c-1.2-0.6-2.4-1.2-3.7-1.9c-0.6-0.3-1.2-0.7-1.7-1.1  l-0.8-0.6c-0.3-0.1-0.6-0.4-0.8-0.6l-0.8-0.6L31.3,76l-0.2-0.2L31,75.7l-0.1-0.1l0,0l-1.5-1.5c-1.2-1-1.9-2.1-2.7-3.1  c-0.4-0.4-0.7-1.1-1.1-1.7l-1.1-1.7c-0.3-0.6-0.6-1.2-0.9-1.8c-0.2-0.5-0.6-1.2-0.8-1.8c-0.4-1.2-1-2.4-1.2-3.7  c-0.2-0.6-0.4-1.2-0.5-1.9c-0.1-0.6-0.2-1.2-0.3-1.8c-0.3-1.2-0.3-2.4-0.4-3.7c-0.1-1.2,0-2.5,0.1-3.7c0.2-1.2,0.3-2.4,0.6-3.5  c0.1-0.6,0.3-1.1,0.4-1.7l0.1-0.8l0.3-0.8c1.5-4.3,3.8-8,6.5-11c0.8-0.8,1.4-1.5,2.1-2.1c0.9-0.9,1.4-1.3,2.2-1.8  c1.4-1.2,2.9-2,4.3-2.8c2.8-1.5,5.5-2.3,7.7-2.8s4-0.7,5.2-0.6c0.6-0.1,1.1,0,1.4,0s0.4,0,0.4,0h0.1c2.7,0.1,5-2.2,5-5  c0.1-2.7-2.2-5-5-5c-0.2,0-0.2,0-0.3,0c0,0-0.2,0.1-0.6,0.1c-0.4,0-1,0-1.8,0.1c-1.6,0.1-4,0.4-6.9,1.2c-2.9,0.8-6.4,2-9.9,4.1  c-1.8,1-3.6,2.3-5.4,3.8C26,21.4,25,22.2,24.4,23c-0.2,0.2-0.4,0.4-0.6,0.6c-0.2,0.2-0.5,0.4-0.6,0.7c-0.5,0.4-0.8,0.9-1.3,1.4  c-3.2,3.9-5.9,8.8-7.5,14.3l-0.3,1l-0.2,1.1c-0.1,0.7-0.3,1.4-0.4,2.1c-0.3,1.5-0.4,2.9-0.5,4.5c0,1.5-0.1,3,0.1,4.5  c0.2,1.5,0.2,3,0.6,4.6c0.1,0.7,0.3,1.5,0.4,2.3c0.2,0.8,0.5,1.5,0.7,2.3c0.4,1.6,1.1,3,1.7,4.4c0.3,0.7,0.7,1.4,1.1,2.1  c0.4,0.8,0.8,1.4,1.2,2.1c0.5,0.7,0.9,1.4,1.4,2s0.9,1.3,1.5,1.9c1.1,1.3,2.2,2.7,3.3,3.5l1.7,1.6c0,0,0.1,0.1,0.1,0.1c0,0,0,0,0,0  c0,0,0,0,0,0l0.1,0.1l0.1,0.1h0.2l0.5,0.4l1,0.7c0.4,0.2,0.6,0.5,1,0.7l1.1,0.6c0.8,0.4,1.4,0.9,2.1,1.2c1.4,0.7,2.9,1.5,4.4,2  c1.5,0.7,3.1,1,4.6,1.5c1.5,0.3,3.1,0.7,4.7,0.8c1.6,0.2,3.1,0.2,4.7,0.2c0.8,0,1.6-0.1,2.4-0.1l1.2-0.1l1.1-0.1  c3.1-0.4,6.1-1.3,8.9-2.4c0.8-0.3,1.4-0.6,2.1-0.9s1.3-0.7,2-1.1c1.3-0.7,2.6-1.7,3.7-2.5c0.5-0.4,1-0.9,1.6-1.3l0.8-0.6l0.2-0.2  c0,0,0.1-0.1,0.1-0.1c0.1-0.1,0,0,0,0v0.1l0.1-0.1l0.4-0.4c0.5-0.5,1-1,1.5-1.5c0.3-0.3,0.5-0.5,0.8-0.8l0.7-0.8  c0.9-1.1,1.8-2.2,2.5-3.3c0.4-0.6,0.7-1.1,1.1-1.7c0.3-0.7,0.6-1.2,0.9-1.8c2.4-4.9,3.5-9.8,3.7-14.4C87.3,49.7,86.6,45.5,85.5,42z"></path></svg>
                </div>
            </div>  
        </div>        
    </div>
    <div class="nbd-m-upload-design-wrap" id="nbd-m-upload-design-wrap">
        <?php 
            $advanced_upload = false;
            $upload_style = nbdesigner_get_option('nbdesigner_upload_popup_style', 's');
            if( $_enable_upload ){
                if( $upload_style == 'a' && isset( $option['advanced_upload'] ) && $option['advanced_upload'] == 1 ){
                    include('advanced-upload.php'); 
                    $advanced_upload = true;
                }else{
                    include('simple-upload.php');
                }
            }
        ?>
    </div> 
    <?php if( ( $_enable_upload || $show_button_use_our_template || $show_button_hide_us ) && !$_enable_upload_without_design ): ?>
    <div class="nbd-popup-wrap" id="nbd__content__overlay">
        <div class="nbd__pop__content">
            <div class="nbd__pop__content_wrapper <?php if( ( $show_button_use_our_template || $show_button_hide_us ) && $_enable_upload ) echo 'nbd__pop_wide'; ?>">
                <div class="__content_wrapper">
                    <div class="content__header"><?php _e('How would you like to design your', 'web-to-print-online-designer'); ?> <b><?php echo $product->get_title(); ?></b></div>
                    <div class="content__content">
                        <?php if( $_enable_upload ) include('btn-upload-option.php'); ?>
                        <?php include('btn-design-option.php'); ?>
                        <?php 
                            if($show_button_use_our_template){
                                $template_gallery_url =  add_query_arg(array(
                                    'pid'    =>  $pid
                                    ),  getUrlPageNBD('gallery'));
                                include('btn-browse-template-option.php');
                            }
                        ?>
                        <?php 
                            if( $show_button_hide_us ){
                                global $product;
                                $hire_us_link =  $product->get_permalink() . 'request-design';
                                include('btn-request-option.php');
                            }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>
    <span id="closeFrameDesign" class="nbdesigner_pp_close">&times;</span>
</div>
<script>
    var nbd_create_own_page = "<?php echo getUrlPageNBD('create') ?>"; 
    var nbu_advanced_upload = "<?php if( $advanced_upload ) echo '1'; else echo '0'; ?>";
</script>