<?php
global $post;
if ( $this->query_seller->have_posts() ) {?>
<ul>
	<?php
	while ( $this->query_seller->have_posts() ) {
		$this->query_seller->the_post();
		$product = wc_get_product($post->ID);
		$thumbnail = wp_get_attachment_url( get_post_thumbnail_id( $product->get_id() ) );
		?>
		<li class="clearfix">
			<a href="<?php echo get_permalink($product->get_id());?>" class="selling-product-thumb" target="_blank">
				<img src="<?php echo $thumbnail;?>" />
			</a>
			
			<div class="selling-product-right">
				<div class="selling-product-detail">
					<h4><a href="<?php echo get_permalink($product->get_id());?>" title="<?php echo $product->get_title();?>" target="_blank"><?php echo $product->get_title();?></a></h4>
					<p><?php echo wp_trim_words( get_the_excerpt( $product->get_id() ), 20, '...' );?></p>
				</div>
				<span class="price"><?php echo $product->get_price_html();?></span>
			</div>
			
		</li>
		<?php }
	wp_reset_postdata();?>
</ul>
<?php }?>