<?php
/**
 * Plugin Name: Netbase Dashboard
 * Plugin URI: https://netbaseteam.com/
 * Description: New dashboard. Beautifully.
 * Version: 1.2.1
 * Author: Netbase Team
 * Author URI: https://netbaseteam.com
 * Text Domain: nb-dashboard
 *
 * @package WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define WC_PLUGIN_FILE.
if ( ! defined( 'NBDB_PLUGIN_FILE' ) ) {
	define( 'NBDB_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'NBDB_ABSPATH' ) ) {
	define( 'NBDB_ABSPATH', dirname( NBDB_PLUGIN_FILE ) . '/' );
}

if ( ! defined( 'NBDB_ABSURL' ) ) {
	define('NBDB_ABSURL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'NBDB_PID' ) ) {
	define( 'NBDB_PID', 1211 );
}

if ( ! defined( 'NBDB_GITLAB_ID' ) ) {
	define( 'NBDB_GITLAB_ID', 9026344 );
}

if ( ! defined( 'NBDB_GITLAB_PRIVATE_TOKEN' ) ) {
	define( 'NBDB_GITLAB_PRIVATE_TOKEN', 'vnY-QKMwzysDdguqQuRv' );
}

final class NB_Dashboard {

	var $page_slug = 'netbase-dashboard';
	
	public function __construct() {
		$this->hooks();
		$this->includes();
	}
	
	public function hooks() {
		add_action( 'admin_init', array($this, 'page_redirect'), 999);
		add_action( 'admin_menu', array($this, 'add_admin_menu_settings') );
		add_filter( 'login_redirect', array($this, 'login_redirect'), 10, 3 );
		add_action( 'admin_notices', array($this, 'install_woocommerce_admin_notice') );
	}
	
	public function add_admin_menu_settings() {
		global $submenu;
	
		$capability		= 'manage_options';
		
		$dashboard = add_menu_page(
			__( 'Dashboard'),
			__('Dashboard'),
			$capability,
			$this->page_slug,
			array( $this, 'netbase_dashboard' ),
			'dashicons-dashboard',
			1
		);
		
		add_options_page( 
			'My Options',
			__('Admin UI', 'nb-dashboard'),
			'manage_options',
			'nb-dashboard',
			array('NBD_Settings', 'settings_page')
		);
		
		$submenu[ $this->page_slug ][5] = array( __( 'Home' ), $capability, 'admin.php?page=' . $this->page_slug );
		if ( ! is_multisite() || current_user_can( 'update_core' ) ) {
			if ( ! isset( $update_data ) ) {
				$update_data = wp_get_update_data();
			}
			$count = "<span class='update-plugins count-{$update_data['counts']['plugins']}'><span class='plugin-count'>" . number_format_i18n( $update_data['counts']['plugins'] ) . '</span></span>';
			$submenu[$this->page_slug][10] = array( sprintf( __( 'Updates %s' ), $count ), $capability, 'update-core.php' );
		}

		remove_menu_page( 'index.php' );
	}
	
	public function page_redirect() {
		if( preg_match( '/index.php$/', $_SERVER['REQUEST_URI'] ) || preg_match( '/\/wp-admin\/$/', $_SERVER['REQUEST_URI'] ) ) {
			wp_redirect( admin_url('admin.php?page=' . $this->page_slug) );
			die();
		}
	}
	
	/**
	 * Redirect user after successful login.
	 *
	 * @param string $redirect_to URL to redirect to.
	 * @param string $request URL the user is coming from.
	 * @param object $user Logged user's data.
	 * @return string
	 */

	public function login_redirect( $redirect_to, $request, $user ) {
		//is there a user to check?
		if (isset($user->roles) && is_array($user->roles)) {
			//check for subscribers
			if (in_array('administrator', $user->roles)) {
				// redirect them to another URL, in this case, the homepage 
				$redirect_to = admin_url('admin.php?page=' . $this->page_slug);
			}
		}

		return $redirect_to;
	}

	/**
	 * Display a custom menu page
	 */
	public function netbase_dashboard() {
		$screen      = get_current_screen();
		
		/** Load WordPress Bootstrap */
		require_once( ABSPATH . '/wp-admin/admin.php' );

		/** Load WordPress dashboard API */
		require_once( ABSPATH . 'wp-admin/includes/dashboard.php' );

		wp_dashboard_setup();
		
		$dashboard_exclude = array(
			'dashboard_quick_press',
			'dashboard_primary',
			'wpseo-dashboard-overview',
			'yith_dashboard_blog_news',
			'yith_dashboard_products_news',
			'dashboard_activity',
			'dashboard_right_now'
		);

		
		echo '<div class="wrap wrap-top" id="nb-dashboard-wrap">';
		include_once NBDB_ABSPATH . 'templates/dashboard.php';
		echo '</div>';
		
		wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false );
		
		wp_enqueue_script( 'dashboard' );
	}

	public function install_woocommerce_admin_notice() {
		if( ! get_option('nb_dashboard_logo') || ! get_option('nb_dashboard_admin_color') ) {
			?>
			<div class="error">
				<p><?php echo 'Please visit Settings > <a href="'. admin_url('options-general.php?page=nb-dashboard') .'">Admin UI</a> to change your logo, style,... before use <strong>Netbase Dashboard</strong>.'; ?></p>
			</div>
			<?php
		}
	}
	
	public function includes() {
		include_once NBDB_ABSPATH . 'includes/functions.php';

		include_once NBDB_ABSPATH . 'classes/class-singleton.php';
		
		include_once NBDB_ABSPATH . 'classes/class-admin-report.php';
		include_once NBDB_ABSPATH . 'classes/class-report-order.php';
		include_once NBDB_ABSPATH . 'classes/class-settings-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-notification-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-analytics-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-remove-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-template-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-ajax-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-widget-dashboard.php';
		include_once NBDB_ABSPATH . 'classes/class-cache-dashboard.php';
		
	}
}

new NB_Dashboard();

if ( ! function_exists('write_log')) {
   function write_log ( $log )  {
      if ( is_array( $log ) || is_object( $log ) ) {
         error_log( print_r( $log, true ) );
      } else {
         error_log( $log );
      }
   }
}
