<?php

class Google_Analytics_Stats {

    /**
     * Init plugin actions.
     *
     */
    public static function init() {
    }

    /**
     * Preparing query to get Analytics data
     *
     * @param string $query query type
     * @param int $id_view The Analytics view ID from which to retrieve data.
     * @param string $date_range The start date for the query in the format YYYY-MM-DD or '7daysAgo'
     * @param string $metric A metric expression
     *
     * @return array Request query
     */
    public static function get_query( $query, $id_view, $date_range = null, $metric = null ) {
        if ( $query == 'main_chart' ) {
            return self::main_chart_query( $id_view, $date_range, $metric );
        } elseif ( $query == 'boxes' ) {
            return self::boxes_query( $id_view );
        } elseif ( $query == 'dashboard_boxes' ) {
            return self::dashboard_boxes_query( $id_view, $date_range );
        } elseif ( $query == 'sources' ) {
            return self::sources_query( $id_view );
        } else {
            return array();
        }
    }

    /**
     * Preparing query for chart
     *
     * @param int $id_view The Analytics view ID from which to retrieve data.
     * @param string $date_range The start date for the query in the format YYYY-MM-DD or '7daysAgo'
     * @param string $metric A metric expression
     *
     * @return array Chart query
     */
    public static function main_chart_query( $id_view, $date_range = null, $metric = null ) {
        if ( empty( $date_range ) ) {
            $date_ranges = self::set_date_ranges( '7daysAgo', 'today', '14daysAgo', '8daysAgo' );
        } else {
            $date_ranges = self::set_date_ranges( $date_range, 'today' );
        }

        if ( empty( $metric ) ) {
            $metric = 'ga:pageviews';
        } else {
            $metric = 'ga:' . $metric;
        }

        $reports_requests	 = array();
        $reports_requests[]	 = array(
            'viewId'			 => $id_view,
            'dateRanges'		 => $date_ranges,
            'metrics'			 => self::set_metrics( $metric ),
            'includeEmptyRows'	 => true,
            'dimensions'		 => self::set_dimensions( 'ga:date' )
        );
        $query				 = array(
            'reportRequests' => $reports_requests
        );

        return $query;
    }


    /**
     * Setting metrics for requests
     *
     * @param mixed $expression A metric expression or array of expressions
     *
     * @return array Metrics
     */
    public static function set_metrics( $expression ) {
        $metrics = array();
        if ( is_array( $expression ) ) {
            foreach ( $expression as $exp ) {
                $metrics[] = array(
                    'expression' => $exp
                );
            }
        } else {
            $metrics[] = array(
                'expression' => $expression
            );
        }

        return $metrics;
    }

    /**
     * Setting dimensions for requests
     *
     * @param string $name Name of the dimension to fetch, for example ga:browser.
     *
     * @return array Dimensions
     */
    public static function set_dimensions( $name ) {
        $dimensions		 = array();
        $dimensions[]	 = array(
            'name' => $name
        );

        return $dimensions;
    }

    /**
     * Setting date ranges for requests
     *
     * @param string $start_date The start date for the query in the format YYYY-MM-DD.
     * @param string $end_date The end date for the query in the format YYYY-MM-DD.
     * @param string $prev_start_date The start date (second range) for the query in the format YYYY-MM-DD.
     * @param string $prev_end_date The start date (second range) for the query in the format YYYY-MM-DD.
     *
     * @return array Date ranges
     */
    public static function set_date_ranges( $start_date, $end_date, $prev_start_date = '', $prev_end_date = '' ) {
        $date_danges	 = array();
        $date_danges[]	 = array(
            'startDate'	 => $start_date,
            'endDate'	 => $end_date
        );
        if ( !empty( $prev_start_date ) and ! empty( $prev_end_date ) ) {
            $date_danges[] = array(
                'startDate'	 => $prev_start_date,
                'endDate'	 => $prev_end_date
            );
        }

        return $date_danges;
    }

    /**
     * Get chart from response data
     *
     * @param array $response_data Analytics response data
     *
     * @return array chart data
     */
    public static function get_chart( $response_data ) {
        $chart_data = array();
        if ( !empty( $response_data ) ) {
            $data	 = (!empty( $response_data[ 'reports' ] ) && !empty( $response_data[ 'reports' ][ 0 ] ) && !empty( $response_data[ 'reports' ][ 0 ][ 'data' ] ) ) ? $response_data[ 'reports' ][ 0 ][ 'data' ] : array();

            $rows	 = (!empty( $data[ 'rows' ] ) ) ? $data[ 'rows' ] : array();
            if ( !empty( $rows ) ) {
                foreach ( $rows as $key => $row ) {
                    $chart_data[ 'horizontal' ][ $key ]		 = date( 'd M', strtotime( $row[ 'dimensions' ][ 0 ] ) );
                    $chart_data[ 'vertical' ][ $key ]	 = !empty( $row[ 'metrics' ][ 0 ][ 'values' ][ 0 ] ) ? $row[ 'metrics' ][ 0 ][ 'values' ][ 0 ] : 0;
                }
            }
        }

        return $chart_data;
    }
}