<?php
class NB_Dashboard_Template {

	public $nodes;

	public function __construct() {
		add_action( 'admin_head', array( $this, 'render_admin_head'));
		add_action( 'admin_footer', array($this, 'render_html_dashboard'), 100 );
		add_action( 'admin_print_scripts', array( $this, 'enqueue_scripts' ) );
		add_filter( 'admin_footer_text', '__return_false' );
		add_action( 'wp_before_admin_bar_render', array( $this, 'reorder_admin_bar') );

	}

	public function reorder_admin_bar() {
		global $wp_admin_bar;

		$this->nodes = $wp_admin_bar->get_nodes();



	}

	public function render_admin_head() {



		$color_scheme = @unserialize( base64_decode(get_option('nb_dashboard_color_scheme')) );
		$admin_color = get_option('nb_dashboard_admin_color');

		if( empty($color_scheme) ) {
			$color_scheme = array(
				'left_primary' => '#323945',
				'left_primary_hover' => '#3b4351',
				'top_primary' => '#4285f4',
				'top_primary_hover' => '#518ff5',
				'top_primary_color' => '#fff',
				'top_icon_color' => '#4285f4'
			);
		}

		if($color_scheme) {
			
			if( $google_fonts = $this->generator_google_fonts() ) {
				echo '<link href="'. $google_fonts['url'] .'" rel="stylesheet">';
				echo "<style>
				html.wp-toolbar body,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .new-content-sub li a,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-cache-info,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-delete-cache,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-cache-info p,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-cache-info table td,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav .pc-header-search .pc-admin-form .nbd-search-rs ul li h4,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav .pc-header-search .pc-admin-form .nbd-search-rs ul li p,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav .pc-header-search .pc-admin-form .nbd-search-rs ul li .search-empty-rs,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-wrapper .pc-admin-profiles-menu li a,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name p,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name a,
				#wpadminbar .pc-notifications .pc-notifications-submenu .pc-notifications-heading,
				#wpadminbar .pc-notifications .pc-notifications-submenu ul li .pc-notifications-right h4,
				#wpadminbar .pc-notifications .pc-notifications-submenu ul li .pc-notifications-right p,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li span,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-wrapper .pc-admin-profiles .pc-admin-profiles-wrap h3,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-wrapper .pc-admin-profiles .pc-admin-profiles-wrap p {
					font-family: '". $google_fonts['name'] . "', serif !important;
				}";
			}else {
				echo '<style>';
			}

			echo '
			#wpadminbar .adminpanel-hamburger {
				border-top: 3px solid ' . $color_scheme['top_primary_color'] . ' !important;
				border-bottom: 3px solid ' . $color_scheme['top_primary_color'] . ' !important;
			}
			#wpadminbar .adminpanel-hamburger:before {
				border-top: 3px solid ' . $color_scheme['top_primary_color'] . ' !important;
			}

			';

			if( $admin_color == 'white' ) {
				echo '
				html.wp-toolbar #wpadminbar {
					background-color: #fff !important;
					border-bottom: 1px solid #fff !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name a,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name p {
					color: #444 !important;	
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .pc-menu-toggle span {
					background: ' . $color_scheme['top_icon_color'] . ' !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .new-content-sub:before {
					border-bottom-color: ' . $color_scheme['left_primary'] . ' !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .new-content-sub {
					border-color: ' . $color_scheme['left_primary'] . ' !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .new-content-sub,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-cache-info table td {
					background-color: ' . $color_scheme['left_primary'] . ' !important;
					color: #eee !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .new-content-sub li a,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-cache-info p {
					color: #eee !important;	
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search li.new_content .new-content-sub li:hover,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-delete-cache {
					background-color: #3b4351 !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-delete-cache {
					border-top: 1px solid #262b34 !important;
					color: #eee !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search .new-content-sub li:hover a {
					color: #1e83f9 !important;
				}
				';
			}else {
				echo 'html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li i, html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li span {
					color: #fff !important;
				}
				html.wp-toolbar #wpadminbar {
					background-color: ' . $color_scheme['top_primary'] . ' !important;
					border-bottom: 1px solid ' . $color_scheme['top_primary'] . ' !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li>a>i,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name a,
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name p {
					color: ' . $color_scheme['top_primary_color'] . ' !important;
				}
				html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-search ul li#wp-admin-bar-autoptimize #wp-admin-bar-autoptimize-cache-info table td {
					background-color: #fff !important;
				}
				';
			}


			echo '</style>';
		}
	}

	public function render_html_dashboard() {
	    
	    if( isset($_GET['page']) && $_GET['page'] == 'merlin') {
			return;
		}
		
		echo '<div class="nbd-loading"><div><div class="c1"></div><div class="c2"></div><div class="c3"></div><div class="c4"></div></div></div>';

		/* Recent Orders */
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$query_recent_orders = new WP_Query( array(
				'posts_per_page' => 6,
				'post_type'   => wc_get_order_types(),
				'post_status' => array_keys( wc_get_order_statuses() )
			) );
			
			$unpaid_status = wc_get_order_statuses();
			$unpaid_status = array(
				'wc-on-hold' => $unpaid_status['wc-on-hold'],
				'wc-processing' => $unpaid_status['wc-processing'],
				'wc-pending' => $unpaid_status['wc-pending'],
				
			);
			$query_recent_orders_unpaid = new WP_Query( array(
				'posts_per_page' => 6,
				'post_type'   => wc_get_order_types(),
				'post_status' => array_keys( $unpaid_status )
			) );
			
			$sell_product_args = array(
				'post_type' => 'product',
				'meta_key' => 'total_sales',
				'orderby' => 'meta_value_num',
				'posts_per_page' => 5,
			);
			$query_seller = new WP_Query( $sell_product_args );
		}else {
			$query_seller = $query_recent_orders = $query_recent_orders_unpaid = '';
		}
		
		/* Comments */
		$comment_args = array( 
			'number'      => 10, 
			'status'      => 'approve', 
			'post_status' => 'publish', 
			'post_type'   => 'product' 
		);

		$comments = get_comments( $comment_args );
		
		$args = array(
			'query_seller' => $query_seller,
			'get_best_buyer' => nbd_get_best_buyer(),
			'comments' => $comments,
			'analytics_stats' => Google_Analytics_Admin::generate_stats_data(),
			'query_recent_orders' => $query_recent_orders,
			'query_recent_orders_unpaid' => $query_recent_orders_unpaid,
			'usernames' => nbd_get_lists_user(),
			'changelogs' => nbd_get_changelog(),
			'videos' => nbd_get_video(),
			'chartorder' => nbd_get_chartorder_default(),
			'chartamount' => nbd_get_chartamount_default()
		);

		if( class_exists('WooCommerce') ) {
			$args = array_merge($args, array(
				'lists_order_status' => wc_get_order_statuses()
			));
		}

		$this->render_script_template( 'nb-dashboard', 'dashboard.php', $args );
	
		/* Menu bar */
		$current_user = wp_get_current_user();
		$screen = nbd_get_screen();

		$new_posts = array();
		$new_autoptimize = array();
		foreach( $this->nodes as $k => $v ) {
			if( $v->parent == 'new-content') {
				$new_posts[] = $v;
			}

			if( $v->parent == 'autoptimize') {
				$new_autoptimize[] = $v;
			}
		}
		
		$this->render_script_template('nb-dashboard-menubar', 'dashboard-menu-bar.php', array(
			'current_user' => $current_user,
			'nodes' => $this->nodes,
			'nodes_update' => isset($this->nodes['updates']) ? $this->nodes['updates'] : array(),
			'nodes_comments' => isset($this->nodes['comments']) ? $this->nodes['updates'] : array(),
			'node_new_posts' => $new_posts,
			'node_new_autoptimize' => $new_autoptimize,
			'notification_lists' => get_option('nb_notification_lists')
		));
		
		$this->render_script_template('nb-dashboard-menumain', 'dashboard-menu-main.php');
	}
	
	public function render_script_template( $id, $file, $args = array() ) {
		$inc = NBDB_ABSPATH . 'templates/' . $file;
		
		if( file_exists($inc) ) {
			extract($args);
			
			echo '<script id="tpl-'. $id .'" type="text/template">';
			include_once $inc;
			echo '</script>';
		}		
	}
	
	public function enqueue_scripts() {
		$screen = get_current_screen();


		
		
		$extra = array();

		if( ! empty($screen) && $screen->id == 'dashboard' || ! empty($screen) && $screen->id == 'toplevel_page_netbase-dashboard' || $screen->id == 'update-core' ) {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
				$price = str_replace('%2$s', 'number', get_woocommerce_price_format());
				$price = str_replace('%1$s', get_woocommerce_currency_symbol(), $price);
				$decimals = wc_get_price_decimals();
				$decimal_separator = wc_get_price_decimal_separator();
				$thousand_separator = wc_get_price_thousand_separator();
			}else {
				$price = str_replace('%1$s', '', $price);
				$price = str_replace('%2$s', '', $price);
				$decimals = 2;
				$decimal_separator = '.';
				$thousand_separator = ',';
			}
			
			$extra = array(
				'format_money' => $price,
				'decimals' => $decimals,
				'decimal_separator' => $decimal_separator,
				'thousand_separator' => $thousand_separator
			);
			
			wp_enqueue_style( 'admin-daterangepicker', NBDB_ABSURL . 'assets/css/daterangepicker.css' );
			
			wp_enqueue_script( 'admin-moment', NBDB_ABSURL . 'assets/js/moment.min.js' , array() );
			wp_enqueue_script( 'admin-daterangepicker', NBDB_ABSURL . 'assets/js/daterangepicker.js' , array() );
			wp_enqueue_script( 'admin-chart', 'https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.2/Chart.js' , array() );
			wp_enqueue_script( 'nb-dashboard', NBDB_ABSURL . 'assets/js/dashboard.js', array(  ));
		}
		
		if( ! empty($screen) && $screen->base == 'settings_page_nb-dashboard') {
			wp_enqueue_media();
		}
		wp_enqueue_style( 'nb-dashboard', NBDB_ABSURL . 'assets/css/dashboard.min.css', array( )  );
		wp_enqueue_script( 'nb-dashboard-slimscroll', NBDB_ABSURL . 'assets/js/jquery.slimscroll.min.js', array(  ));

		
		wp_enqueue_script( 'nb-dashboard-blockUI', NBDB_ABSURL . 'assets/js/jquery.blockUI.js', array(  ));
		wp_enqueue_script( 'nb-dashboard-cookie', NBDB_ABSURL . 'assets/js/js.cookie.js', array(  ));
		wp_enqueue_script( 'nb-dashboard-admin', NBDB_ABSURL . 'assets/js/admin.js', array(  ));


		$img_src = '/assets/images/logo.png';
		if( ! file_exists( get_template_directory() . $img_src) ) {
			$img_src = NBDB_ABSURL . 'assets/images/default-logo.jpg';
		}else {
			$img_src = get_template_directory_uri() . $img_src;
		}
		if( $dashboard_logo = get_option('nb_dashboard_logo') ) {
			$img_src = wp_get_attachment_image_src($dashboard_logo, 'full');
			$img_src = $img_src[0];
		}

		$img_src_short = NBDB_ABSURL . 'assets/images/default-logo-short.png';
		if( $dashboard_logo_mobile = get_option('nb_dashboard_logo_mobile') ) {
			$img_src_mobile = wp_get_attachment_image_src($dashboard_logo_mobile, 'full');
			$img_src_short = $img_src_mobile[0];
		}

		wp_localize_script( 'nb-dashboard-admin', 'nbdashboard', array_merge(array(
			'i18n'        => array(
				'mediaTitle'  => esc_html__( 'Choose an image', 'nb-dashboard' ),
				'mediaButton' => esc_html__( 'Use image', 'nb-dashboard' ),
			),
			'authorize' => admin_url('options-general.php?page=nb-dashboard&alt_action=ga_action_auth'),
			'json_url' => home_url() . '/wp-json/nbdash/v1/%action%',
			'label' => array(
				'item' => __('order', 'nb-dashboard'),
				'items' => __('orders', 'nb-dashboard')
			),
			'admin_url' => admin_url('/admin-ajax.php'),
			'link_logo' => '<div class="admin-header-logo nbd-header-full"><a href="' . home_url("/wp-admin") .'"><img src="' . $img_src .'"></a></div><div class="admin-header-logo nbd-header-short"><a href="' . home_url("/wp-admin") .'"><img src="' . $img_src_short .'"></a></div>'
		), $extra) );
	}

	public function generator_google_fonts() {
		$admin_fonts = get_option('nb_dashboard_fonts');
		if( $admin_fonts ) {
			$google_fonts = nbd_google_fonts();
			if( isset($google_fonts[$admin_fonts]) ) {
				$font_weights = implode(',', $google_fonts[$admin_fonts]);
			}
			
			return [
				'url' => 'https://fonts.googleapis.com/css?family=' . str_replace(' ', '+', $admin_fonts) . ':' . $font_weights,
				'name' => $admin_fonts
			];
		}
	}
}

new NB_Dashboard_Template();