jQuery( function( $ ) {
	
	var ajax_notification = false;

	/**
	 * NBCustomHandler class.
	 */
	var NBD_Admin = {
		init: function() {
			
			this.render_menubar();
			this.render_menumain();
			
			this.calculator_position_submenu();

			//$(document).on( 'click', 'body.wp-admin:not(.folded) #adminmenu > li.wp-has-submenu > a:not(.toplevel_page_dashboard)', this.click_menu_left);
			$(document).on('click', '.nb-upload-image-button', this.upload_image);
			$(document).on('click', '.adminpanel-icon-search', this.admin_search);
			$(document).on('click', '.nb-remove-image-button', this.remove_upload_image);
			$(document).on('click', '#alt_ga_authorize_google', this.authorize);
			$(document).on('click', '.pc-admin-header-avatar .pc-has-sublink', this.show_profiles_menu);
			$(document).on('click', '.pc-notifications a', this.show_notifications_menu);
			$(document).on('click', '.link-logout', this.link_logout);
			$(document).on('change', '#nb_dashboard_cf7', this.change_wpcf7);

			$(document).on('click', '.pc-notifications', this.read_notification);
			$(document).on('click', '.pc-menu-toggle', this.menu_toggle_left);
			// $(document).on('mouseenter', '#adminmenuwrap.nbd-toggle', this.menu_toggle_menu_open);
			// $(document).on('mouseleave', '#adminmenuwrap.nbd-toggle', this.menu_toggle_menu_close);
			$(document).on('click', '.color-option', this.color_scheme);
			
			

			$(window).load(function() {
				NBD_Admin.heading();
				$('.nbd-loading').remove();
			});

			
			$( window ).resize(function() {
				NBD_Admin.menu_responsive();
			});
			
			$('#admin-search').keyup(function(e) {
				clearTimeout($.data(this, 'timer'));
				if (e.keyCode == 13)
				  search(true);
				else
				  $(this).data('timer', setTimeout(NBD_Admin.trigger_search, 500));
			});
			
			$(document).mouseup(function(e) 
			{
				if($(".pc-header-search").length){
				    var container = $(".pc-header-search");

				    if ( ! container.is(e.target) && container.has(e.target).length === 0 ) 
				    {
						$('.pc-header-search').removeClass('active');
						$('#admin-search').val('');
						$('.nbd-search-rs ul').empty();
						$('.nbd-search-rs').hide();
				    }
				}

				if( $(".pc-admin-header-avatar .pc-admin-header-wrapper").length ){
					var container = $(".pc-admin-header-avatar .pc-admin-header-wrapper");
					var main = $(".pc-admin-header-avatar .pc-avatar-main");
					
				    if ( ! container.is(e.target) && container.has(e.target).length === 0 && ! main.is(e.target) && main.has(e.target).length === 0) 
				    {
						container.hide();
						$('.pc-admin-header-avatar .pc-admin-header-name').removeClass('active');
				    }
				}

				if( $(".pc-notifications .pc-notifications-submenu").length ){
					var container = $(".pc-notifications .pc-notifications-submenu");
					var icon = $(".pc-notifications > a");
				    if ( ! container.is(e.target) && container.has(e.target).length === 0 && ! icon.is(e.target) && icon.has(e.target).length === 0 ) 
				    {
						container.hide();
						$('.pc-notifications').removeClass('nbd-active');
				    }
				}
			});
			
			$('#adminmenuback').html(nbdashboard.link_logo);

			if( Cookies.get('menu_toggle') ) {
				NBD_Admin.menu_toggle_left();
				$('.pc-menu-toggle').addClass('active');
				
			}

			$(window).on( 'scroll', function() {
				var $w = $(window).width(),
				$scrollTop = $(this).scrollTop();
				if( $w <= 600 && $('body.branch-5').hasClass('wp-editor') ) {
					if(  $scrollTop > 1 ) {
						$('.edit-post-header').addClass('edit-header-fixed');
					}else {
						$('.edit-post-header').removeClass('edit-header-fixed');
					}
					
				}
				if( $w > 768 ) {
					
					if( $(this).scrollTop() > 70 ) {
						var $eheight = $(window).height() - 70;
						var $sub_height = $('#adminmenu').outerHeight() - 70;
						var total_item = $('#adminmenu > li').length;
						var li_height = $('#adminmenu > li:first-child > a').outerHeight();
	
						var pos = $scrollTop - 70;
						
						if( $('#adminmenu > li.wp-menu-open').length > 0 ) {
							var extra_total_item = $('#adminmenu > li.wp-menu-open > .wp-submenu>li').length;
							var total_item =  total_item + extra_total_item;
						}
	
						var x = total_item - (Math.round($eheight / li_height)),
						y = Math.round(pos / li_height);
			
						console.log(x + '___' + y);
						if( y > x ) {
							$('#adminmenuwrap:not(.nbd-toggle)').css({"position": "fixed", "top": "auto"});
							console.log('not fixed');
						}else {
							$('#adminmenuwrap:not(.nbd-toggle)').css({"position": "absolute", "top": "64px"});
							console.log('scroll');
						}
					}else {
						console.log('-----scroll');
						$('#adminmenuwrap:not(.nbd-toggle)').css({"position": "static"});
					}
				}
				

	
			});

			NBD_Admin.menu_responsive();
		},

		admin_search: function(e) {
			e.preventDefault();

			$('.pc-header-search').addClass('active');
		},

		calculator_position_submenu: function() {
			$( "#adminmenu > li" ).hover(
				function() {
				  var $this = $(this),
					  sub = $(this).find(' > .wp-submenu'),
					  win_height = $(window).height(),
					  _top = ($this.offset().top - $(document).scrollTop());
					  
  
				  var eheight = 0;
				  sub.find( "li" ).each(function( index ) {
					  eheight += 40;
				  });
				  var _pos = (_top + eheight) - win_height;
  
				  if( _pos > 0) {
					  $this.addClass('bottom-sub');
				  }
				}
			  );
		},

		replace_hover: function($ul, $li) {
			if( $li.hasClass('menu-current') ) {
				if( $li.hasClass('menu-current') ) {
					$ul.slideUp();
					$li.removeClass('menu-current');
				}else {
					$ul.slideDown();
					$li.addClass('menu-current');
				}
			}else {
				if( $li.hasClass('wp-menu-open') ) {
					$ul.slideUp();
					$li.removeClass('wp-menu-open');
				}else {
					var $other = $('#adminmenu > li:not(.wp-has-current-submenu)');
					$other.removeClass('wp-menu-open');
					$other.find('.wp-submenu').slideUp();

					$ul.slideDown();
					$li.addClass('wp-menu-open');
				}
				
			}
		},

		color_scheme: function() {
			var color_scheme = $(this).find('.tog').attr('data-value');
			$('.nb_dashboard_color_scheme').val(color_scheme);
		},

		menu_responsive: function() {
			var w= $(window).width();

			if(w <= 768) {
				
				$('html.wp-toolbar #wpcontent, html.wp-toolbar #wpfooter').css("margin-left", "0");
				$('#adminmenuwrap, #wpcontent, body.branch-5 .edit-post-header').removeAttr('style');
				$('#adminmenuwrap').removeClass('nbd-toggle');
				$('#wpadminbar.mobile').removeClass('active');
				$('.pc-menu-toggle').removeClass('active');
			}else {
				

				if( $('#adminmenuback').hasClass('nbd-toggle') ) {
					$('html.wp-toolbar #wpcontent, html.wp-toolbar #wpfooter').css("margin-left", "70px");
				}else {
					$('html.wp-toolbar #wpcontent, html.wp-toolbar #wpfooter').removeAttr('style');
				}
			}

			if(w > 768 && w <= 1024) {
				NBD_Admin.menu_toggle_left();
				$('.pc-menu-toggle').addClass('active');
				$('#adminmenuwrap').show();
			}
		},
		

		menu_toggle_left: function() {
			var w = $(window).width();

			if(w > 768) {
				if( $(this).hasClass('active') ) {
					$(this).removeClass('active');

					$('#adminmenuback, #adminmenuwrap').removeClass('nbd-toggle');

					$('html.wp-toolbar #adminmenuwrap, html.wp-toolbar #adminmenuback').animate({
						width: '220px',
					});

					$('html.wp-toolbar #wpcontent').animate({
						marginLeft: '220px',
					});

			
					$('html.wp-toolbar #wpadminbar, body.branch-5 .edit-post-header').animate({
						left: '220px'
					});
					Cookies.remove('menu_toggle');
				}else {
					$(this).addClass('active');

					$('#adminmenuback, #adminmenuwrap').addClass('nbd-toggle', 5000, 'swing');

					$('#adminmenuwrap, html.wp-toolbar #adminmenuback').animate({
						width: '70px',
					});

					$('html.wp-toolbar #wpcontent').animate({
						marginLeft: '70px',
					});

					$('html.wp-toolbar #wpadminbar, body.branch-5 .edit-post-header').animate({
						left: '70px'
					});

					Cookies.set('menu_toggle', true);
				}
			}else {
				if( $(this).hasClass('active') ) {
					$(this).removeClass('active');
					Cookies.remove('menu_toggle');

					$('html.wp-toolbar .auto-fold #adminmenuwrap').slideUp();
				}else {
					$(this).addClass('active');
					Cookies.set('menu_toggle', true);

					$('html.wp-toolbar .auto-fold #adminmenuwrap').slideDown();
				}
			}
		},

		menu_toggle_menu_open: function() {
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).addClass('active');
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).animate({
				width: '220px',
			});

		},
		
		menu_toggle_menu_close: function() {
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).removeClass('active');
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).animate({
				width: '70px',
			});
		},

		trigger_search: function(force) {
			$('form .adminpanel-icon-search').hide();
			$('.adminpanel-icon-sloading').show();
			var action_json = nbdashboard.json_url.replace("%action%", "live_search");
			var existingString = $("#admin-search").val();
			if (!force && existingString.length < 3) return; //wasn't enter, not > 2 char
				$.ajax({
					url: action_json,
					data: { search: existingString },
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						$('form .adminpanel-icon-search').show();
						$('form .adminpanel-icon-sloading').hide();
						if( response.complete != undefined ) {		
							$('.pc-admin-form .nbd-search-rs ul').html(response.html);
							$('.pc-admin-form .nbd-search-rs').show();
						}
					},
					error: function() {
						$('form .adminpanel-icon-search').show();
						$('form .adminpanel-icon-sloading').hide();
					}
				});
		},
		
		read_notification: function() {
			var count = $(this).attr('data-count');

			if( ! ajax_notification ) {
				ajax_notification = true;
				
				var action_json = nbdashboard.json_url.replace("%action%", "read_notification");

				$.ajax({
					url: action_json,
					data: {},
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {
							$('.pc-notifications-count').text(response.count);
						}
					},
					error: function() {
						//alert('There was an error when processing data, please try again !');
					}
				});
				
			}
		},
		
		change_wpcf7: function(e) {
			e.preventDefault();
			
			var $cf7id = $(this).val();
			
			if( $cf7id ) {
				
				var action_json = nbdashboard.json_url.replace("%action%", "cf7field");

				$.ajax({
					url: action_json,
					data: { id: $cf7id},
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {
							$('#nb_dashboard_cf7_field').find('select').html(response.fields);
							$('#nb_dashboard_cf7_field').show();
						}
					},
					error: function() {
						alert('There was an error when processing data, please try again !');
					}
				});
			}else{
				$('#nb_dashboard_cf7_field').hide();
			}
		},
		
        link_logout: function(event) {
            event.isDefaultPrevented();

            var action_json = nbdashboard.json_url.replace("%action%", "logout");

            $.ajax({
                url: action_json,
                data: {},
                type: 'POST',
                datatype: 'json',
                success: function( response ) {
					if( response.complete != undefined ) {
                        window.location.href = response.location;
					}
                },
                error: function() {
                    alert('There was an error when processing data, please try again !');
                }
            })
		},
		
		show_profiles_menu: function(event) {
			event.preventDefault();
			$('.admin-submenu').hide();


			var $this = $(this).closest('li');
			if( $(this).hasClass('active') ) {
				$(this).removeClass('active');
				$this.find('.admin-submenu').hide();
			}else {
				$(this).addClass('active')
				$this.find('.admin-submenu').show();
			}
		},
		
		show_notifications_menu: function(event) {
			event.preventDefault();
			$('.pc-notifications-submenu').hide();

			var $this = $(this).closest('li');
			if( $('.pc-notifications').hasClass('nbd-active') ) {
				$('.pc-notifications').removeClass('nbd-active');
				$this.find('.pc-notifications-submenu').hide();
			}else {
				$('.pc-notifications').addClass('nbd-active');
				$this.find('.pc-notifications-submenu').show();
				if( $( ".pc-notifications-submenu ul li" ).length > 5 ) {
					$('.pc-notifications-submenu ul').slimScroll({
						height: 450
					});
				}
			}
		},
		
		authorize: function (e, url) {
            e.preventDefault();
            const p_width = Math.round(screen.width / 2);
            const p_height = Math.round(screen.height / 2);
            const p_left = Math.round(p_width / 2);
            const p_top = 200;
            window.open(nbdashboard.authorize, 'ga_auth_popup', 'width=' + p_width + ',height='
                + p_height + ',top=' + p_top + ',left=' + p_left);
        },
		
		upload_image: function(e){
			e.preventDefault();
			var $button = $( this ).closest('.nb-wrap-image');

			// If the media frame already exists, reopen it.
			if ( frame ) {
				frame.open();
				return;
			}
			
			// Create the media frame.
			var frame = wp.media.frames.downloadable_file = wp.media({
				title   : 'NB Dashboard Logo',
				button  : {
					text: 'Use image'
				},
				multiple: false
			});

			// When an image is selected, run a callback.
			frame.on( 'select', function () {
				var attachment = frame.state().get( 'selection' ).first().toJSON();
				$button.find( 'input.nb-image' ).val( attachment.id );
				$button.find( 'input.nb-image-url' ).val( attachment.sizes.full.url );
				$button.find( '.nb-remove-image-button' ).show();
				$button.find( 'img' ).attr( 'src', attachment.sizes.full.url );
			} );

			// Finally, open the modal.
			frame.open();
		},
		
		remove_upload_image: function(){
			var $button = $( this );

			$button.siblings( 'input.nb-image' ).val( '' );
			$button.siblings( '.nb-remove-image-button' ).show();
			$button.parent().prev( '.nb-image-thumbnail' ).find( 'img' ).attr( 'src', $( this ).closest('tr').attr('data-src') );

			return false;
		},
		
		heading: function() {
			if( $('#nb-dashboard-wrap').length <= 0 ) {
				$('.wp-heading-inline, .page-title-action, .wrap > h1').addClass('page-section');
				$( ".page-section" ).wrapAll( "<div class='admin-heading xxxxxxx' />");	
			}
			
			if( $('.wrap h1.page-section').length > 0 ) {
				$('.wrap').addClass('wrap-top');
			}
		},
		
		
		
		render_menubar: function() {
			var $tpl = $('#tpl-nb-dashboard-menubar').html();
			$('#wpadminbar').html($tpl);
		},

		render_menumain: function() {
			$('.wp-menu-separator').remove();
			$('#adminmenu .wp-has-submenu .wp-menu-name').append('<i class="adminpanel-icon-arrow-right"></i>');
		}
		
	}
	
	NBD_Admin.init();
	
});