<?php
function Netbase_Load_Social_Links_Widget()
{
    register_widget( 'NB_Widgets_Social_Links');
}
add_action( 'widgets_init', 'Netbase_Load_Social_Links_Widget' );

class NB_Widgets_Social_Links extends WP_Widget {
	protected $default;
	protected $socials;

	function __construct() {
		$this->socials = array(
			'facebook'    => esc_html__( 'Facebook', 'nb-elements' ),
			'twitter'     => esc_html__( 'Twitter', 'nb-elements' ),
			'linkedin'    => esc_html__( 'Linkedin', 'nb-elements' ),
			'google-plus' => esc_html__( 'Google Plus', 'nb-elements' ),
			'pinterest'   => esc_html__( 'Pinterest', 'nb-elements' ),
			'tumblr'      => esc_html__( 'Tumblr', 'nb-elements' ),
			'flickr'      => esc_html__( 'Flickr', 'nb-elements' ),
			'instagram'   => esc_html__( 'Instagram', 'nb-elements' ),
			'bitbucket'   => esc_html__( 'Bitbucket', 'nb-elements' ),
			'youtube'     => esc_html__( 'Youtube', 'nb-elements' ),
			'github'      => esc_html__( 'Github', 'nb-elements' ),
			'dribbble'    => esc_html__( 'Dribbble', 'nb-elements' ),
			'rss'         => esc_html__( 'RSS', 'nb-elements' ),
			'android'     => esc_html__( 'Android ', 'nb-elements' ),
			'apple'       => esc_html__( 'Apple', 'nb-elements' ),
			'windows'     => esc_html__( 'Windows', 'nb-elements' ),
		);
		$this->default = array(
			'title' => '',
		);
		foreach ( $this->socials as $k => $v ) {
			$this->default["{$k}_title"] = '';
			$this->default["{$k}_url"]   = '';
		}

		parent::__construct(
			'nbelement-social-links-widget',
			esc_html__( 'NB - Social Links', 'nb-elements' ),
			array(
				'classname'   => 'nbfw-social-links widget__social-link',
				'description' => esc_html__( 'Display links to social media networks.', 'nb-elements' ),
			),
			array( 'width' => 600, 'height' => 350 )
		);
	}

	/**
	 * Outputs the HTML for this widget.
	 *
	 * @param array $args An array of standard parameters for widgets in this theme
	 * @param array $instance An array of settings for this widget instance
	 *
	 * @return void Echoes it's output
	 */
	function widget( $args, $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		extract( $args );
		
		echo wp_kses_post( $before_widget );

		if ( $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}

		echo '<ul class="nbfw-social-link-widget">';
		foreach ( $this->socials as $social => $label ) {
			if ( ! empty( $instance[ $social . '_title' ] ) || ! empty( $instance[ $social . '_url' ] ) ) {
				printf( '<li><a href="%s" rel="nofollow" title="%s"><i class="pt-icon-%s"></i></a></li>',
					$instance[ $social . '_url' ],
					$instance[ $social . '_title' ],
					$social
				);
			}
		}
		echo '</ul>';

		echo wp_kses_post( $after_widget);
	}


	/**
	 * Deals with the settings when they are saved by the admin.
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	/**
	 * Displays the form for this widget on the Widgets page of the WP Admin area.
	 *
	 * @param array $instance
	 *
	 * @return array
	 */
	function form( $instance ) {
		$instance = wp_parse_args( $instance, $this->default );
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'nb-elements' ); ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
		</p>
		<?php
		foreach ( $this->socials as $social => $label ) {
			printf(
				'<div style="width: 280px; float: left; margin-right: 10px;">
					<label>%s</label>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
				</div>',
				$label,
				esc_attr( $this->get_field_name( $social . '_title' ) ),
				esc_html__( 'Title', 'nb-elements' ),
				esc_attr( $instance[ $social . '_title' ] ),
				esc_attr( $this->get_field_name( $social . '_url' ) ),
				esc_html__( 'URL', 'nb-elements' ),
				esc_url( $instance[ $social . '_url' ] )
			);
		}
	}
}
