<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Vc_Step extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'netbase_vc_step', array( $this, 'shortcode_vc_step' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
       
        vc_map(array(
            'name' => esc_html__('NB: VC Step', 'nb-elements'),
            'base' => 'netbase_vc_step',
            'category' => esc_html__('PrintCart', 'nb-elements'),
            'description' => esc_html__('Display Step.', 'nb-elements'),
            'icon' => 'icon-wpb-wp',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'nb-elements'),
                    'param_name' => 'title',
                    'value' => '',
                ),

                array(
                        'heading'    => esc_html__( 'Our Team content', 'nb-elements' ),
                        'type'       => 'param_group',
                        'param_name' => 'vc_step_content',
                        'params'     => array(
                            array(
                                'param_name' => 'step_title',
                                'heading'    => esc_html__( 'Step Title', 'nb-elements' ),
                                'type'       => 'textfield',

                            ),
                            array(
                                'param_name' => 'step_title_number',
                                'heading'    => esc_html__( 'Step Title Number', 'nb-elements' ),
                                'type'       => 'textfield',

                            ),
                            
                            array(
                                'param_name' => 'avatar',
                                'heading'    => esc_html__( 'Avatar', 'nb-elements' ),
                                'type'       => 'attach_image',

                            ),
                            array(
                                'param_name' => 'name',
                                'heading'    => esc_html__( 'Primary Text', 'nb-elements' ),
                                'type'       => 'textfield',

                            ),
                            array(
                                'param_name' => 'content',
                                'heading'    => esc_html__( 'Content', 'nb-elements' ),
                                'type'       => 'textarea',
                                
                            ),
                            
                            
                        ),
                    ),
                array(
                        'param_name' => 'avt_shape',
                        'heading'    => esc_html__( 'Avatar style', 'nb-elements' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Square', 'nb-elements' ) => 'square',
                            __( 'Circle', 'nb-elements' ) => 'circle',
                        ),
                        'std'        => 'circle',
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                    ),
                array(
                        'param_name' => 'style',
                        'heading'    => esc_html__( 'Style', 'nb-elements' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Style 1', 'nb-elements' ) => 'style-1',
                            __( 'Style 2', 'nb-elements' ) => 'style-2',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                ),
                array(
                    'heading'    => __( 'Extra class name', 'nb-elements' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-elements' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-elements' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-elements' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_vc_step($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'step_title' => '',
                    'step_title_number' => '',

                    'avatar'                => '',
                    'avt_shape'             => 'circle',
                    'vc_step_content' =>'',
                    'name'                  => '',
                    'style'                 => 'style-1',
                    'content' => '',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_vc_step_');

        $classes = $attr = array();
        $ifloat = 1;
        
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw vc_step" >';
        if($title){
            $html .= '<h2>'. $title . '</h2>';
        }
        $values = ( array ) vc_param_group_parse_atts( $vc_step_content );
        $html .= '<ul class="vc-step clearfix steps" data-vc-step="element">';
        foreach ( $values as $key => $values ) {

            // Get image link and image data
            if ( ! empty( $values[ 'avatar' ] ) ) {
                $img_id       = preg_replace( '/[^\d]/', '', $values[ 'avatar' ] );
                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
                $image_link   = $image[ 'p_img_large' ][ 0 ];
            }


                $html .= '<li class="vc-step-items step_details">';
                $html .= '<div class="step_number">';

                    $html .= $values[ 'step_title' ].'<span class="number">'.$values[ 'step_title_number' ].'</span>';

                $html .= '</div>';
                if($ifloat % 2==0){
                    $html .= '<div class="vc-step-events item-right step_box" data-vc-step-content="normal">';
                }else{
                    $html .= '<div class="vc-step-events item-left step_box" data-vc-step-content="normal">';
                }
                    
                    if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'nb-elements' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . '  />';
                        $html .= '</div>';
                    }

                    $html .= '<div class="content">';
                    if ( ! empty( $values[ 'name' ] ) ) {
                        $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                    }
                        $html .= '<div>' . $values[ 'content' ] . '</div>';
                    $html .= '</div>';
                    
                $html .= '</div></li>';
                $ifloat ++;
            
            
        }
        $html .= '<ul>'; 
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_vc_step', force_balance_tags($html));
    }

}
new NB_Element_Vc_Step(); 
}