<?php
if (!defined('ABSPATH'))
exit;

if (class_exists("WPBakeryShortCode")) {
    class NB_Element_Intro_Image extends WPBakeryShortCode {
        function __construct() {
            add_action( 'init', array( $this, 'map' ), 12 );
            add_shortcode( 'vc_info_image', array( $this, 'vc_shortcode' ) );
        }

        public function map() {
            vc_map( array(
                "name" => __( "Intro Image", "nb-elements" ),
                "base" => "vc_info_image",
                "class" => "",
                "category" => __( "PrintCart", "nb-elements"),
          
                "params" => array(
                  array(
                      'type' => 'attach_image',
                      'heading' => __('Background Image', 'nb-elements'),
                      'param_name' => 'vc_im_bg',
                      'value' => '',
                      'description' => __('Select image from media library.', 'nb-elements'),
                      'admin_label' => true,
                  ),
                   array(
                      "type" => "colorpicker",
                      "class" => "",
                      "heading" => __( "Background Color", "nb-elements" ),
                      "param_name" => "vc_im_color",
                      "value" => '#FF0000', //Default Red color
                      "description" => __( "Choose text color", "nb-elements" )
                   ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Heading", "nb-elements" ),
                      "param_name" => "vc_im_heading",
                      "value" => __( "Business Cards", "nb-elements" ),
                      "description" => __( "Description for foo param.", "nb-elements" )
                  ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Sales", "nb-elements" ),
                      "param_name" => "vc_im_sales",
                      "value" => __( "Now 25% off.", "nb-elements" ),
                      "description" => __( "Description for foo param.", "nb-elements" )
                  ),
                   array(
                      "type" => "textarea",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Description", "nb-elements" ),
                      "param_name" => "vc_im_desc",
                      "value" => __( "Savings on select products starting<br />at 25% off. Discount percentages<br />may vary on options, upgrades,<br />& accessories.", "nb-elements" ),
                      "description" => __( "Description for foo param.", "nb-elements" )
                  ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Link", "nb-elements" ),
                      "param_name" => "vc_im_href",
                      "value" => __( "#", "nb-elements" ),
                      "description" => __( "Description for foo param.", "nb-elements" )
                  ),
                   array(
                      "type" => "textfield",
                      "holder" => "div",
                      "class" => "",
                      "heading" => __( "Label of link", "nb-elements" ),
                      "param_name" => "vc_im_label",
                      "value" => __( "Shop Now!", "nb-elements" ),
                      "description" => __( "Description for foo param.", "nb-elements" )
                  )
                )
            ));
        }

        public function vc_shortcode($atts, $content = null) {
            extract( shortcode_atts( array(
                'vc_im_bg' => '',
                'vc_im_color' => '',
                'vc_im_heading' => 'Business Cards',
                'vc_im_sales' => 'Now 25% off.',
                'vc_im_desc' => 'Savings on select products starting<br />at 25% off. Discount percentages<br />may vary on options, upgrades,<br />& accessories.',
                'vc_im_href' => '#',
                'vc_im_label' => 'Shop Now!'
            ), $atts ) );
          
            $img_src = wp_get_attachment_image_src($vc_im_bg, 'full');
          
            $html = '<div class="vc-im-wrapper" style="background-image: url('. esc_url($img_src[0]) . '); background-color: '. esc_attr($vc_im_color).'">';
                $html .= '<h4>'. esc_attr( $vc_im_heading ) .'</h4>';
                $html .= '<div class="vc-im-sales">'. esc_attr( $vc_im_sales ) .'</div>';
                $html .= '<h5>' . wp_kses( $vc_im_desc, array( 'br' => array() ) ) .'</h5>';
                $html .= '<a href="' . esc_url($vc_im_href) . '" class="btn btn-shop-now">' . esc_attr( $vc_im_label ) . '</a>';
            $html .= '</div>';
            
            return $html;
        }
    }
    new NB_Element_Intro_Image();
}