<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
    class NB_Element_Banner extends WPBakeryShortCode {
    // Element Init
        function __construct() {
            add_action( 'init', array( $this, 'vc_mapping' ), 12 );
            add_shortcode( 'netbase_vc_banner', array( $this, 'shortcode_banner' ) );
        }

    // Element Mapping
        public function vc_mapping() {

        // Stop all if VC is not enabled
            if ( !defined( 'WPB_VC_VERSION' ) ) {
                return;
            }

        // Map the block with vc_map()
            vc_map( array(
                'name'        => esc_html__( 'Image Banner', 'nb-elements' ),
                'base'        => 'netbase_vc_banner',
                'icon' => 'icon-wpb-wp',
                'category' => __('PrintCart', 'nb-elements'),
                'description' => esc_html__( 'Display image Banner.', 'nb-elements' ),

                'params'      => array(
                //Title
                    array(
                        'type'        => 'textarea',
                        'admin_label' => true,
                        'heading'     => esc_html__( 'Primary Text', 'nb-elements' ),
                        'param_name'  => 'txt_primary',
                        'value'       => '',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ), 

                    array(
                        'heading'    => __( 'Text Primary After', 'nb-elements' ),
                        'param_name' => 'title_e2',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type'        => 'colorpicker',
                        'admin_label' => true,
                        'heading'     => esc_html__( 'Primary Text Color ', 'nb-elements' ),
                        'param_name'  => 'textcolor_custom',
                        'value'       => '',
                        'description' => esc_html__( 'Select the primary text custom color.', 'nb-elements' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',

                    ),  
                    array(
                        'heading'    => __( 'Text Primary Font Size', 'nb-elements' ),
                        'param_name' => 'txt_primary_font_size',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'description' => esc_html__('( Example: 15px or 15% )','nb-elements'),
                    ),

                    array(
                        'heading'     => __( 'Image', 'nb-elements' ),
                        'param_name'  => 'banner_img',
                        'type'        => 'attach_image',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show Image as background', 'nb-elements' ),
                        'param_name' => 'show_img_as_background',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show divider', 'nb-elements' ),
                        'param_name' => 'show_caption_divider',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'heading'    => __( 'Caption text', 'nb-elements' ),
                        'param_name' => 'txt_caption',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                    ),

                    array(
                        'type'        => 'textarea',
                        'admin_label' => true,
                        'heading'     => esc_html__( 'Description', 'nb-elements' ),
                        'param_name'  => 'description',
                        'value'       => '',

                    ),
                    array(
                        'type'        => 'colorpicker',
                        'admin_label' => true,
                        'heading'     => esc_html__( 'Description Text Color ', 'nb-elements' ),
                        'param_name'  => 'textdes_color',
                        'value'       => '',
                        'description' => esc_html__( 'Select the Description text custom color.', 'nb-elements' ),
                    ),
                    array(
                        'heading'    => __( 'Button Text', 'nb-elements' ),
                        'param_name' => 'txt_button',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Url', 'nb-elements' ),
                        'param_name' => 'button_url',
                        'type'       => 'vc_link',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Button Alt text', 'nb-elements' ),
                        'param_name' => 'txt_alt',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Add link to Title', 'nb-elements' ),
                        'param_name' => 'link_to_title',
                    ),
                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Background White', 'nb-elements' ),
                        'param_name' => 'text_info_bg',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Box Circle', 'nb-elements' ),
                        'param_name' => 'text_info_circle',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                //Alignment
                    array(
                        'type'        => 'dropdown',                    
                        'heading'     => esc_html__( 'Text alignment', 'nb-elements' ),
                        'param_name'  => 'text_align',
                        'value'       => array(
                            'Choose the text alignment'     => '',
                            __( 'Text at left', 'nb-elements' )   => 'text-left',
                            __( 'Text at center', 'nb-elements' ) => 'text-center',
                            __( 'Text at right', 'nb-elements' )  => 'text-right',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                //Alignment
                    array(
                        'type'        => 'dropdown',                    
                        'heading'     => esc_html__( 'Text Box Position', 'nb-elements' ),
                        'param_name'  => 'text_position',
                        'value'       => array(
                            'Choose the text alignment'     => '',
                            __( 'Top left', 'nb-elements' )   => 'top-left',
                            __( 'Top Right', 'nb-elements' )   => 'top-right',
                            __( 'Center Center', 'nb-elements' ) => 'center-center',
                            __( 'Center Left', 'nb-elements' )  => 'center-left',
                            __( 'Center Right', 'nb-elements' )  => 'center-right',
                            __( 'Bottom Center', 'nb-elements' )  => 'bottom-center',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),


                    array(
                        'type'        => 'dropdown',                    
                        'heading'     => esc_html__( 'Effect Image', 'nb-elements' ),
                        'param_name'  => 'effect_img',
                        'value'       => array(
                            'Choose the effect'     => '',
                            __( 'Effect Zoom', 'nb-elements' )   => 'effect-zoom',
                            __( 'Effect 1', 'nb-elements' ) => 'effect-1',
                            __( 'Effect 3', 'nb-elements' ) => 'effect-3',
                            __( 'Effect 5', 'nb-elements' ) => 'effect-5',

                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Custom Class', 'nb-elements' ),
                        'param_name' => 'custom_class',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',  
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                  
                    ),

                //Animation
                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Animation', 'nb-elements' ),
                        'param_name'  => 'css_animation',                    
                        'value'       => array(
                            __( 'No', 'nb-elements' )                 => '',
                            __( 'Top to bottom', 'nb-elements' )      => 'top-to-bottom',
                            __( 'Bottom to top', 'nb-elements' )      => 'bottom-to-top',
                            __( 'Left to right', 'nb-elements' )      => 'left-to-right',
                            __( 'Right to left', 'nb-elements' )      => 'right-to-left',
                            __( 'Appear from center', 'nb-elements' ) => 'appear'
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'nb-elements' )
                    ),

                    array(
                        'heading'    => __( 'Custom Bottom Box Position', 'nb-elements' ),
                        'param_name' => 'custom_bottom_box',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'text_position',
                            'value'   => 'bottom-center',
                        ),
                        'description' => esc_html__('( Example: 15px or 15% )','nb-elements'),
                    ),

                    array(
                        'heading'    => __( 'Custom left Box Position', 'nb-elements' ),
                        'param_name' => 'custom_left_box',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'text_position',
                            'value'   => 'center-left',
                        ),
                        'description' => esc_html__('( Example: 15px or 15% )','nb-elements'),
                    ),
                    array(
                        'heading'    => __( 'Custom right Box Position', 'nb-elements' ),
                        'param_name' => 'custom_right_box',
                        'type'       => 'textfield',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'text_position',
                            'value'   => 'center-right',
                        ),
                        'description' => esc_html__('( Example: 15px or 15% )','nb-elements'),
                    ),

                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'nb-elements' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'nb-elements' ),
                    )
                )
) );                               

}   

    // Element HTML
public function shortcode_banner($atts, $content = null)
{
    $custom_class ='';
        // Extract shortcode parameters.
    extract(
        shortcode_atts(
            array(
                'txt_primary' => '',
                'txt_caption' => '',
                'description' => '',
                'txt_button' => '',
                'button_url' => '',
                'txt_alt' => '',
                'link_to_title' => '',
                'show_caption_divider' => '',
                'show_img_as_background' => '',
                'text_info_bg' =>'',
                'text_info_circle' => '',
                'text_align' => 'text-left',
                'text_position'=>'',
                'css_animation' => '',
                'txt_primary_font_size' => '',
                'title_e2' => '',
                'textcolor_custom'         => '',
                'custom_class' => '',
                'effect_img' => '',
                'css' => '',    
                'banner_img' => '',
                'custom_bottom_box' =>'',
                'custom_left_box' =>'',
                'custom_right_box' =>'',
                'textdes_color' =>'',
            ),
            $atts
        )
    );

    $url = $target = $link_title = $rel ='';
    if( $button_url !='' ){
        $href 		= 	vc_build_link($button_url);
        $url 			= ( isset( $href['url'] ) && $href['url'] !== '' ) ? $href['url']  : '';
        $target 		= ( isset( $href['target'] ) && $href['target'] !== '' ) ? esc_attr( trim( $href['target'] ) ) : '';
        $link_title 	= ( isset( $href['title'] ) && $href['title'] !== '' ) ? esc_attr($href['title']) : '';
        $rel 			= ( isset( $href['rel'] ) && $href['rel'] !== '' ) ? esc_attr($href['rel']) : '';
    }

    if($target !=''){ $target = ' target="'.$target.'"'; }
    if($link_title !=''){ $link_title =' title="'.$link_title.'"';}
    if($rel !=''){ $rel = ' rel="'.$rel.'"';}

    $css_class =  $html = $nbcss_custom = '';
    $classes = array();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_vc_banner', $atts ); 
    if($txt_primary_font_size){
        $nbcss_custom .= 'font-size:' . $txt_primary_font_size . ';';
    }
    if ( $textcolor_custom ) {
        $nbcss_custom .= 'color:' . $textcolor_custom . ';';
    }

    if ( $nbcss_custom ) {
        $nbcss_custom = ' style="' . $nbcss_custom . '"';
    }

    if($textdes_color){
        $textdes_color = 'style="color:'.$textdes_color.'"';
    }
    $nbfw_txt_info_style ='';
    if($custom_right_box){
        $nbfw_txt_info_style .= 'right:' . $custom_right_box . ';';
    }
    if($custom_left_box){
        $nbfw_txt_info_style .= 'left:' . $custom_left_box . ';';
    }
    if($text_position == 'bottom-center' && $custom_bottom_box){
        $nbfw_txt_info_style .= 'bottom:' . $custom_bottom_box . ';';
    }

    if($nbfw_txt_info_style){
        $nbfw_txt_info_style ='style="' . $nbfw_txt_info_style . ';"';
    }

    if(isset($text_info_bg)){
        if($text_info_bg){
            $classes[] ='bg-white';
        }  
    }
    if($text_info_circle){
        $classes[] ='box-circle';
    }

    $src = wp_get_attachment_image_src($banner_img,'full');       

    if($text_align && $text_align <> ''){
        $text_align = $text_align;
    }else{
     $text_align = '';
 }

 if($text_position) {
    $text_position = 'p-'.$text_position;
} else {
    $text_position='';
}
$bg_image_style =  $show_img_as_background ? "style='background: url(" . esc_url( $src[0] ) . ")  center/cover no-repeat'" : '';
$has_divider_class = $show_caption_divider ? ' has-divider' : '';

        // Generate HTML code.
$html .= '<div class="nb-fw banner '.$custom_class.' '.$effect_img.' '.esc_attr( $css_class ).'">';

$html .= '<div class="nbfw_banner-container" ' . $bg_image_style . ' >';

if (!$show_img_as_background){
    if($url !='') {
        $html .='<a href="'. esc_url($url).'" '.$target.' '.$link_title.' '.$rel.'>';
    }
    // $html .= '<img src="' . esc_url($src[0]) . '" alt="banner" />';
    $html.=wp_get_attachment_image($banner_img, 'full', false, ['alt'=>$txt_primary]);
    if($url !='') {
        $html .= '</a>';
    }
}

if($txt_caption || $txt_primary || $description || $txt_button){
    $html .= '<div class="nbfw-txt-info '.$text_align.' '.$text_position.' '. esc_attr( implode( ' ', $classes ) ) .'"  '.$nbfw_txt_info_style.'>';
    if($txt_caption){
        $html .='<div class="txt-caption' . $has_divider_class . '"> ' . $txt_caption;
        if($show_caption_divider) $html .= '<span class="txt-caption-divider"></span>';
        $html .= '</div>';
    }
    if($txt_primary){
        $html .='<h4 class="txt-primary" '. $nbcss_custom .'>';
        if($link_to_title && $url !=''){
            $html .='<a href="'. esc_url($url).'" '.$target.' '.$link_title.' '.$rel.'>';
        }
        $html .=' '.$txt_primary ;

        if($title_e2){
            $html .=' '.$title_e2;
        }
        if($link_to_title && $url !=''){
            $html .='</a>';
        }

        $html .='</h4>';
    }

    if($description){
        $html .='<p class="txt-des" '.$textdes_color.'> '.$description.'</p>';
    }
    if($txt_button && $url !=''){
        $html .='<a href="'. esc_url($url).'" class="banner-more">'.$txt_button.'</a>';
    }

    $html .= '</div>';
}

$html .= '</div>';
$html .= '</div>';
        // End HTML code.

wp_reset_postdata();
return apply_filters('netbase_shortcode_banner', force_balance_tags($html));
}

} // End Element Class

// Element Class Init
new NB_Element_Banner(); 
}
