<?php
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
    class NB_Element_Get_To_Know extends WPBakeryShortCode {
        function __construct() {
            add_action( 'init', array( $this, 'map' ), 12 );
            add_shortcode( 'vc_printshop_get_to', array( $this, 'vc_printshop_get_to' ) );
        }

        public function map() {
            vc_map( array(
                "name" => __( "Get to Know", "nb-elements" ),
                "base" => "vc_printshop_get_to",
                "class" => "",
                "category" => __( "PrintCart", "nb-elements"),
                "params" => array(
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __( "Title", "nb-elements" ),
                        "param_name" => "vc_tab_title_post",
                        "value" => 8,
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => __( "Description", 'nb-elements' ),
                        "param_name" => "description_post",
                        "value" => __( "", 'nb-elements' ),
                        "description" => __( "Enter description.", 'nb-elements'),
                    ),
                    array(
                        'type' => 'param_group',
                        'value' => '',
                        'heading' => __('Lists', 'nb-elements'),
                        'param_name' => 'add_vc_getto_lists',
                        'group' => __('Content Options', 'nb-elements'),
                        // Note params is mapped inside param-group:
                        'params' => array(
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-elements'),
                                "class" => "",
                                "heading" => __( "Icon", "nb-elements" ),
                                "param_name" => "add_vc_get_to_icon",
                                "value" => '',
                            ),
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-elements'),
                                "class" => "",
                                "heading" => __( "Heading", "nb-elements" ),
                                "param_name" => "add_vc_get_to_heading",
                                "value" => '',
                            ),
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-elements'),
                                "class" => "",
                                "heading" => __( "Label", "nb-elements" ),
                                "param_name" => "add_vc_get_to_label",
                                "value" => '',
                            )
                        )
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __( "Limit", "nb-elements" ),
                        "param_name" => "vc_tab_product_limit",
                        "value" => 8,
                    )
                )
            ));
        }

        public function vc_printshop_get_to($atts, $content = null) {
            extract( shortcode_atts( array(
                'vc_tab_title_post' => '',
                'description_post' => '',
                'vc_tab_product_limit' => 8
            ), $atts ) );


            ob_start();
            $add_vc_getto_lists = vc_param_group_parse_atts($atts['add_vc_getto_lists']);
            if($add_vc_getto_lists) {
                ?>
                <div class="vc-getto-info">
                    <div class="vc-getto-para">
                        <h2 class="vc-heading-title"><?php echo $vc_tab_title_post; ?></h2>
                        <?php echo $description_post; ?>
                    </div>

                    <ul>
                        <?php
                        foreach ($add_vc_getto_lists as $key => $value) {?>
                            <li>
                                <div class="vc-getto-icon"><i class="<?php echo esc_attr($value['add_vc_get_to_icon']);?>"></i></div>
                                <div class="cinfo-lists">
                                    <h2><?php echo esc_attr($value['add_vc_get_to_heading']);?></h2>
                                    <h4 class="cinfo-description"><?php echo $value['add_vc_get_to_label'];?></h4>
                                </div>
                            </li>
                            <?php
                        } ?>
                    </ul>
                </div>
                <?php
            }
            
            return ob_get_clean();
        }
    }

    new NB_Element_Get_To_Know();
}