<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Heading
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Social extends WPBakeryShortCode {
	// Element Init
    function __construct() {
        add_action( 'init', array( $this, 'add_vc_home7_social' ), 12 );
        add_shortcode( 'vc_home7_social', array( $this, 'vc_home7_social' ) );
    }

	public function add_vc_home7_social() {
		if ( !defined( 'WPB_VC_VERSION' ) ) {
	        return;
		}
		
	    vc_map( array(
	      	"name" => __( "Social", "nb-elements" ),
	      	"base" => "vc_home7_social",
	      	"class" => "",
	      	"category" => __( "PrintCart", "nb-elements"),
	      	"params" => array(
	      		array(
		            'type' => 'textfield',
		            'heading' => __('Facebook', 'nb-elements'),
		            'param_name' => 'vc_facebook',
		            'value' => '',
		            'description' => __(' Facebook link ', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Twitter', 'nb-elements'),
		            'param_name' => 'vc_twitter',
		            'value' => '',
		            'description' => __(' Twitter link ', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Pinterest', 'nb-elements'),
		            'param_name' => 'vc_pinterest',
		            'value' => '',
		            'description' => __(' Pinterest link ', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Linkedin', 'nb-elements'),
		            'param_name' => 'vc_linkedin',
		            'value' => '',
		            'description' => __(' Linkedin link ', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Google plus', 'nb-elements'),
		            'param_name' => 'vc_google_plus',
		            'value' => '',
		            'description' => __('  ', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Instagram', 'nb-elements'),
		            'param_name' => 'vc_instagram',
		            'value' => '',
		            'description' => __(' Instagram link ', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Rss', 'nb-elements'),
		            'param_name' => 'vc_rss',
		            'value' => '',
		            'description' => __(' Rss link ', 'nb-elements'),
		            'admin_label' => true,
		        ),
	      	),
	   	));
	}
	public function vc_home7_social($atts, $content = null){
		$html = '' ;
	   	extract( shortcode_atts( array(
	      	'vc_facebook' => '',
	      	'vc_twitter' => '',
	      	'vc_pinterest' => '',
	      	'vc_linkedin' => '',
	      	'vc_google_plus' => '',
	      	'vc_instagram' => '',
	      	'vc_rss' => '',
	   	), $atts ) );

	   

	   	$html .='<ul class="social-section">';
	   	
	   	if( $vc_facebook != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_facebook ).'"><i class="fa fa-facebook"></i></a></li>';
	   	}
	   	if( $vc_twitter != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_twitter ).'"><i class="fa fa-twitter"></i></a></li>';
	   	}
	   	if( $vc_pinterest != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_linkedin ).'"><i class="fa fa-linkedin"></i></a></li>';
	   	}
	   	if( $vc_linkedin != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_pinterest ).'"><i class="fa fa-pinterest-p"></i></a></li>';
	   	}
	   	if( $vc_google_plus != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_google_plus ).'"><i class="fa fa-google-plus"></i></a></li>';
	   	}
	   	if( $vc_instagram != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_instagram ).'"><i class="fa fa-instagram"></i></a></li>';
	   	}
	   	if( $vc_rss != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_rss ).'"><i class="fa fa-rss"></i></a></li>';
	   	}	
	   	
	   	$html .='</ul>';

	   	wp_reset_postdata();

        return apply_filters('netbase_shortcode_social', force_balance_tags($html));
	}

}

new NB_Element_Social(); 
}