<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Product Tabs
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Product_Sliders extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'vc_printshop_product_sliders', array( $this, 'vc_printshop_product_sliders' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }

        $args = array(
            'type' => 'post',
            'child_of' => 0,
            'parent' => '',
            'orderby' => 'parent',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'number' => '',
            'taxonomy' => 'product_cat',
            'pad_counts' => false,
        );
        $categories = get_categories( $args );
        $product_categories_dropdown[] = array(
                'label' => 'All categories',
                'value' => '',
        );
        $this->getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
         
        vc_map( array(
            "name" => esc_html__( "Product Sliders", "nb-elements" ),
            "base" => "vc_printshop_product_sliders",
            "class" => "",
            "category" => esc_html__( "PrintCart", "nb-elements"),
            /*'admin_enqueue_js' => array(get_template_directory_uri().'/vc_extend/bartag.js'),*/

            "params" => array(

                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__( 'Product type', 'nb-elements' ),
                    'param_name'    => 'product_type',
                    'admin_label'   => true,
                    'value'         => array(
                            esc_html__('Recent', 'nb-elements')       => 'recent',
                            esc_html__('Featured', 'nb-elements') => 'featured',
                            esc_html__('Best Selling', 'nb-elements') => 'best_selling',
                            esc_html__('Top Rated', 'nb-elements')    => 'top_rated',
                            esc_html__('Mixed Order', 'nb-elements')  => 'mixed_order'
                            ),
                    'description'   => esc_html__( 'Select type of product', 'nb-elements' ),
                ),

                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__('Product Cat', 'nb-elements'),
                    'param_name'    => 'product_cat',
                    'value'         => $product_categories_dropdown,
                    'save_always'   => true,
                    'admin_label'   => true,
                ),
                array(
                    "type"          => "textfield",
                    "holder"        => "div",
                    "class"         => "",
                    "heading"       => esc_html__( "Limit", "nb-elements" ),
                    "param_name"    => "product_limit",
                    "value"         => 8,
                ),
                array(
                   "type"           => "dropdown",
                   "heading"        => esc_html__( "Column", "nb-elements" ),
                   "param_name"     => "product_col",
                   'std'            => 4,
                   'value'          => array(
                       esc_html__( '2', 'nb-elements' )       => 2,
                       esc_html__( '3', 'nb-elements' )       => 3,
                   ),
                ),
            )
        ));
    }     
     
    // Element HTML
    public function vc_printshop_product_sliders($atts, $content = null)
    {
        extract( shortcode_atts( array(
            
            'product_type'       => '',
            'product_cat'        => '',
            'product_limit'      => 8,
            'product_col'        => 2
        ), $atts ) );

        ob_start();

        ?>
        <div class="">
            <div class="vc-product-slider-wrapper swiper-container">
                <?php 

                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'product_cat' => $product_cat,
                    'posts_per_page' => $product_limit
                );

                $this->nb_filter_product_by_product_type($args, $product_type);

                $products = new WP_Query( $args );

                if ( $products->have_posts() ) :
                    echo '<div class="products swiper-wrapper" data-column="' . $product_col . '">';
                    while ( $products->have_posts() ) : $products->the_post();
                ?>
                    <div class="product swiper-slide">
                        <div class="product-item">
                            <div class="product-thumb">
                                <a href="<?php echo esc_url(get_permalink());?>">
                                    <?php echo woocommerce_get_product_thumbnail();?>
                                </a>
                            </div>
                            <div class="product-meta">
                                <h4 class="product-title"><a href="<?php echo esc_url(get_permalink());?>"><?php echo esc_html(get_the_title());?></a></h4>
                                <p class="product-cats">
                                    <?php 
                                        $terms = get_the_terms( get_the_ID(), 'product_cat' );
                                        echo wc_get_product_category_list( get_the_ID(), ', ', '<span class="posted_in meta-name">' . _n( 'Category:', 'Categories:', count( $terms ), 'nb-elements' ) . ' </span><span>', '</span>' ); 
                                    ?>
                                </p>

                                <?php do_action( 'woocommerce_after_shop_loop_item_title' );?>
                            </div>
                        </div>
                    </div>

                <?php 
                    endwhile;
                    echo '</div>';
                    echo '<div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>';
                endif;
                wp_reset_postdata();

                ?>
            </div>
        </div>


         <?php
         
        return ob_get_clean();
    }

    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {

        for ( $i = $pos; $i < count( $array ); $i ++ ) {

            if ( $array[ $i ]->category_parent == $parent_id ) {
                $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                $value = $array[ $i ]->slug;
                $dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
                $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
            }
        }
    }

    protected function nb_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;
            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'top_rated':
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }
    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Product_Sliders(); 
}
