<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Our_Team extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'netbase_our_team', array( $this, 'shortcode_our_team' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
        vc_map(array(
            'name' => esc_html__('Our Team', 'nb-elements'),
            'base' => 'netbase_our_team',
            'category' => esc_html__('PrintCart', 'nb-elements'),
            'description' => esc_html__('Display our team.', 'nb-elements'),
            'icon' => 'icon-wpb-wp',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'nb-elements'),
                    'param_name' => 'title',
                    'value' => '',
                ),
                array(
                    'heading'    => esc_html__( 'Our Team content', 'nb-elements' ),
                    'type'       => 'param_group',
                    'param_name' => 'our_team_content',
                    'params'     => array(
                        array(
                            'param_name' => 'avatar',
                            'heading'    => esc_html__( 'Avatar', 'nb-elements' ),
                            'type'       => 'attach_image',
                        ),
                        array(
                            'param_name' => 'description',
                            'heading'    => esc_html__( 'description', 'nb-elements' ),
                            'type'       => 'textarea',
                        ),
                        array(
                            'param_name' => 'name',
                            'heading'    => esc_html__( 'Name', 'nb-elements' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'job',
                            'heading'    => esc_html__( 'Job', 'nb-elements' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'facebook',
                            'heading'    => esc_html__( 'Facebook', 'nb-elements' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'twitter',
                            'heading'    => esc_html__( 'Twitter', 'nb-elements' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'google_plus',
                            'heading'    => esc_html__( 'Google plus', 'nb-elements' ),
                            'type'       => 'textfield',
                        ),
                    ),
                ),
                array(
                    'param_name' => 'avt_shape',
                    'heading'    => esc_html__( 'Avatar style', 'nb-elements' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Square', 'nb-elements' ) => 'square',
                        __( 'Circle', 'nb-elements' ) => 'circle',
                    ),
                    'std'        => 'circle',
                    'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                ),
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Style', 'nb-elements' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Style 1', 'nb-elements' ) => 'style-1',
                        __( 'Style 2', 'nb-elements' ) => 'style-2',
                    ),
                    'edit_field_class' => 'vc_col-sm-6 mgt15',
                ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-elements'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),        
                array(
                    'param_name' => 'pagination',
                    'heading'    => esc_html__( 'Enable Pagination', 'nb-elements' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ), 
                array(
                    'param_name' => 'dots_size',
                    'heading'    => esc_html__( 'Dots Size', 'nb-elements' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Big', 'nb-elements' ) => 'big',
                        __( 'Small', 'nb-elements' ) => 'small',
                    ),
                    'std'        => 'small',
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                    'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                ), 
                array(
                    'param_name' => 'autoplay',
                    'heading'    => esc_html__( 'Enable Auto Play', 'nb-elements' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ), 
                array(
                    'param_name' => 'loop',
                    'heading'    => esc_html__( 'Enable Loop', 'nb-elements' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ),         

                array(
                    'param_name'  => 'columns',
                    'heading'     => esc_html__( 'Number of columns displayed', 'nb-elements' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( '1 column', 'nb-elements' )  => '1',
                        __( '2 columns', 'nb-elements' ) => '2',
                        __( '3 columns', 'nb-elements' ) => '3',
                        __( '4 columns', 'nb-elements' ) => '4',
                        __( '5 columns', 'nb-elements' ) => '5',
                        __( '6 columns', 'nb-elements' ) => '6',
                        __( '7 columns', 'nb-elements' ) => '7',
                        __( '8 columns', 'nb-elements' ) => '8',
                    ),
                    'std'         => '3',
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                    'param_name'  => 'columnstablet',
                    'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-elements' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( 'Select columns', 'nb-elements' )  => '',
                        __( '1 column', 'nb-elements' )  => '1',
                        __( '2 columns', 'nb-elements' ) => '2',
                        __( '3 columns', 'nb-elements' ) => '3',
                        __( '4 columns', 'nb-elements' ) => '4',
                        __( '5 columns', 'nb-elements' ) => '5',
                        __( '6 columns', 'nb-elements' ) => '6',
                        __( '7 columns', 'nb-elements' ) => '7',
                        __( '8 columns', 'nb-elements' ) => '8',
                    ),                     
                    'std'         => '',   
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'    => __( 'Extra class name', 'nb-elements' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-elements' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-elements' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-elements' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_our_team($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'layout' => 'default',
                    'columns' => '3',                  
                    'columnstablet' =>'',  
                    'our_team_content'  => '',
                    'avatar'                => '',
                    'avt_shape'             => 'circle',
                    'description'           => '',
                    'name'                  => '',
                    'job'                   => '',
                    'facebook' =>'',
                    'twitter' => '',
                    'google_plus' => '',
                    'style'                 => 'style-1',
                    'slider'                => true,
                    'pagination'   => '',
                    'autoplay'     => '',
                    'loop'         => '', 
                    'dots_size' => 'small',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_our_team_');

        $classes = $attr = array();

        if ( ! empty( $slider ) ) {
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }
            if($autoplay){
                $attr[] = '"autoplay": "true"';
            }
            if($loop){
                $attr[] = '"loop": "true"';
            }
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }
            if($dots_size && $pagination){
                $classes[] =' dots-'.$dots_size.' ';
            }

            $classes[] = 'nb-fw-vccarousel owl-carousel owl-loaded owl-drag';
        }
        
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw our_team '. esc_attr( implode( ' ', $classes ) ) .'"  '.$data_owlcarousel.'>';
        
        $values = ( array ) vc_param_group_parse_atts( $our_team_content );

        foreach ( $values as $key => $values ) {

            // Get image link and image data
            if ( ! empty( $values[ 'avatar' ] ) ) {
                $img_id       = preg_replace( '/[^\d]/', '', $values[ 'avatar' ] );
                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
                $image_link   = $image[ 'p_img_large' ][ 0 ];
            }
            
            $html .= '<div class="profile-item text-center">';
                    $html .= '<div class="author mgt20">';
                    if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'nb-elements' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . '  />';
                        $html .= '</div>';
                    }
                        $html .= '<div class="ms-team-info">';
                        if ( ! empty( $values[ 'name' ] ) ) {
                            $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                        }

                        if ( ! empty( $values[ 'job' ] ) ) {
                            $html .= '<p class="job meta-color">' . esc_html( $values[ 'job' ] ) . '</p>';
                        }
                        $html .= '</div>';
                    $html .= '</div>';

                    $html .= '<div class="content">';
                        $html .= '<div>' . $values[ 'description' ] . '</div>';
                        if ( ! empty( $values[ 'facebook' ]) || ! empty( $values[ 'twitter' ]) || ! empty( $values[ 'google_plus' ] ) ) {
                        
                        $html .='<div class="ourteam-social-share">';
                            if ( ! empty( $values[ 'facebook' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'facebook' ] ) . '"><i class="fa fa-facebook"></i> </a>';
                            }
                            if ( ! empty( $values[ 'twitter' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'twitter' ] ) . '"><i class="fa fa-twitter"></i></a>';
                            }
                            if ( ! empty( $values[ 'google_plus' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'google_plus' ] ) . '"><i class="fa fa-google"></i> </a>';
                            }
                        $html .='</div>';
                        }
                    $html .= '</div>';
                    
                    
                    
            $html .= '</div>';
            
        }

        $html .= '</div>';

        
        

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_our_team', force_balance_tags($html));
    }

}
new NB_Element_Our_Team(); 
}