<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Heading
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Heading extends WPBakeryShortCode {
	// Element Init
    function __construct() {
        add_action( 'init', array( $this, 'add_vc_home7_aboutus' ), 12 );
        add_shortcode( 'vc_home7_heading', array( $this, 'vc_home7_heading' ) );
    }

     
    // Element Mapping

	public function add_vc_home7_aboutus() {

		if ( !defined( 'WPB_VC_VERSION' ) ) {
	        return;
	    }
        $defaul_body_font ='Lobster Two';
	    if(function_exists('printcart_get_options')){
            $get_body_font = explode(',', printcart_get_options('body_font_family'));

            if($get_body_font[0] === 'google') {
                $font_body_name = $get_body_font[1];
                /*$font_body_style_array = explode(",", printcart_get_options('body_font_style'));
                $font_body_weight = end($font_body_style_array);
                var_dump($font_body_style_array);*/

            }
            if(isset($font_body_name) ){
                $defaul_body_font = $font_body_name;
            }
            /*if(isset($font_body_weight)){
                $defaul_body_font_weight = $font_body_weight;
            }else{
                $defaul_body_font_weight = '400 regular:400:normal';
            }*/

        }

	   	vc_map( array(
	      	"name" => __( "Heading", "nb-elements" ),
	      	"base" => "vc_home7_heading",
	      	"class" => "",
	      	"category" => __( "PrintCart", "nb-elements"),


	     	"params" => array(
	     		array(
					"type" => "dropdown",
					"class" => "",
					'group'=>'Style heading',
					"heading" => __( "Style heading", "nb-elements" ),
					"param_name" => "vc_style_heading",
					"value" => array(
						__( "nb-heading-style1", "nb-elements" ) => 'Style1',
						__( "nb-heading-style2", "nb-elements" ) => 'Style2',
						__( "nb-heading-style3", "nb-elements" ) => 'Style3',
						__( "nb-heading-style4", "nb-elements" ) => 'Style4',
						__( "nb-heading-style5", "nb-elements" ) => 'Style5',
					), 
					"description" => __( "Style heading", "nb-elements" )
				),
				array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Style heading',
				    "heading" => __( "Color decoration primary", "nb-elements" ),
				    "param_name" => "vc_color_heading_decoration",
				    "value" => '#000', 
				    "dependency" => Array('element' => "vc_style_heading", 'value' => array('Style2','Style3')),
				    "description" => __( "Color decoration primary", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Style heading',
					"heading" => __( "Width decoration", "nb-elements" ),
					"param_name" => "vc_width_decoration_h",
					"value" => '0', 
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style2','Style3')),
					"description" => __( "Width decoration primary( Example: 15px or 15% )", "nb-elements" )
				),
				array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Style heading',
				    "heading" => __( "Color decoration caption", "nb-elements" ),
				    "param_name" => "vc_color_sub_heading_decoration",
				    "value" => '#000', 
				    "dependency" => Array('element' => "vc_style_heading", 'value' => array('Style3','Style5')),
				    "description" => __( "Color decoration caption", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Style heading',
					"heading" => __( "Width decoration caption", "nb-elements" ),
					"param_name" => "vc_width_decoration_sh1",
					"value" => '0', 
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style3','Style5')),
					"description" => __( "Width decoration caption ( Example: 15px or 15% )", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Style heading',
					"heading" => __( "Height decoration caption", "nb-elements" ),
					"param_name" => "vc_height_decoration_sh1",
					"value" => '0', 
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style3','Style5')),
					"description" => __( "Height decoration caption( Example: 15px or 15% )", "nb-elements" )
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					'group'=>'Style heading',
					"heading" => __( "Color decoration description", "nb-elements" ),
					"param_name" => "vc_color_sub_heading2_decoration",
					"value" => '', 
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style4')),
					"description" => __( "Color decoration description", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Style heading',
					"heading" => __( "Width decoration description", "nb-elements" ),
					"param_name" => "vc_width_decoration_sh2",
					"value" => '0', 
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style4')),
					"description" => __( "Width decoration description ( Example: 15px or 15% )", "nb-elements" )
				),
				array(
					"type" => "dropdown",
					'group'=>'Style heading',
					"heading" => __( "Text align", "nb-elements" ),
					"param_name" => "vc_text_align",
                    'std' => 'text-center',
					"value" => array(
						__( "Left", "nb-elements" ) => 'text-left', 
						__( "Center", "nb-elements" ) => 'text-center',
						__( "Right", "nb-elements" ) => 'text-right',
					), 
					"description" => __( "Text align", "nb-elements" )
				),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Primary', 'nb-elements'),
		            'param_name' => 'vc_heading',
		            'value' => '',
		            'group'=>'Primary',
		            'description' => __('Add text', 'nb-elements'),
		            'admin_label' => true,
		            "dependency" => Array('element' => "vc_style_heading", 'value' => array('Style1','Style2','Style3','Style4')),
		        ),

                array(
                    'type' => 'google_fonts',
                    'param_name' => 'text_font',
                    'group'=>'Primary',
                    'value' => '',
                    'settings' => array(
                        'fields' => array(
                            'font_family'=> $defaul_body_font,
                            'font_style'=>'400 regular:400:normal',
                            'font_family_description' => __( 'Select Font Family.', 'nb-elements' ),
                            'font_style_description' => __( 'Select Font Style.', 'nb-elements' ),
                        ),
                    ),
                    'weight' => 0,
                    "dependency" => Array('element' => "vc_style_heading", 'value' => array('Style1','Style2','Style3','Style4')),
                ),
                array(
					"type" => "dropdown",
					"class" => "",
					'group'=>'Primary',
					"heading" => __( "Primary tag", "nb-elements" ),
					"param_name" => "vc_heading_tag",
					"description" => __( "Choose tag primary", "nb-elements" ),
					"std"=>'h2',
					"value" => array(
						__( "H1", "nb-elements" ) => 'h1', 
						__( "H2", "nb-elements" ) => 'h2',
						__( "H3", "nb-elements" ) => 'h3',
						__( "H4", "nb-elements" ) => 'h4',
						__( "H5", "nb-elements" ) => 'h5',
						__( "H6", "nb-elements" ) => 'h6',
						__( "div", "nb-elements" ) => 'div',
					), 
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style1','Style2','Style3','Style4')),
				),
		        array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Primary',
					"heading" => __( "Font size primary", "nb-elements" ),
					"param_name" => "vc_size_heading",
					"value" => '', 
					"description" => __( "Add font size primary ( Example: 15px or 15% )", "nb-elements" ),
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style1','Style2','Style3','Style4')),
				),
		        array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Primary',
				    "heading" => __( "Color primary", "nb-elements" ),
				    "param_name" => "vc_color_heading",
				    "value" => '#000', 
				    "description" => __( "Color primary", "nb-elements" ),
				    "dependency" => Array('element' => "vc_style_heading", 'value' => array('Style1','Style2','Style3','Style4')),
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Primary',
					"heading" => __( "Margin bottom", "nb-elements" ),
					"param_name" => "vc_margin_heading",
					"value" => '', 
					"description" => __( "Margin bottom ( Example: 15px or 15% )", "nb-elements" ),
					"dependency" => Array('element' => "vc_style_heading", 'value' => array('Style1','Style2','Style3','Style4')),
				),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Caption', 'nb-elements'),
		            'group'=>'Caption',
		            'param_name' => 'vc_sub_heading1',
		            'value' => '',
		            'description' => __('Add caption', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Caption',
					"heading" => __( "Font size caption", "nb-elements" ),
					"param_name" => "vc_size_sub_heading1",
					"value" => '', 
					"description" => __( "Add font size caption ( Example: 15px or 15%  )", "nb-elements" )
				),
				array(
                    'type' => 'google_fonts',
                    'param_name' => 'text_font_sub',
                    'group'=>'Caption',
                    'settings' => array(
                        'fields' => array(
                            'font_family_description' => __( 'Select Font Family.', 'nb-elements' ),
                            'font_style_description' => __( 'Select Font Style.', 'nb-elements' ),
                        ),
                    ),
                    'weight' => 0,

                ),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Caption',
					"heading" => __( "Padding right caption", "nb-elements" ),
					"param_name" => "vc_padding_right_sub_heading1",
					"value" => '', 
					"description" => __( "Padding right caption( Example: 15px or 15% )", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Caption',
					"heading" => __( "Padding left caption", "nb-elements" ),
					"param_name" => "vc_padding_left_sub_heading1",
					"value" => '', 
					"description" => __( "Padding left caption ( Example: 15px or 15% )", "nb-elements" )
				),
		        array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Caption',
				    "heading" => __( "Color caption", "nb-elements" ),
				    "param_name" => "vc_color_sub_heading1",
				    "value" => '#000', 
				    "description" => __( "Color caption", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Caption',
					"heading" => __( "Margin bottom", "nb-elements" ),
					"param_name" => "vc_margin_sub_heading1",
					"value" => '', 
					"description" => __( "Margin bottom ( Example: 15px or 15%  )", "nb-elements" )
				),
		        array(
		            'type' => 'textarea',
		            'heading' => __('Description', 'nb-elements'),
		            'group'=>'Description',
		            'param_name' => 'vc_sub_heading2',
		            'value' => '',
		            'description' => __('Add description', 'nb-elements'),
		            'admin_label' => true,
		        ),
		        array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Description',
				    "heading" => __( "Color description", "nb-elements" ),
				    "param_name" => "vc_color_sub_heading2",
				    "value" => '#000', 
				    "description" => __( "Color description", "nb-elements" )
				),
				array(
				    "type" => "textfield",
				    "class" => "",
				    'group'=>'Description',
				    "heading" => __( "Padding right description", "nb-elements" ),
				    "param_name" => "vc_padding_right_sub_heading2",
				    "value" => '0', 
				    "description" => __( "Padding right description ( Example: 15px or 15% )", "nb-elements" )
				),
				array(
				    "type" => "textfield",
				    "class" => "",
				    'group'=>'Description',
				    "heading" => __( "Padding left description", "nb-elements" ),
				    "param_name" => "vc_padding_left_sub_heading2",
				    "value" => '0', 
				    "description" => __( "Padding left description ( Example: 15px or 15% )", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Description',
					"heading" => __( "Font size desciption", "nb-elements" ),
					"param_name" => "vc_size_sub_heading2",
					"value" => '', 
					"description" => __( "Font size description ( Example: 15px or 15%  )", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Description',
					"heading" => __( "Margin bottom", "nb-elements" ),
					"param_name" => "vc_margin_sub_heading2",
					"value" => '', 
					"description" => __( "Margin bottom ( Example: 15px or 15%  )", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Button',
					"heading" => __( "Button", "nb-elements" ),
					"param_name" => "vc_text_button",
					"value" => '', 
					"description" => __( "Add text button", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Button',
					"heading" => __( "Font size text button", "nb-elements" ),
					"param_name" => "vc_size_text_button",
					"value" => '', 
					"description" => __( "Font size button ( Example: 15px or 15%  )", "nb-elements" )
				),
				array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Button',
				    "heading" => __( "Color button", "nb-elements" ),
				    "param_name" => "vc_color_button",
				    "value" => '#000', 
				    "description" => __( "Color button", "nb-elements" )
				),
				array(
				    "type" => "colorpicker",
				    "class" => "",
				    'group'=>'Button',
				    "heading" => __( "Color text button", "nb-elements" ),
				    "param_name" => "vc_color_text_button",
				    "value" => '#000', 
				    "description" => __( "Color text button", "nb-elements" )
				),
				array(
				    "type" => "vc_link",
				    "class" => "",
				    'group'=>'Button',
				    "heading" => __( "Link button", "nb-elements" ),
				    "param_name" => "vc_link",
				    "value" => '#000', 
				    "description" => __( "Link button", "nb-elements" )
				),
				array(
					"type" => "dropdown",
					"class" => "",
					'group'=>'Button',
					"heading" => __( "Style button", "nb-elements" ),
					"param_name" => "vc_style_button",
					"value" => array(
						__( "none", "nb-elements" ) => 'none', 
						__( "half-but", "nb-elements" ) => 'half-but',
					), 
					"description" => __( "Style button", "nb-elements" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Button',
					"heading" => __( "Padding left button", "nb-elements" ),
					"param_name" => "vc_padding_left_button",
					"value" => '0',
					"description" => __( "Padding left button ( Example: 15px or 15% )", "nb-elements" )
				),
	      	)
	   	));
	}


	public function vc_home7_heading($atts, $content = null){
		$html = $class = $txtheading = $txtsub1= $txtsub2 = $txtbutton = $decoration_h = $decoration_sub1 = $decoration_sub2 = $stylebutton = $tag_heading = $pad_but = '';
	   extract( shortcode_atts( array(
	      	'vc_heading'=>'',
	      	'vc_size_heading'=>'',
	      	'vc_color_heading'=>'#000',
	      	'vc_margin_heading'=>'10',
	      	'vc_color_heading_decoration'=>'#000',

	      	'vc_sub_heading1'=>'',
	      	'vc_size_sub_heading1'=>'',
	      	'vc_color_sub_heading1'=>'#000',
	      	'vc_margin_sub_heading1'=>'30',
	      	'vc_padding_right_sub_heading1'=>'',
	      	'vc_padding_left_sub_heading1'=>'',
	      	'vc_color_sub_heading_decoration'=>'#000',

	      	'vc_sub_heading2'=>'',
	      	'vc_size_sub_heading2'=>'',
	      	'vc_color_sub_heading2'=>'#000',
	      	'vc_padding_right_sub_heading2'=>'',
	      	'vc_padding_left_sub_heading2'=>'',
	      	'vc_margin_sub_heading2'=>'20',
	      	'vc_color_sub_heading2_decoration'=>'#000',
	      	'vc_style_heading'=>'Style1',
	      	'vc_text_button'=>'',
	      	'vc_size_text_button'=>'',
	      	'vc_color_button'=>'#000',
	      	'vc_color_text_button'=>'#000',
	      	'vc_link'=>'',
	      	'vc_style_button'=>'none',
	      	'vc_padding_left_button'=>'',
	      	'vc_heading_tag'=>'h2',
	      	'vc_text_align'=>'text-center',
            'text_font' => '',
            'text_font_sub'=>'',
            'vc_width_decoration_h' => '',
            'vc_width_decoration_sh1' => '',
            'vc_width_decoration_sh2' => '',
            'vc_positionl_decoration_h' => '',
            'vc_height_decoration_sh1' => '',

	   	), $atts ) );

        //******************//
        // MANAGE FONT DATA //
        //******************//

        // Build the data array
        $text_font_data = $this->getFontsData( $text_font );
        $text_font_sub_data = $this->getFontsData( $text_font_sub );

        // Build the inline style
        $text_font_inline_style = $this->googleFontsStyles( $text_font_data );
        $text_font_sub_inline_style = $this->googleFontsStyles( $text_font_sub_data );

        // Enqueue the right font
        $this->enqueueGoogleFonts( $text_font_data );
        $this->enqueueGoogleFonts( $text_font_sub_data );

        if(isset($text_font_inline_style) && $text_font_inline_style !=''){
            $txtheading = $text_font_inline_style;
        }

        if(isset($text_font_sub_inline_style) && $text_font_sub_inline_style !=''){
            $txtsub1 = $text_font_sub_inline_style;
        }

	   	if($vc_style_heading!=''){
	   		$class = $vc_style_heading ;
	   	}

	   	//heading
   		if($vc_heading_tag){
   			$tag_heading = $vc_heading_tag;
   		}
	   	if($vc_margin_heading !=''){
            $txtheading .= 'margin-bottom:' . ( is_numeric( trim( $vc_margin_heading ) ) ? trim( $vc_margin_heading ) . 'px' : trim( $vc_margin_heading ) ).';' ;
        }
        if ( $vc_size_heading != '' ) {
            $txtheading .= 'font-size:' . ( is_numeric( trim( $vc_size_heading ) ) ? trim( $vc_size_heading ) . 'px' : trim( $vc_size_heading ) ).';' ;
        }
        if($vc_color_heading){
            $txtheading .='color: ' . esc_attr( $vc_color_heading ).';' ;
        }
        if ( $txtheading ) {
            $txtheading = ' style="' . $txtheading . '"';
        }
        if($vc_color_heading_decoration!=''){
        	$decoration_h .= 'background:'.esc_attr($vc_color_heading_decoration).';';
        }
        if($vc_width_decoration_h){
            $decoration_h .='width: ' . esc_attr( $vc_width_decoration_h ).';' ;
        }
        if($decoration_h){
        	$decoration_h ='style="'.$decoration_h.'"';
        }

        //sub heading 1
        if ( $vc_size_sub_heading1 != '' ) {
            $txtsub1 .= 'font-size:' . ( is_numeric( trim( $vc_size_sub_heading1 ) ) ? trim( $vc_size_sub_heading1 ) . 'px' : trim( $vc_size_sub_heading1 ) ).';' ;
        }
        if($vc_margin_sub_heading1 !=''){
            $txtsub1 .= 'margin-bottom:' . ( is_numeric( trim( $vc_margin_sub_heading1 ) ) ? trim( $vc_margin_sub_heading1 ) . 'px' : trim( $vc_margin_sub_heading1 ) ).';' ;
        }
        if($vc_padding_right_sub_heading1 !=''){
            $txtsub1 .= 'padding-right:' . ( is_numeric( trim( $vc_padding_right_sub_heading1 ) ) ? trim( $vc_padding_right_sub_heading1 ) . 'px' : trim( $vc_padding_right_sub_heading1 ) ).';' ;
        }
        if($vc_padding_left_sub_heading1 !=''){
            $txtsub1 .= 'padding-left:' . ( is_numeric( trim( $vc_padding_left_sub_heading1 ) ) ? trim( $vc_padding_left_sub_heading1 ) . 'px' : trim( $vc_padding_left_sub_heading1 ) ).';' ;
        }
        if($vc_color_sub_heading1){
            $txtsub1 .='color: ' . esc_attr( $vc_color_sub_heading1 ).';' ;
        }
        if ( $txtsub1 ) {
            $txtsub1 = ' style="' . $txtsub1 . '"';
        }
        if($vc_width_decoration_sh1){
            $decoration_sub1 .='width: ' . esc_attr( $vc_width_decoration_sh1 ).';' ;
        }
        if($vc_width_decoration_sh1){
            $decoration_sub1 .='height: ' . esc_attr( $vc_height_decoration_sh1 ).';' ;
        }
        if($vc_color_sub_heading_decoration!=''){
        	$decoration_sub1 .= 'background:'.esc_attr($vc_color_sub_heading_decoration).';';
        }
        if($decoration_sub1){
        	$decoration_sub1 ='style="'.$decoration_sub1.'"';
        }

         //sub heading 2
        if ( $vc_size_sub_heading2 != '' ) {
            $txtsub2 .= 'font-size:' . ( is_numeric( trim( $vc_size_sub_heading2 ) ) ? trim( $vc_size_sub_heading2 ) . 'px' : trim( $vc_size_sub_heading2 ) ).';' ;
        }
        if($vc_margin_sub_heading2 !=''){
            $txtsub2 .= 'margin-bottom:' . ( is_numeric( trim( $vc_margin_sub_heading2 ) ) ? trim( $vc_margin_sub_heading2 ) . 'px' : trim( $vc_margin_sub_heading2 ) ).';' ;
        }
        if($vc_padding_right_sub_heading2 !=''){
            $txtsub2 .= 'padding-right:' . ( is_numeric( trim( $vc_padding_right_sub_heading2 ) ) ? trim( $vc_padding_right_sub_heading2 ) . 'px' : trim( $vc_padding_right_sub_heading2 ) ).';' ;
        }
        if($vc_padding_left_sub_heading2 !=''){
            $txtsub2 .= 'padding-left:' . ( is_numeric( trim( $vc_padding_left_sub_heading2 ) ) ? trim( $vc_padding_left_sub_heading2 ) . 'px' : trim( $vc_padding_left_sub_heading2 ) ).';' ;
        }
        if($vc_color_sub_heading2){
            $txtsub2 .='color: ' . esc_attr( $vc_color_sub_heading2 ).';' ;
        }
        if ( $txtsub2 ) {
            $txtsub2 = ' style="' . $txtsub2 . '"';
        }
        if($vc_color_sub_heading2_decoration!=''){
        	$decoration_sub2 .= 'background:'.esc_attr($vc_color_sub_heading2_decoration).';';
        }
        if($vc_width_decoration_sh2){
            $decoration_sub2 .='width: ' . esc_attr( $vc_width_decoration_sh2 ).';' ;
        }
        if($decoration_sub2){
        	$decoration_sub2 ='style="'.$decoration_sub2.'"';
        }

        //button
        if ( $vc_size_text_button != '' ) {
            $txtbutton .= 'font-size:' . ( is_numeric( trim( $vc_size_text_button ) ) ? trim( $vc_size_text_button ) . 'px' : trim( $vc_size_text_button ) ).';' ;
        }
        if($vc_padding_left_button !=''){
            $pad_but .= 'padding-left:' . ( is_numeric( trim( $vc_padding_left_button ) ) ? trim( $vc_padding_left_button ) . 'px' : trim( $vc_padding_left_button ) ).';' ;
        }
        if($vc_color_text_button){
            $txtbutton .='color: ' . esc_attr( $vc_color_text_button ).';' ;
        }
        if ( $txtbutton ) {
            $txtbutton = ' style="' . $txtbutton . '"';
        }
        if($vc_color_button){
            $stylebutton .='background: ' . esc_attr( $vc_color_button ).';' ;
        }
        if ( $stylebutton ) {
            $stylebutton = ' style="' . $stylebutton . '"';
        }
        if ( $pad_but ) {
            $pad_but = ' style="' . $pad_but . '"';
        }
        
		$href = vc_build_link( $vc_link );
		$link='';
		if($vc_link!=''){
			$link .= $href['url'];
		}else{
			$link .= "#";
		}

		if($link){
			$link ='href="'.$link.'"';
		}
			$html .='<div class="vc-headline '.esc_html($class).' '.esc_html($vc_text_align).'">';
			if($vc_heading!=''){
				$html .='<div class="vc-heading">';
				$html .='<'.esc_attr($tag_heading).' class="vc-cap" '.$txtheading.'>'.esc_attr($vc_heading);
				if($vc_style_heading == 'Style2' || $vc_style_heading == 'Style3'){
					$html .='<span '.$decoration_h.'></span>';
				}
				$html .='</'.esc_attr($tag_heading).'>';
				$html .='</div>';
			}
			if($vc_sub_heading1!=''){
				$html .='<div class="vc-sub-heading1">';
				$html .='<div'.$txtsub1.'>'.esc_attr($vc_sub_heading1);
				if($vc_style_heading=='Style3' || $vc_style_heading=='Style5'){
					$html .='<span '.$decoration_sub1.'></span>';
				}
				$html .='</div>';
				$html .='</div>';
			}
			if($vc_sub_heading2!=''){
				$html .='<div class="vc-sub-heading2">';
				$html .='<div'.$txtsub2.'>'.esc_attr($vc_sub_heading2);
				if($vc_style_heading=='Style4'){
					$html .='<span '.$decoration_sub2.'></span>';
				}
				$html .='</div>';
				$html .='</div>';
			}
			if($vc_text_button!=''){
				$html .='<div class="vc_text_button '.esc_html($vc_style_button).'" '.$pad_but.'>';
				$html .='<div class="cv-btn">';
				$html .='<a '.$link.' '.$txtbutton.'>'.esc_attr($vc_text_button).'<span '.$stylebutton.'></span></a>';
				$html .='</div>';
				$html .='</div>';
			}
			$html .='</div>';
		//return ob_get_clean();

		wp_reset_postdata();

        return apply_filters('netbase_shortcode_heading', force_balance_tags($html));
	}

    //********************************//
    // GOOGLE FONTS PRIVATE FUNCTIONS //
    //********************************//

    // Build the string of values in an Array
        protected function getFontsData( $fontsString ) {

            // Font data Extraction
            $googleFontsParam = new Vc_Google_Fonts();
            $fieldSettings = array();
            $fontsData = strlen( $fontsString ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $fontsString ) : '';
            return $fontsData;

        }

    // Build the inline style starting from the data
        protected function googleFontsStyles( $fontsData ) {
            $styles = array();
            // Inline styles
            if(isset($fontsData['values'])){
                $fontFamily = explode( ':', $fontsData['values']['font_family'] );
                $styles[] = 'font-family:' . $fontFamily[0];
                $fontStyles = explode( ':', $fontsData['values']['font_style'] );
                $styles[] = 'font-weight:' . $fontStyles[1];
                $styles[] = 'font-style:' . $fontStyles[2];
            }


            $inline_style = '';
            foreach( $styles as $attribute ){
                $inline_style .= $attribute.'; ';
            }

            return $inline_style;

        }

    // Enqueue right google font from Googleapis
        protected function enqueueGoogleFonts( $fontsData ) {

            // Get extra subsets for settings (latin/cyrillic/etc)
            $settings = get_option( 'wpb_js_google_fonts_subsets' );
            if ( is_array( $settings ) && ! empty( $settings ) ) {
                $subsets = '&subset=' . implode( ',', $settings );
            } else {
                $subsets = '';
            }

            // We also need to enqueue font from googleapis
            if ( isset( $fontsData['values']['font_family'] ) ) {
                wp_enqueue_style(
                    'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ),
                    '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets
                );
            }

        }
}

new NB_Element_Heading(); 
}