<?php
class NBT_Ajax_Search_Shortcode {

	/**
	* @ since 01-01-2018
	**/
	function __construct() {
		add_shortcode( 'nbt_ajax_search', array($this, 'shortcode_ajax_search'), 10, 1 );

		add_action( 'nbt_ajax_search_html', array($this, 'nbt_ajax_search_html'), 10, 1 );
	}

	public function shortcode_ajax_search($args = array()) {
		$args = apply_filters( 'nbt_ajax_search_args', array(
			'form_action' => home_url(),
			'form_class' => 'form-search',
			'form_id' => 'nbt-ajax-search',
			'input_class' => 'nbt-input-search'
		), $args );

		$form_attr = array();
		$form_attr[] = isset($args['form_id']) && !empty($args['form_id']) ? 'id="' . esc_html($args['form_id']) .'"' : "";
		$form_attr[] = isset($args['form_class']) && !empty($args['form_class']) ? 'class="' . esc_html($args['form_class']) .'"' : "";
		$form_attr[] = isset($args['form_action']) && !empty($args['form_action']) ? 'action="' . esc_html($args['form_action']) .'"' : "";
		$form_attr = array_filter($form_attr);
		?>
		<form <?php echo implode(' ', $form_attr);?> method="GET">
			<?php do_action( 'nbt_ajax_search_html', $args);?>
		</form>
		<?php

		if ( ! defined( 'PREFIX_NBT_SOLS' ) ) {
			wp_enqueue_script('nbt-ajax-search');
		}
	}

	public function nbt_ajax_search_html($args) {
		global $product, $post;
		?>
		<div class="field searchbox">
			<div class="control">
				<div class="input-content">
					<input type="text" name="s" class="input-searchbox <?php echo esc_attr($args['input_class']);?>" placeholder="<?php esc_attr_e('Enter keywords to search...', 'nb-elements');?>" maxlength="128" role="combobox" aria-haspopup="false" aria-autocomplete="both" autocomplete="off" aria-expanded="false" value="<?php echo isset($_GET['s']) ? $_GET['s'] : '' ?>">
				</div>
				<div class="select-cat">
					<?php $args = array(
						'show_option_all'    => __('All Categories', 'nb-elements'),
						'show_option_none'   => '',
						'option_none_value'  => '-1',
						'orderby'            => 'ID',
						'order'              => 'ASC',
						'show_count'         => 0,
						'hide_empty'         => 1,
						'child_of'           => 0,
						'exclude'            => '',
						'include'            => '',
						'echo'               => 1,
						'selected'           => isset($_GET['term']) ? $_GET['term'] : 0,
						'hierarchical'       => 0,
						'name'               => 'term',
						'id'                 => '',
						'class'              => 'cat searchbox-cat',
						'depth'              => 0,
						'tab_index'          => 0,
						'taxonomy'           => 'product_cat',
						'hide_if_empty'      => false,
						'value_field'        => 'slug',
					);
					wp_dropdown_categories( $args );?>
				</div>

				<div id="searchbox_autocomplete" class="rs-search rs-search-autocomplete nbt-results"></div>              

				</div>
			</div>
			<div class="actions">
				<button type="submit" title="Search" class="button btn-searchbox"><i class="pt-icon-search"></i></button>
				<input type="hidden" name="post_type" value="product" />
                <input type="hidden" name="taxonomy" value="product_cat" />
			</div>
			<?php
		}

		public function shortcode_assets() {
			wp_register_script( 'nbt-ajax-search', AJAX_SEARCH_URL . 'assets/js/frontend.js' );

		// Localize the script with new data
		// if( file_exists(AJAX_SEARCH_PATH .'inc/localize_script.php') ) {
		// 	$localize_content = include AJAX_SEARCH_PATH .'inc/localize.php';
		// 	wp_localize_script( 'nbt-ajax-search', 'nbtsearch', $localize_content );
		// }

		}
	}

	new NBT_Ajax_Search_Shortcode();