<?php
class NBT_AjaxSearch_Frontend{
	protected $args;
	
	function __construct() {
		
		add_action('wp_enqueue_scripts', array($this, 'embed_style'));

		add_action( 'wp_ajax_nopriv_nbt_search_now', array($this, 'nbt_search_now') );
		add_action( 'wp_ajax_nbt_search_now', array($this, 'nbt_search_now') );




		include PC_AJAX_SEARCH_PATH .'/inc/shortcode.php';
		add_filter( 'nbt_ajax_search_args', array($this, 'nbt_ajax_search_args'), 10, 1 );

		
	}

	public function nbt_ajax_search_args($args){
		$args['form_class'] = 'form minisearch';
		return $args;
	}

	public function nbt_search_now(){
		global $wpdb, $post;
		$search 	= esc_attr($_REQUEST['search']);
		$slug 		= esc_attr($_REQUEST['cat']);
		$cat_obj 	= get_term_by('slug', $slug, 'product_cat');
		$cat_id 	= is_object($cat_obj) ? $cat_obj->term_id : 0;
		
		if($search){
			if($cat_id > 0) {
				$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->posts . " p INNER JOIN ". $wpdb->term_relationships ." t ON p.ID = t.object_id WHERE p.post_type = 'product' AND p.post_status = 'publish' AND p.post_parent = 0 AND (post_title LIKE %s) AND t.term_taxonomy_id = '%d'", '%'.$wpdb->esc_like($search).'%', $cat_id), OBJECT );
			}else{
				$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->posts . " p WHERE p.post_type = 'product' AND p.post_status = 'publish' AND p.post_parent = 0 AND (post_title LIKE %s)", '%'.$wpdb->esc_like($search).'%'), OBJECT );
			}
			
			if($results){
				$json['result'] = '<ul class="nbt-rs-lists">';
				foreach ($results as $key => $post) {
					$product = wc_get_product($post->ID);
					ob_start();
					?>
			        <li>
			        	<a href="<?php echo esc_url( get_permalink($post->ID) );?>">
							<?php echo $product->get_image( array( 70, 70 ) );?>

							<div class="rs-search-info">
								<h4><?php echo esc_attr($post->post_title);?></h4>
								<?php
								if ( 'no' !== get_option( 'woocommerce_enable_review_rating' ) ):

									$rating_count = $product->get_rating_count();
									$review_count = $product->get_review_count();
									$average      = $product->get_average_rating();

									if ( $rating_count > 0 ) : ?>

										<div class="woocommerce-product-rating">
											<?php echo wc_get_rating_html( $average, $rating_count ); ?>
										</div>

									<?php else: ?>
										<div class="woocommerce-product-rating wc-zero-rating">
											<?php
											$html  = '<div class="star-rating">';
											$html .= wc_get_star_rating_html( $rating, $count );
											$html .= '</div>';
											echo $html;
											?>
										</div>
									<?php endif; ?>

								<?php endif; ?>
								
								<p class="price"><?php echo $product->get_price_html(); ?></p>
							</div>

			        	</a>
			        </li>
					<?php
					$json['result'] .= ob_get_clean();
				}
				$json['result'] .= '</ul>';
			}else{
				$json['result'] = '<p class="nbt-no-result">'.__('No results.', 'nb-elements').'</p>';
			}
			$json['complete'] = true;
			

		}
		echo wp_json_encode($json, TRUE);
		wp_die();
	}

	function embed_style(){
		if( !defined('PREFIX_NBT_SOL') ){
			wp_enqueue_style( 'nbt-fonts-frontend', PC_AJAX_SEARCH_URL .'/assets/css/nbt-fonts.css', array(), '20160615' );
		}
		

		wp_enqueue_style( 'jquery.mCustomScrollbar', PC_AJAX_SEARCH_URL . '/assets/css/jquery.mCustomScrollbar.min.css',false,'1.1','all');
		wp_enqueue_style( 'ajax_search-frontends', PC_AJAX_SEARCH_URL . '/assets/css/frontend.css',false, false,'all');



		wp_enqueue_script( 'jquery.mCustomScrollbar', PC_AJAX_SEARCH_URL . '/assets/js/jquery.mCustomScrollbar.min.js', null, null, true );

			wp_enqueue_script( 'ajaxsearch', PC_AJAX_SEARCH_URL . '/assets/js/frontend.js', null, null, true );


	}
}
new NBT_AjaxSearch_Frontend();