<?php
/**
 * nb_foody functions and definitions
 *
 * @package Netbase
 */

/**
 * Define theme constants
 */
 
 if( !function_exists('nbfoody_default_options') ){
	function nbfoody_default_options()
	{
		return array(
			'nbcore_blog_archive_layout' => 'classic',
			'nbcore_blog_sidebar' => 'right-sidebar',
			'nbcore_excerpt_only' => false,
			'nbcore_excerpt_length' => '35',
			'nbcore_blog_single_sidebar' => 'right-sidebar',
			'nbcore_color_scheme' => 'scheme_1',
			'nbcore_primary_color' => '#dc3725',
			'nbcore_secondary_color' => '#bf3b3b',
			'nbcore_tertiary_color' => 'rgba(220, 55, 37, 0.3)',
			'nbcore_background_color' => '#ffffff',
			'nbcore_inner_background' => '#edf0f5',
			'nbcore_heading_color' => '#222222',
			'nbcore_body_color' => '#666666',
			'nbcore_meta_color' => '#999999',
			'nbcore_link_color' => '#000000',
			'nbcore_link_hover_color' => '#dc3725',
			'nbcore_divider_color' => '#d7d7d7',
			'nbcore_header_style' => 'left-inline',
			'nbcore_logo_upload' => '',
			'nbcore_logo_width' => '150',
			'nbcore_menu_resp' => '992',
			'nbcore_header_fixed' => false,
			'nbcore_blog_width' => '70',
			'nbcore_blog_meta_date' => true,
			'nbcore_blog_meta_read_time' => true,
			'nbcore_blog_meta_author' => true,
			'nbcore_blog_meta_category' => true,
			'nbcore_blog_meta_tag' => true,
			'nbcore_blog_sticky_sidebar' => false,
			'nbcore_blog_meta_align' => 'center',
			'show_title_section' => true,
			'nbcore_page_title_image' => '',
			'nbcore_page_title_image_size' => 'auto',
			'nbcore_page_title_image_pos' => 'center',
			'nbcore_page_title_image_repeat' => 'repeat',
			'nbcore_page_title_image_attachment' => 'scroll',
			'nbcore_page_title_padding' => '75',
			'nbcore_page_title_color' => '#323232',
			'body_font_family' => 'google,Oswald',
			'body_font_style' => '400',
			'body_font_size' => '14',
			'heading_font_family' => 'google,Oswald',
			'heading_font_style' => '400',
			'heading_base_size' => '14',
			'subset_cyrillic' => false,
			'subset_greek' => false,
			'subset_vietnamese' => false,
			'nbcore_product_addtocart' => true,
			'nbcore_wc_breadcrumb' => true,
			'nbcore_wc_content_width' => '70',
			'nbcore_pa_swatch_style' => '',
			'nbcore_wc_attr' => false,
			'nbcore_shop_title' => esc_html__('Shop', 'nb-foody'),
			'nbcore_shop_action' => true,
			'nbcore_shop_sidebar' => 'right-sidebar',
			'nbcore_loop_columns' => 'two-columns',
			'nbcore_loop_columns_xl' => '2',
            'nbcore_loop_columns_lg' => '2',
            'nbcore_loop_columns_md' => '1',
            'nbcore_loop_columns_sm' => '1',
			'nbcore_products_per_page' => '12',
			'nbcore_product_list' => 'menu2',
			'nbcore_shop_content_width' => '70',
			'nbcore_grid_product_description' => true,
            'nbcore_grid_product_description_limit'=>'15',
			'nbcore_pd_details_title' => true,
			'nbcore_pd_details_width' => '70',
			'nbcore_pd_details_sidebar' => 'right-sidebar',
			'nbcore_wc_sale' => 'style-1',
			'nbcore_pd_images_width' => '50',
			'nbcore_pd_thumb_pos' => 'bottom-thumb',
			'nbcore_pd_meta_layout' => 'left-images',
			'nbcore_pd_featured_autoplay' => false,
			'nbcore_info_style' => 'accordion-tabs',
			'nbcore_reviews_form' => 'full-width',
			'nbcore_reviews_round_avatar' => true,
			'nbcore_add_cart_style' => 'style-1',
			'nbcore_pd_show_social' => true,
			'nbcore_show_related' => true,
			'nbcore_pd_related_columns' => '3',
			'nbcore_show_upsells' => false,
			'nbcore_pd_upsells_columns' => '3',
			'nbcore_pb_background' => '#dc3725',
			'nbcore_pb_background_hover' => '#bf3b3b',
			'nbcore_pb_text' => '#ffffff',
			'nbcore_pb_text_hover' => '#ffffff',
			'nbcore_pb_border' => '#dc3725',
			'nbcore_pb_border_hover' => '#bf3b3b',
			'nbcore_sb_background' => 'transparent',
			'nbcore_sb_background_hover' => '#dc3725',
			'nbcore_sb_text' => '#dc3725',
			'nbcore_sb_text_hover' => '#ffffff',
			'nbcore_sb_border' => '#dc3725',
			'nbcore_sb_border_hover' => '#dc3725',
			'nbcore_tb_background' => 'rgba(255, 255, 255, 0.85)',
            'nbcore_tb_background_hover' => 'rgba(220, 55, 37, 0.85)',
            'nbcore_tb_text' => '#444444',
            'nbcore_tb_text_hover' => '#ffffff',
            'nbcore_tb_border' => 'rgba(255, 255, 255, 0.85)',
            'nbcore_tb_border_hover' => 'rgba(220, 55, 37, 0.85)',
			'nbcore_button_padding' => '30',
			'nbcore_button_border_radius' => '0',
			'nbcore_button_border_width' => '2',
			'nbcore_cart_layout' => 'cart-layout-2',
			'nbcore_show_cross_sells' => true,
			'nbcore_cross_sells_per_row' => '4',
			'nbcore_cross_sells_limit' => '6',
			'home_page_title_section' => false,
			'nbcore_footer_bg_color' => 'rgba(0, 0, 0, 0.75)',
			'nbcore_footer_bg_img' => '',
			'nbcore_footer_bg_size' => 'auto',
			'nbcore_footer_bg_pos' => 'center',
			'nbcore_footer_bg_repeat' => 'repeat',
			'nbcore_footer_bg_attachment' => 'fixed',
			'nbcore_show_footer_top' => false,
			'nbcore_footer_top_layout' => 'layout-9',
			'nbcore_footer_top_color' => '#b5b5b5',
			'nbcore_footer_top_hover_color' => '#dc3725',
			'nbcore_footer_top_bg' => 'rgba(0, 0, 0, 0)',
			'nbcore_footer_top_bor' => '#999999',
			'nbcore_show_footer_bot' => false,
			'nbcore_footer_bot_layout' => 'layout-9',
			'nbcore_footer_bot_color' => '#b5b5b5',
			'nbcore_footer_bot_hover_color' => '#dc3725',
			'nbcore_footer_bot_bg' => 'rgba(0, 0, 0, 0)',
			'nbcore_footer_bot_bor' => '#333333',
			'nbcore_footer_abs_color' => '#b5b5b5',
			'nbcore_footer_abs_hover_color' => '#dc3725',
			'nbcore_footer_abs_bg' => 'rgba(0, 0, 0, 0)',
			'nbcore_footer_abs_bor' => '#555555',
            'nbcore_footer_abs_padding' => '10',
			'nbcore_top_section_padding' => '10',
			'nbcore_middle_section_padding' => '0',
			'nbcore_bot_section_padding' => '30',
			'nbcore_header_top_bg' => '#37383c',
			'nbcore_header_top_color' => '#999999',
			'nbcore_header_top_hover_color' => '#dc3725',
			'nbcore_header_middle_bg' => 'rgba(0, 0, 0, 0)',
			'nbcore_header_middle_color' => '#37383c',
			'nbcore_header_middle_hover_color' => '#dc3725',
			'nbcore_header_bot_bg' => 'rgba(0, 0, 0, 0)',
			'nbcore_header_bot_color' => '#646464',
			'nbcore_header_bot_hover_color' => '#dc3725',
			'nbcore_footer_top_heading' => '#ffffff',
			'nbcore_footer_bot_heading' => '#ffffff',
			'nbcore_blog_archive_comments' => true,
			'nbcore_blog_archive_summary' => true,
			'nbcore_blog_archive_post_style' => 'style-1',
			'nbcore_blog_single_title_position' => 'position-1',
			'nbcore_blog_single_show_thumb' => true,
			'nbcore_blog_single_title_size' => '50',
			'nbcore_blog_single_show_social' => true,
			'nbcore_blog_single_show_author' => true,
			'nbcore_blog_single_show_nav' => true,
			'nbcore_blog_single_show_comments' => true,
			'nbcore_page_title_size' => '50',
			'share_buttons_style' => 'style-1',
			'share_buttons_position' => 'inside-content',
			'pagination_style' => 'pagination-style-1',
			'show_back_top' => true,
			'back_top_shape' => 'circle',
			'back_top_style' => 'light',
			'shop_sticky_sidebar' => false,
			'product_sticky_sidebar' => false,
			//meta
			'page_thumb' => 'no-thumb',
			'page_sidebar' => 'full-width',
			'page_content_width' => '70',
			'nbcore_blog_masonry_columns' => '2',
			'product_category_wishlist' => true,
            'product_category_quickview' => true,
            'nbcore_storelist_loop_columns_xl' => '3',
            'nbcore_storelist_loop_columns_lg' => '3',
            'nbcore_storelist_loop_columns_md' => '2',
            'nbcore_storelist_loop_columns_sm' => '2',
            'nbcore_vendors_per_page' => '9',
            'nbcore_vendors_list' => 'style-2',
            'nbcore_vendor_details_sidebar' => 'left-sidebar',
            'nbcore_vendor_details_width' => '75',
            'nbcore_vendor_sticky_sidebar' => false,
            'nbcore_vendor_loop_columns_xl' => '3',
            'nbcore_vendor_loop_columns_lg' => '3',
            'nbcore_vendor_loop_columns_md' => '2',
            'nbcore_vendor_loop_columns_sm' => '2',
			'nbcore_vendor_per_page' => '9',
			'nbcore_vendor_map_height' => '200',
			'nbcore_mp_loop_columns_xl' => '4',
			'nbcore_mp_loop_columns_lg' => '4',
			'nbcore_mp_loop_columns_md' => '3',
			'nbcore_mp_loop_columns_sm' => '2',
            'nbcore_dashboard_sidebar' => 'left-sidebar',
            'nbcore_dashboard_width' => '75',
            'nbcore_dashboard_style' => false,
            'nbcore_reviews_style' => 'default',
            'nbcore_header_mainmn_bg'=>'',
            'nbcore_header_mainmn_color'=>'',
            'nbcore_header_mainmn_bor'=>'',
            'nbcore_header_mainmnhover_bg'=>'',
            'nbcore_header_mainmnhover_color'=>'',
            'nbcore_header_mainmnhover_bor'=>'',
            //'nbcore_footer_bg_color'=>'',
            'nbcore_header_text_section'=>'',
            'nbcore_header_facebook'=>'',
            'nbcore_header_twitter'=>'',
            'nbcore_header_linkedin'=>'',
            'nbcore_header_instagram'=>'',
            'nbcore_header_blog'=>'',
            'nbcore_header_pinterest'=>'',
            'nbcore_header_ggplus'=>'',
            'nbcore_footer_abs_left_content'=>'',
            'nbcore_footer_abs_right_content'=>'',
            'nbcore_upsells_limit'=>'',
            'nbcore_shop_banner'=>'',
            'nbcore_logo_upload2'=>'',
            'nbcore_show_to_shop'=>''
		);

	}
}

function nbfoodysushi_enqueue_styles() {
	// wp_enqueue_style('nbfoody-theme-parent', get_template_directory_uri() .'/style.css');
	$footer_abs_hover_color = nbfoody_get_options('nbcore_footer_abs_hover_color');
	$style = '.footer-abs-section a {
                color: ' . esc_attr($footer_abs_hover_color) . ';
            }';
	$css = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $style);
	wp_add_inline_style('nbfoody_front_style', $css);
}
add_action( 'wp_enqueue_scripts', 'nbfoodysushi_enqueue_styles',99999 );

if(!function_exists('nbfoody_posted_time')){
	function nbfoody_posted_time(){
		$html = '';

		if (nbfoody_get_options('nbcore_blog_meta_date')) {
			$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
			if (get_the_time('U') !== get_the_modified_time('U')) {
				$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
			}

			$time_string = sprintf($time_string,
				esc_attr(get_the_date('c')),
				esc_html(get_the_date()),
				esc_attr(get_the_modified_date('c')),
				esc_html(get_the_modified_date())
			);

			$posted_on = sprintf(
				esc_html_x('%s', 'post date', 'nb-foody'), $time_string);

			$html .= '<span class="posted-on">' . $posted_on . '</span>';
		};

		if ('' != $html) {
			echo '<div class="entry-meta">' . $html . '</div>';
		}
	}
}
if(!function_exists('get_ultimate_font_style')){
	function get_ultimate_font_style($font_style)
	{
		$weight_match = 0;
		$temp = '';
		if($font_style != '')
		{
			$font_styles = explode(',', $font_style); //split by comma<strong></strong>
			foreach($font_styles as $fstyle)
			{
				$temp .= $fstyle; //convert to css
				if(preg_match('/font-weight:/i', $fstyle))
					$weight_match++;
			}
		}
		// hack to font weight to normal if font weight not available
		if($weight_match == 0)
			$temp .= '';
		return $temp;
	}
}