<?php
namespace WpBookingPro\payments;


use WpBookingPro\Factory;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Wordpress\ECommerce\ECommerce;

class WBPayment
{
    private static $instance;
    var $type = 'payment';
    var $debug = false;
    var $object_payment = null;
    var $accepted_currencies = array();
    var $doc_form = 'generic';
    var $payment_params;
    var $features = array(
        'authorize_capture' => false,
        'recurring' => false,
        'refund' => false
    );
    protected $currency;
    /**
     * @var int
     */
    private $currency_id;

    function __construct($config) {
        $register = new Registry();
        $register->loadString($config->params);
        $config->params = $register;


        $this->payment_params=$register->get('payment_params');
        $this->object_payment=$config;
        $this->debug=$config->debug;
    }
    public static function getInstance($type,$config){
        $app=Factory::getApplication(0);
        if (isset(self::$instance[$type]) && is_object(self::$instance[$type]))
        {
            return self::$instance[$type];
        }
        
        $file_payment_path=__DIR__."/$type/".$type.".php";

        $file_short_payment_path=Utility::get_short_file_by_path($file_payment_path);
        $response=new \stdClass();
        if(file_exists($file_payment_path)){

            require_once $file_payment_path;
            $class_name="WpBookingPro\payments\WBPayment".ucfirst($type);
            if(!class_exists($class_name)){
                $app->enqueueMessage("file $file_short_payment_path must has class $class_name, please check it");
            }else{
                self::$instance[$type]=new $class_name($config);
            }
        }else{
            $app->enqueueMessage("cannot find file controller $file_short_payment_path not exists, please create it first");
        }

        return self::$instance[$type];
    }

    function onPaymentSave(&$cart, &$rates, &$payment_id)
    {
        $usable = array();
        $this->onPaymentDisplay($cart, $rates, $usable);
        $payment_id = (int)$payment_id;
        foreach ($usable as $usable_method) {
            if ($usable_method->payment_id == $payment_id)
                return $usable_method;
        }
        return false;
    }

    function onPaymentConfiguration(&$element)
    {
        $this->pluginConfiguration($element);
        if (empty($element) || empty($element->payment_type)) {
            $element = new \stdClass();
            $element->payment_type = $this->pluginName;
            $element->payment_params = new \stdClass();
            $this->getPaymentDefaultValues($element);
        }
        $this->order_statuses = hikashop_get('type.categorysub');
        $this->order_statuses->type = 'status';
        $this->currency = hikashop_get('type.currency');
        $this->weight = hikashop_get('type.weight');
        $this->volume = hikashop_get('type.volume');
    }


    public function showPage($page){
        $name=$this->name;
       require __DIR__."/$name/{$name}_end.php";

    }
    function onAfterOrderConfirm(&$order, &$methods, $method_id)
    {
        $this->payment = $methods[$method_id];
        $this->payment_params =& $this->payment->payment_params;
        $this->payment_name = $this->payment->payment_name;
        $this->loadOrderData($order);
        $this->order = $order;
    }

    function onPaymentNotification(&$statuses)
    {
    }

    function onOrderPaymentCapture(&$order, $total)
    {
        return false;
    }

    function onOrderAuthorizationCancel(&$order)
    {
        return false;
    }

    function onOrderAuthorizationRenew(&$order)
    {
        return false;
    }

    function onOrderPaymentRefund(&$order, $total)
    {
        return false;
    }










    function getPaymentDefaultValues(&$element)
    {
    }

    function checkPaymentDisplay(&$method, &$order)
    {
        return true;
    }
}