<?php
namespace WpBookingPro\Wordpress;
use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Filesystem\File;
use WpBookingPro\Filesystem\Folder;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Mvc\Controller\Controller;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\Html;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Wordpress\ECommerce\ECommerce;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\helpers\ConfigHelper;

/**
 * Class Wordpress
 * @package WpBookingPro\Wordpress
 */
class WordpressAdmin extends Wordpress
{
    private static $items_submenus;
    private static $list_menu_by_xml;
    public static $prefix_link = "wb_";
    //report_wp_org
    public function render_code_inline_script($selector, $function_name,$config){
        ob_start();
        ?>
            jQuery(document).ready(function ($) {
                $('<?php echo $selector ?>').<?php echo $function_name ?>(<?php echo json_encode($config) ?>);
            });
        <?php

        return ob_get_clean();
    }
    public function admin_scripts($hook){
        
        $depends = array( 'jquery', 'wp-util' ,'jquery-ui-core');
        $uploads = wp_upload_dir();
        $layout = isset($_GET['layout']) && $_GET['layout'] != '' ? $_GET['layout'] : 'list';
        $check_user_demo = AdminHelper::checkUserDemo();
        wp_enqueue_style( 'wb_bootstrap', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/bootstrap3.3.7/bootstrap.min.css');
        wp_enqueue_style( 'wb_awesome', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/awesome/all.min.css');
        wp_enqueue_style( 'wb_confirm', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/jquery-confirm-master/dist/jquery-confirm.min.css');
        wp_enqueue_style( 'wb_select2', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/select2-4.0.12/dist/css/select2.min.css');
        wp_enqueue_style( 'wb_icheck', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/icheck-1.x/skins/all.css');
        wp_enqueue_style( 'wb_datatables', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/datatables/datatables.min.css');
        wp_enqueue_style( 'wb_datatables_bootstrap', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/datatables/dataTables.bootstrap4.min.css');
        wp_enqueue_style( 'wb_daterangepicker', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/daterangepicker-master/daterangepicker.css');
        wp_enqueue_style( 'wb_loading', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Fullscreen-Loading-Modal-Indicator/css/jquery.loadingModal.min.css');
        wp_enqueue_style( 'wb_datetimepicker', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/datetimepicker/bootstrap-datetimepicker.css');
        wp_enqueue_style( 'wb_glyphicons', 'https://netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css');
        wp_enqueue_style( 'wb_yesno', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Toggle-Switches/lc_switch.css');
        wp_enqueue_style( 'wb_tooltipster', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/tooltipster/dist/css/tooltipster.bundle.css');
        wp_register_script ( 'wb_less', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/less/less.min.js'  ,$depends,WPBOOKINGPRO_VERSION);
        wp_register_script ( 'wb_debug', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/woo_booking_debug.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_bootstrap', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/bootstrap3.3.7/bootstrap.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_main_app.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_confirm', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/jquery-confirm-master/dist/jquery-confirm.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_select2', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/select2-4.0.12/dist/js/select2.full.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_icheck', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/icheck-1.x/icheck.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_datatables', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/datatables/jquery.dataTables.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_loading', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Fullscreen-Loading-Modal-Indicator/js/jquery.loadingModal.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_moment', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/moment/moment.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_moment_with_locales', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/moment/moment-with-locales.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_rrule', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/rrule/rrule.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_core_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/calendar/core/main.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_daygrid_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/calendar/daygray/main.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_timegrid_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/calendar/timegrid/main.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_datetimepicker',  WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/datetimepicker/bootstrap-datetimepicker.js' ,array( 'jquery', 'jquery-blockui', 'wp-util' ,'jquery-ui-core','wb_moment'),WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_daterangepicker',WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/daterangepicker-master/daterangepicker.js' ,array( 'jquery', 'jquery-blockui', 'wp-util' ,'jquery-ui-core','wb_moment'),WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_calendar_bootstrap', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/calendar/bootstrap/main.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_calendar_interaction', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/calendar/bootstrap/main.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_calendar_moment', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/calendar/moment/main.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_validation', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/jquery-validation/dist/jquery.validate.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_progress', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/ui-progress-bar/javascripts/progress.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_waiting', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Bootstrap-Loading/src/waitingfor.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_chat_js', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Chart_js/Chart.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_jquery_tab', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Bootstrap-Tabs/jquery.responsivetabs.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_bootstrap_tab', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Bootstrap-Tabs/bootstrap4/jquery.responsivetabs.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_yesno', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Toggle-Switches/lc_switch.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_tooltipster', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/tooltipster/dist/js/tooltipster.bundle.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        wp_register_script ( 'wb_bootstrap_content_edit_table', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/Content-editable/src/jquery-contenteditable.min.js' ,$depends,WPBOOKINGPRO_VERSION );
        $scripts = array('wb_less', 'wb_debug', 'wb_bootstrap', 'wb_main', 'wb_confirm', 'wb_select2', 'wb_icheck', 'wb_datatables','wb_loading','jquery-ui-core','wb_datetimepicker','wb_daterangepicker','wb_yesno','wb_tooltipster');
        if($hook == 'wpbooking-pro_page_wb_calendar_activities'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_activities', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_activities.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_activities');
                $code = $this->render_code_inline_script('.view-list-activities', 'view_list_activities', array());
                wp_add_inline_script( 'wb_view_activities', $code );
            }           
        }
        if($hook == 'wpbooking-pro_page_wb_appointment'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_appointment', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/list_view_appointment.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_appointment');
                $code = $this->render_code_inline_script('.view-list-appointment', 'list_view_appointment', array());
                wp_add_inline_script( 'wb_view_appointment', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_category'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_category', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_category.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_category');
                $code = $this->render_code_inline_script('.view-list-category', 'view_list_category', array());
                wp_add_inline_script( 'wb_view_category', $code );
            }
            
        }

        if($hook == 'wpbooking-pro_page_wb_calendar' && self::checkInstalled()){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_calendar', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_calendar.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_calendar');
                $modelCalendar = Model::getInstance("calendar");
                $list = $modelCalendar->getList();
                $modelServices = Model::getInstance('services');
                $list_service = $modelServices->getList();
                $code = $this->render_code_inline_script('.view-list-calendar','view_list_calendar',array(
                    "list_order"=>  $list,
                    "list_service"=>$list_service,
                    "is_demo" => $check_user_demo['is_demo'],
                    "url_image_demo" => $uploads['baseurl'].'/',));
                wp_add_inline_script( 'wb_view_calendar', $code );
                array_push($scripts, 'wb_moment', 'wb_moment_with_locales', 'wb_rrule', 'wb_core_main','wb_daygrid_main' , 'wb_timegrid_main', 'wb_calendar_bootstrap', 'wb_calendar_interaction', 'wb_calendar_moment', 'wb_validation');
                wp_enqueue_style( 'wb_core_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/less/core/main.min.css');
                wp_enqueue_style( 'wb_daygrid_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/less/daygray/main.min.css');
                wp_enqueue_style( 'wb_timegrid_main', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/less/timegrid/main.min.css');
                wp_enqueue_style( 'wb_calendar_bootstrap', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/less/bootstrap/main.min.css');
            }
        }

        if($hook == 'wpbooking-pro_page_wb_config'){
            if($_GET['layout'] == 'install'){
                $input = Factory::getInput();
                $toolChecked = $input->get('tool', array(), 'array');
                $step = $input->getInt('step', 0);
                if ($step == 1) {
                    array_unshift($toolChecked, "install_construct");
                    array_unshift($toolChecked, "check_required");
                    array_push($toolChecked, "finish_install");
                }
                $step++;
                $list_lang_install=array(
                   "install_construct"=>wpbookingpro_get_content('Install construct'),
                   "check_required"=>wpbookingpro_get_content('Check required'),
                   "setup_sample_database"=>wpbookingpro_get_content('Setup sample database'),
                   // "import_media_sample"=>wpbookingpro_get_content('Import media sample'),
                   "finish_install"=>wpbookingpro_get_content('Finish install'),
                );
                wp_register_script ( 'wb_view_install', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_config_install.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_waiting', 'wb_view_install');
                $code = $this->render_code_inline_script('.view-config-install','view_config_install',array(
                    "step"=>  (int)$step,
                    "tool_check"=>  array_reverse($toolChecked),
                    "list_lang_install"=>$list_lang_install,
                    "user"=> wp_get_current_user()
                ));
                wp_add_inline_script( 'wb_view_install', $code );
            }else{
                wp_enqueue_style( 'wb_nb_font', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
                wp_enqueue_style( 'wb_ui_process_ios', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/ui-progress-bar/stylesheets/ios.css');
                wp_enqueue_style( 'wb_ui_process_ui', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/ui-progress-bar/stylesheets/ui.css');
                wp_enqueue_style( 'wb_ui_process_bar', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/resources/ui-progress-bar/stylesheets/ui.progress-bar.css');
                array_push($scripts, 'wb_progress', 'wb_waiting');
            }
            
        }
        if($hook == 'wpbooking-pro_page_wb_countries'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_countries', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_countries.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_countries');
                $code = $this->render_code_inline_script('.view-list-countries', 'view_list_countries', array());
                wp_add_inline_script( 'wb_view_countries', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_coupon'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_coupon', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_coupons.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_coupon');
                $code = $this->render_code_inline_script('.view-list-coupon', 'view_list_coupons', array());
                wp_add_inline_script( 'wb_view_coupon', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_currency'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_currency', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_currency.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_currency');
                $code = $this->render_code_inline_script('.view-list-currency', 'view_list_currency', array());
                wp_add_inline_script( 'wb_view_currency', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_customer'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_customer', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_customer.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_customer');
                $code = $this->render_code_inline_script('.view-list-customer', 'view_list_customer', array());
                wp_add_inline_script( 'wb_view_customer', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_customers'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_customers', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_customers.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_customers');
                $code = $this->render_code_inline_script('.view-list-customers', 'view_list_customers', array());
                wp_add_inline_script( 'wb_view_customers', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_customize'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_customize', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_customize.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_customize');
                $code = $this->render_code_inline_script('.view-list-customize', 'view_list_customize', array());
                wp_add_inline_script( 'wb_view_customize', $code );
            }
        }
        if($hook == 'toplevel_page_wb_dashboard' && self::checkInstalled()){
            if($layout == 'list'){
                $modelOrders = Model::getInstance('orders');
                $list_order_in_year = $modelOrders->get_list_order_in_year();
                $list_order_by_month = array();
                foreach ($list_order_in_year as $item) {
                    $list_order_by_month[$item->month][] = $item;
                }
                $now = Factory::getDate();
                $month = (int)$now->format('m');
                $list_full_order_year = array();
                for ($i = $month; $i < $month + 12; $i++) {
                    {
                        $j = $i;
                        if ($j > 12) {
                            $j = $j - 12;
                        }
                        $key = "month $j";
                        if (isset($list_order_by_month[$j])) {
                            $list_full_order_year[$key] = $list_order_by_month[$j];
                        } else {
                            $list_full_order_year[$key] = array();
                        }
                    }
                }
                $list_order_by_month = $list_full_order_year;
                wp_register_script ( 'wb_view_dashboard', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_db_appointments_dashboard.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_chat_js', 'wb_jquery_tab', 'wb_bootstrap_tab','wb_view_dashboard');
                $code = $this->render_code_inline_script('.view-db-appointments-dashboard','view_db_appointments_dashboard',array(
                    "list_order_by_month"=>$list_order_by_month
                ));
                wp_add_inline_script( 'wb_view_dashboard', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_employee'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_employee', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_employee.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_employee');
                $code = $this->render_code_inline_script('.view-list-employee', 'view_list_employee', array());
                wp_add_inline_script( 'wb_view_employee', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_event'){
            if($layout == 'form'){
                wp_register_script ( 'wb_view_event_form', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_form_event.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_event_form');
                $code = $this->render_code_inline_script('.view-event-form', 'view_form_event', array());
                wp_add_inline_script( 'wb_view_event_form', $code );
            }else{
                wp_register_script ( 'wb_view_event', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_event.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_event');
                $code = $this->render_code_inline_script('.view-list-event', 'view_list_event', array());
                wp_add_inline_script( 'wb_view_event', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_groupuser'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_groupuser', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_groupuser.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_groupuser');
                $code = $this->render_code_inline_script('.view-list-groupuser', 'view_list_groupuser', array());
                wp_add_inline_script( 'wb_view_groupuser', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_location'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_location', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_location.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_location');
                $code = $this->render_code_inline_script('.view-list-location', 'view_list_location', array());
                wp_add_inline_script( 'wb_view_location', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_orderpackage'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_orderpackage', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/list_view_order_package.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_orderpackage');
                $code = $this->render_code_inline_script('.view-list-order-package', 'list_view_order_package', array());
                wp_add_inline_script( 'wb_view_orderpackage', $code );
            }else{
                wp_register_script ( 'wb_view_orderpackage', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/list_view_order_package.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_orderpackage');
                $code = $this->render_code_inline_script('.view-orderpackage-form', 'list_view_order_package', array());
                wp_add_inline_script( 'wb_view_orderpackage', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_orderstatus'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_orderstatus', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_orderstatus.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_orderstatus');
                $code = $this->render_code_inline_script('.view-list-orderstatus', 'view_list_orderstatus', array());
                wp_add_inline_script( 'wb_view_orderstatus', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_package'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_package', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_package.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_package');
                $code = $this->render_code_inline_script('.view-list-package', 'view_list_package', array());
                wp_add_inline_script( 'wb_view_package', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_payment'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_payment', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_payment.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_payment');
                $code = $this->render_code_inline_script('.view-list-payment', 'view_list_payment', array());
                wp_add_inline_script( 'wb_view_payment', $code );
            }else{
                array_push($scripts,'wb_validation');
            }
        }
        if($hook == 'wpbooking-pro_page_wb_review'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_review', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_review.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_review');
                $code = $this->render_code_inline_script('.view-list-review', 'view_list_review', array());
                wp_add_inline_script( 'wb_view_review', $code );
            }else{
                array_push($scripts,'wb_validation');
            }
        }
        if($hook == 'wpbooking-pro_page_wb_service' && self::checkInstalled()){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_service', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_service.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_service','wb_bootstrap_content_edit_table');
                $view = new View();
                $view->view = 'service';
                $model = Model::getInstance("services");
                $list_service_by_category = $model->getListServiceCategory();
                ob_start();
                $view->loadTemplate('list_service_item');
                $html_service_item = ob_get_clean();
                ob_start();
                $view->loadTemplate('list_category_item');
                $html_category_item = ob_get_clean();

                $code = $this->render_code_inline_script('.view-list-service', 'view_list_service', array(
                    "list_service_by_category"=>  $list_service_by_category,
                    "html_service_item"=>  $html_service_item,
                    "html_category_item"=>  $html_category_item,
                ));
                wp_add_inline_script( 'wb_view_service', $code );
            }else{
                wp_register_script ( 'wb_view_form_service', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_form_service.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_form_service');
                $code = $this->render_code_inline_script('.view-service-form','view_form_service', array());
                wp_add_inline_script( 'wb_view_form_service', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_sms'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_sms', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_sms.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_sms');
                $code = $this->render_code_inline_script('.view-list-sms', 'view_list_sms', array());
                wp_add_inline_script( 'wb_view_sms', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_smscontent'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_smscontent', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_smscontent.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_smscontent');
                $code = $this->render_code_inline_script('.view-list-smscontent', 'view_list_smscontent', array());
                wp_add_inline_script( 'wb_view_smscontent', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_states'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_states', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_states.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_states');
                $code = $this->render_code_inline_script('.view-list-states', 'view_list_states', array());
                wp_add_inline_script( 'wb_view_states', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_user'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_user', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_user.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_user');
                $code = $this->render_code_inline_script('.view-list-user', 'view_list_user', array());
                wp_add_inline_script( 'wb_view_user', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_vendor'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_vendor', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_vendor.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_vendor');
                $code = $this->render_code_inline_script('.view-list-vendor', 'view_list_vendor', array());
                wp_add_inline_script( 'wb_view_vendor', $code );
            }else{
                wp_register_script ( 'wb_view_vendor', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_form_vendor.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_vendor');
                $code = $this->render_code_inline_script('.view-vendor-form','view_form_vendor', array());
                wp_add_inline_script( 'wb_view_vendor', $code );
            }
        }
        if($hook == 'wpbooking-pro_page_wb_wishlist'){
            if($layout == 'list'){
                wp_register_script ( 'wb_view_wishlist', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin/app/assets/js/view_list_wishlist.js' ,$depends,WPBOOKINGPRO_VERSION );
                array_push($scripts, 'wb_view_wishlist');
                $code = $this->render_code_inline_script('.view-list-wishlist', 'view_list_wishlist', array());
                wp_add_inline_script( 'wb_view_wishlist', $code );
            }
        }
        wp_enqueue_style( 'wb_nb_font', WPBOOKINGPRO_PLUGIN_DIR_URL . 'admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
        wp_enqueue_script($scripts);
    }
    public function init(){
        if(session_id() == '')
            session_start();
        $path = WPBOOKINGPRO_PATH_ROOT . "frontend/app/views.xml";
        add_action( 'init', array( $this, 'load_plugin_textdomain' ) );
        $gutembergBlock=GutembergBlock::getInstance();
        add_action('rest_api_init', array($this, 'wp_register_rest_route'));
        add_filter('block_categories', array($gutembergBlock, 'register_block_categories'), 10, 2);
        add_action( 'enqueue_block_editor_assets',array($gutembergBlock,'mdlr_editable_block_example_backend_enqueue') );
        add_action( 'admin_head-nav-menus.php', array($this,'register_menu_metabox') );
        add_action('admin_menu', array($this, 'wpbookingpro_plugin_setup_menu'));
        add_action('admin_menu', array($this,'remove_admin_menu_items'), 999);
        //report_wp_org
        add_action('admin_enqueue_scripts' , array($this , 'admin_scripts'));
        $widgets = Widgets::getInstance();
        $widgets->init();

        $widgets = PDF_Invoice::getInstance();
        $widgets->init();

        $widgets = Motopress::getInstance();
        $widgets->init();


        $eCommerce = ECommerce::getInstance();
        $eCommerce->init();
        add_filter( 'init', array($this,"service_op_generate_rewrite_rules"));

    }

    function remove_admin_menu_items() {
        $uri = Factory::getUri();
        $path = $uri->getPath();
        if(!self::checkInstalled()) {
            return true;
        }
        $modelPermission = Model::getInstance('permission');
        $permission = $modelPermission->getPermission();
        if(strpos($path,'sellercenter') == false) {
            foreach ($permission as $key => $value) {
                $key = 'wb_'.$key;
                $value = isset($value)?json_decode($value):array();
                if(is_array($value) && !in_array('watch',$value) || empty($value)) {
                    remove_submenu_page('wb_dashboard',$key);
                }
            }
        }


     }
    function wpse66093_no_admin_access()
{
    $file = basename($_SERVER['PHP_SELF']);
    if(!self::checkInstalled()) {
        return true;
    }
    $modelPermission = Model::getInstance('permission');
    if(self::checkInstalled()){
        $permission = $modelPermission::getPermission();

        if (($file == 'wp-login.php' || is_admin()) && (!isset($permission->access_backend) || trim($permission->access_backend) == '' ) && $file != 'admin-ajax.php'){
            echo 'This page has restricted access to specific roles';
            header ("Refresh: 2;URL='".home_url()."'");
            exit();
        }
    }
}

    public  function load_plugin_textdomain(){
        load_plugin_textdomain( 'wpbookingpro', false, WPBOOKINGPRO_PATH_ROOT . '/languages/' );
    }
    public  function check_is_page_in_plugin($page){
        $list_view_admin = self::get_list_view_for_woo_panel();
        foreach ($list_view_admin as $current_page){
            if($current_page['id']==$page){
                return true;
            }
        }
        return false;
    }
    public function wp_register_rest_route(){
    register_rest_route(
        self::$namespace,
        "wpbookingpro_frontend/task",
        array(
            'methods' => 'POST',
            'callback' => array($this, 'ajax_action_task'),
        )
    );
    register_rest_route(
        self::$namespace,
        "wpbookingpro_frontend/task",
        array(
            'methods' => 'GET',
            'callback' => array($this, 'ajax_action_task'),
        )
    );
    register_rest_route(
        self::$namespace,
        "wpbookingpro_backend/task",
        array(
            'methods' => 'POST',
            'callback' => array($this, 'ajax_action_task'),
        )
    );
    register_rest_route(
        self::$namespace,
        "wpbookingpro_backend/task",
        array(
            'methods' => 'GET',
            'callback' => array($this, 'ajax_action_task'),
        )
    );
}

    function wpbookingpro_plugin_setup_menu()
    {
        $input=Factory::getInput();
        $list_view_admin = self::get_list_view_for_woo_panel();
        $page=$input->getString('page',"");
        $task=$input->getString('task',"");
        if(self::check_is_page_in_plugin($page) && $task!==""){
           Controller::action_task();
        }
        $first_view = array_shift($list_view_admin);
        $first_view = (object)$first_view;
        $menu_slug = str_replace('_', '-', $first_view->menu_slug);
        $link_dashboard = "wb_dashboard";
        add_menu_page('Wpbookingpro', 'Wpbooking pro', 'manage_options', $link_dashboard, array($this, 'wpbookingpro_page'));
        foreach ($list_view_admin as $key => $view) {
            $view = (object)$view;
            $layout=$view->layout;
            $menu_slug=$view->menu_slug;

            add_submenu_page($link_dashboard, $view->label, $view->label, 'manage_options', $menu_slug,
                array($this, 'wpbookingpro_page'));
        }






    }

    public static function get_api_task()
    {
        return "/wpbookingpro_backend/task";

    }
    function register_menu_metabox() {
        $custom_param = array( 0 => 'This param will be passed to my_render_menu_metabox' );

        add_meta_box( 'wpbookingpro-metabox', 'WP Booking Appoitment Pro', array($this,'render_menu_metabox'), 'nav-menus', 'side', 'default', $custom_param );
    }
    /**
     * Displays a menu metabox
     *
     * @param string $object Not used.
     * @param array $args Parameters and arguments. If you passed custom params to add_meta_box(),
     * they will be in $args['args']
     */
    function render_menu_metabox( $object, $args ) {
        global $nav_menu_selected_id;
        $list_page = self::get_list_layout_view_frontend();
        $key_woo_booking = self::$key_wpbookingpro;
        $my_items=array();
        $i=1;
        foreach ($list_page as $key=> $page){
            $my_items[]=(object)array(
                'ID' => $i,
                'db_id' => 0,
                'menu_item_parent' => 0,
                'object_id' => $i,
                'post_parent' => 0,
                'type' => 'custom',
                'key' => $key,
                'content' => '[wpbookingpro view="'.$key.'"]',
                'object' => 'my-object-slug',
                'type_label' => 'My Cool Plugin',
                'title' => $page['title'],
                'url' => home_url( '/'.$key ),
                'target' => '',
                'attr_title' => '',
                'description' => '',
                'classes' => array(),
                'xfn' => '',
            );
            $i++;
        }
        // Create an array of objects that imitate Post objects

        $removed_args = array(
            'action',
            'customlink-tab',
            'menu-item',
            'page-tab',
            '_wpnonce',
        ); ?>
        <div id="my-plugin-div">
        <div id="tabs-panel-my-plugin-all" class="tabs-panel tabs-panel-active">
            <ul id="my-plugin-checklist-pop" class="categorychecklist form-no-clear" >
                <?php foreach ($my_items as $item){ ?>
                    <li>
                        <label class="menu-item-title">
                            <input type="checkbox" class="menu-item-checkbox" name="menu-item[-<?php Text::_echo_no_translate($item->ID) ?>][menu-item-object-id]" value="-<?php Text::_echo_no_translate($item->ID) ?>"><?php Text::_echo_no_translate($item->title) ?></label>
                        <input type="hidden" class="menu-item-type" name="menu-item[-<?php Text::_echo_no_translate($item->ID) ?>][menu-item-type]" value="custom">
                        <input type="hidden" class="menu-item-title" name="menu-item[-<?php Text::_echo_no_translate($item->ID) ?>][menu-item-title]" value="<?php Text::_echo_no_translate($item->title) ?>">
                        <input type="hidden" class="menu-item-url" name="menu-item[-<?php Text::_echo_no_translate($item->ID) ?>][menu-item-url]" value="<?php Text::_echo_no_translate($item->url) ?>">
                        <input type="hidden" class="menu-item-classes" name="menu-item[-2][menu-item-classes]">
                    </li>
                <?php } ?>
            </ul>

            <p class="button-controls">
			<span class="list-controls">
				<a href="<?php
                echo (add_query_arg(
                    array(
                        'my-plugin-all' => 'all',
                        'selectall' => 1,
                    ),
                    remove_query_arg( $removed_args )
                ));
                ?>#my-menu-test-metabox" class="select-all"><?php esc_html_e( 'Select All','wpbookingpro' ); ?></a>
			</span>

                <span class="add-to-menu">
				<input type="submit"<?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button-secondary submit-add-to-menu right" value="<?php esc_attr_e( 'Add to Menu' ,'wpbookingpro'); ?>" name="add-my-plugin-menu-item" id="submit-my-plugin-div" />
				<span class="spinner"></span>
			</span>
            </p>
        </div>
        <?php
    }
    public static function get_list_layout_view_frontend()
    {

        $views_path = WPBOOKINGPRO_APP_FRONTEND_PATH . "/views";

        $list_view = array();
        $folders = Folder::folders($views_path);


        foreach ($folders as $view) {
            $view_path = $views_path . "/$view";
            if (!Folder::exists($view_path . "/tmpl")) {
                continue;
            }
            $files = Folder::files($view_path . "/tmpl", ".xml");


            foreach ($files as $file) {
                if (strpos($file, "config_") === 0) {
                    continue;
                }
                $xmlFile = pathinfo($file);
                $filename = $xmlFile['filename'];
                $file_path = $view_path . "/tmpl/$file";
                $title = "";
                $show_main_menu = true;
                $xml = simplexml_load_file($file_path);

                try {
                    $attributes=$xml->layout->attributes();
                    $title = (string)$attributes['title'];
                    $bool = (string)$attributes['show_main_menu'];
                    $show_main_menu = filter_var($bool, FILTER_VALIDATE_BOOLEAN);;
                } catch (Exception $e) {
                    echo ('PLEASE_CHECK_FILE_TRUCTOR_XML');
                    die;
                }
                $title = esc_html($title);
                if (!$title) {
                    continue;
                }
                $list_view["$view-$filename"] = array(
                    "title" => $title,
                    "show_main_menu" => $show_main_menu
                );


            }
        }
        return $list_view;
    }

    public static function get_list_view_for_woo_panel()
    {
        if (empty(static::$items_submenus)) {
            $list_menu_by_xml = self::get_list_view_xml();
            $confingModel = Model::getInstance('config');
            $list_view = $confingModel->get_list_view_publish();
            $items_submenus = array();
            $index = 21;

            $config = Factory::getConfig();
            $environment = $config->get('environment', 'production');
            $list_environment = array(
                "production"
            );
            if ($environment == "development") {
                $list_environment[] = "development";
            }
            if ($environment == "demo") {
                $list_environment[] = "demo";
            }

            foreach ($list_menu_by_xml as $view) {

                if (in_array($view->environment, $list_environment) && ($view->is_system || in_array($view->menu_slug,
                            $list_view))) {
                    $items_submenus[] = array(
                        'id' => self::$prefix_link . $view->id,
                        'menu_slug' => self::$prefix_link . $view->menu_slug,
                        'label' => $view->label,
                        'page_title' => $view->page_title,
                        'capability' => $view->capability,
                        'icon' => $view->icon,
                        "item_url" => $view->item_url,
                        "layout" => $view->layout,
                        "environment" => $view->environment
                    );

                    $index++;
                }

            }
            self::$items_submenus = $items_submenus;
        }


        return self::$items_submenus;
    }

    public static function get_list_view_xml()
    {

        if (empty(self::$list_menu_by_xml)) {
            $file_xml_path_app = WPBOOKINGPRO_APP_BACKEND_PATH . "/views.xml";
            $xml = simplexml_load_file($file_xml_path_app);


            $list_menu_by_xml = array();
            foreach ($xml->view as $view) {
                $attributes=$view->attributes();
                $environment = (string)$attributes['environment'];
                if (!$environment) {
                    $environment = "production";
                }
                $list_menu_by_xml[] = (object)array(
                    'id' => (string)$attributes['id'],
                    'menu_slug' => (string)$attributes['menu_slug'],
                    'label' => (string)$attributes['label'],
                    'page_title' => (string)$attributes['page_title'],
                    'capability' => (string)$attributes['capability'],
                    'icon' => (string)$attributes['icon'],
                    'class' => (string)$attributes['class'],
                    'is_system' => (boolean)$attributes['is_system'],
                    'item_url' => (string)$attributes['item_url'],
                    'layout' => (string)$attributes['layout'],
                    'environment' => $environment

                );


            }
            self::$list_menu_by_xml = $list_menu_by_xml;
        }
        return self::$list_menu_by_xml;
    }
    public static function checkInstalled()
    {
        $app = Factory::getApplication(1);
        $db = Factory::getDBO();
        $installed = true;
        $list_table_in_database = $db->setQuery("SHOW TABLES LIKE " . $db->quote("woobooking\\_%"))->loadColumn();
        if (count($list_table_in_database) == 0) {
            $installed = false;
        }
        $json_table_need_install = File::read(WPBOOKINGPRO_PATH_ROOT . "/install/tables.json");

        $json_table_need_install = json_decode($json_table_need_install);

        foreach ($json_table_need_install as $need_table) {
            if (!in_array($need_table, $list_table_in_database)) {
                $installed = false;
                break;
            }
        }

        return $installed;
    }
    function goToPopupInstall()
    {
        $root_url = Factory::getRootUrl();
        $html = '<html><head>';
        $html .= '<meta http-equiv="content-type" content="text/html; charset=utf-8" />';
        $html .= '<script>document.location.href=' . json_encode(str_replace("'", '&apos;',
                $root_url . '/wp-admin/admin.php?page=wb_config&layout=install')) . ';</script>';
        $html .= '</head><body></body></html>';
        echo ($html);
    }

    function wpbookingpro_page()
    {
        $input = Factory::getInput();
        $page = $input->getString('page', '');
        $layout=$input->getString('layout',"");
        if($page=="wb_config"){
            if($layout!=="install" && !self::checkInstalled()){
                self::goToPopupInstall();
                return;
            }
        }elseif(!self::checkInstalled()){
            self::goToPopupInstall();
            return;
        }
        
        require_once WPBOOKINGPRO_PATH_ROOT.DS."admin/app/Html/HtmlBackend.php";
        wp_enqueue_editor();
        wp_enqueue_media();
        $input = Factory::getInput();
        $data = $input->getData();
        $task = array_key_exists('task', $data) ? $data['task'] : null;
        $layout = array_key_exists('layout', $data) ? $data['layout'] : null;
        $layout = $layout ? $layout : "list";
        $menu = self::get_true_menu_of_woo_booking($page);
        $file_controller_path = WPBOOKINGPRO_APP_BACKEND_PATH . "/controllers/" . ucfirst($menu) . "Controller.php";

        $file_controller_short_path = Utility::get_short_file_by_path($file_controller_path);

        if (file_exists($file_controller_path)) {

            $class_name = "WpBookingProAdmin\\app\\controllers\\".ucfirst($menu) . "Controller";
            if (class_exists($class_name)) {
                $class_controller = new $class_name();
                $content=$class_controller->view("$menu.$layout");
                $toolbar=ToolBar::render_toolbar();
                echo '<div class="wrapper-wpbooking-pro-view-admin">'.$toolbar.$content.$toolbar.'</div>';
            } else {
                echo ('CLASS'.$class_name.'NOT_EXIT_IN_FILE'.$file_controller_short_path.'PLEASE_CREATE_THIS_CLASS');
            }
        } else {

            echo ('FILE_CONTROLLER_NOT_FOUND_PLEASE_CREATE_FILE '.$file_controller_short_path);
        }
        add_action('admin_footer', array($this, 'wp_hook_add_script_footer'));
    }
    public function wp_hook_add_script_footer(){
        global $wp;

        wp_enqueue_script("jquery");
        $doc = Factory::getDocument();

        $lessStyleSheets = $doc->getLessStyleSheets();
        $config=Factory::getConfig();

        $environment=$config->get('environment',"development");
        if($environment=="development") {
            foreach ($lessStyleSheets as $src => $item) {
                ob_start();
                ?>
                <link rel="stylesheet/less" type="text/css"
                      href="<?php  Text::_echo(WPBOOKINGPRO_PLUGIN_DIR_URL . "/" . $src) ?>"/>
                <?php
                echo (ob_get_clean());
            }
        }else{
            $doc->addStyleSheet('admin/app/assets/less/style.css');
        }

        $styleSheets = $doc->getStyleSheets();
        foreach ($styleSheets as $src => $item) {
            $random = random_int(100000, 900000);
            if (strpos($src, 'http') !== false) {
                wp_enqueue_style('wpbookingpro-css-' . $random, $src);
            } else {
                wp_enqueue_style('wpbookingpro-css-' . $random, WPBOOKINGPRO_PLUGIN_DIR_URL . '/' . $src);
            }
        }
        ob_start();
        ?>
        <script type="text/javascript">
            var wpbookingpro_root_url = "<?php  echo (WPBOOKINGPRO_SITE_URL) ?>";
            var wpbookingpro_current_url = "<?php  echo (WPBOOKINGPRO_SITE_URL) ?>";
            var wpbookingpro_root_url_plugin = "<?php echo (WPBOOKINGPRO_PLUGIN_DIR_URL); ?>/";
            var wpbookingpro_api_task = "/wp-json/<?php echo (self::$namespace.$this->get_api_task()) ?>";
        </script>
        <?php
        $content=ob_get_clean();
        $content= Utility::remove_string_javascript($content);
        wp_enqueue_script('wpbookingpro-js-init', WPBOOKINGPRO_PLUGIN_DIR_URL .'frontend/resources/init.js' );
        wp_add_inline_script('wpbookingpro-js-init', $content);

        $scripts = $doc->getScripts();
        foreach ($scripts as $src => $item){
            try {
                $random = random_int(100000, 900000);
                if (strpos($src, 'http') !== false || strpos($src, 'https') !== false) {
                    wp_enqueue_script('wpbookingpro-js-out-site'.$random,$src,array('jquery') );
                } else {
                    $src=WPBOOKINGPRO_PLUGIN_DIR_URL . $src;
                    wp_enqueue_script('wpbookingpro-js-in-site-'.$random, $src,array('jquery') );
                }
            } catch (Exception $e) {
            }

        }
        wp_enqueue_script('wpbookingpro-js-defined', WPBOOKINGPRO_PLUGIN_DIR_URL .'frontend/resources/define.js' );
        $doc=Factory::getDocument();
        $script = $doc->getScript();
        foreach ($script as $content) {
            wp_add_inline_script('wpbookingpro-js-defined', $content);
        }
    }

    public function service_op_generate_rewrite_rules()
    {
        $wordpress=Factory::getWordpress(1);
        if(!$wordpress->checkInstalled()) { return; }
        parent::service_op_generate_rewrite_rules();

    }

    private static function get_true_menu_of_woo_booking($menu)
    {
        return str_replace(self::$prefix_link, "", $menu);
    }



}