<?php

namespace WpBookingPro\Wordpress;



use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingProAdmin\app\helpers\AdminHelper;

/**
 * Class PDF_Invoice
 * @package WpBookingPro\Wordpress
 */
class Motopress
{
    /**
     * @var null
     */
    public static $instance=null;

    /**
     * @return PDF_Invoice|null
     */
    public static function getInstance(){
        if (!isset(self::$instance))
        {
            self::$instance=  new Motopress();
        }
        return self::$instance;
    }

    /**
     * PDF_Invoice constructor.
     */
    public function __construct()
    {

    }

    /**
     *
     */
    public function init()
    {
        add_filter('prefix_table_plugin',array($this,'prefix_table_plugin'), 10, 1);
        add_action('hook_login_listen',array($this,'hook_login_listen'), 10, 1 );
        add_action('copy_table_plugin',array($this,'copy_table_plugin'), 10, 2 );
        add_action('add_user_when_activate_email',array($this,'add_user_when_activate_email'), 10, 1 );
        add_filter('wpmu_drop_tables',array($this,'demo_delete_my_custom_tables'), 10, 2 );
        add_action('delete_info_user_demo',array($this,'delete_info_user_demo'), 10, 1 );


    }

    function delete_info_user_demo($blog_id) {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('wp_mp_demo_sandboxes.user_id')
            ->from('wp_mp_demo_sandboxes AS wp_mp_demo_sandboxes')
            ->where('wp_mp_demo_sandboxes.blog_id='.(int)$blog_id)
        ;
        $user_demo_id = $db->setQuery($query)->loadResult();

        $query->clear()
            ->select('wp_mp_demo_users.wp_user_id')
            ->from('wp_mp_demo_users AS wp_mp_demo_users')
            ->where('wp_mp_demo_users.user_id='.(int)$user_demo_id)
        ;
        $wp_user_id = $db->setQuery($query)->loadResult();

        $query->clear()
            ->delete('wp_mp_demo_users')
            ->where('user_id='.(int)$user_demo_id)
        ;
        $db->setQuery($query)->execute();

        $query->clear()
            ->delete('woobooking_user')
            ->where('open_source_user_id='.(int)$wp_user_id)
        ;
        $db->setQuery($query)->execute();

        //For wp_delete_user() function
        global $wpdb;
        $wpdb->query($wpdb->prepare("DELETE FROM $wpdb->users WHERE ID = %d", $wp_user_id));
    }

    function add_user_when_activate_email($user_id) {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('wp_user_id')
            ->from('wp_mp_demo_users')
            ->where('user_id='.(int)$user_id)
        ;
        $wp_user_id = $db->setQuery($query)->loadResult();
        global $wpdb;
        $email = $wpdb->get_var($wpdb->prepare("SELECT user_email FROM $wpdb->users  WHERE ID = %s", $wp_user_id));
        if($wp_user_id && $wp_user_id > 0 && $email && trim($email) != '') {
            $query->clear()
                ->insert('woobooking_user')
                ->set('open_source_user_id='.(int)$wp_user_id)
                ->set('email='.$query->quote($email))
                ->set('group_user_id=3')
            ;
            $db->setQuery($query)->execute();
        }

    }

    function copy_table_plugin($user, $target_pre) {

        $list_table = AdminHelper::get_list_table();
        $user_email = $user['email'];
        $user_email = str_replace('.','_',$user_email);
        $user_email = strstr($user_email, '@', true);
        $underscore= '_';
        $db = Factory::getDBO();
        foreach ($list_table as $table) {
            $db->setQuery("CREATE TABLE $target_pre$user_email$underscore$table LIKE $table")->execute();
            $db->setQuery("INSERT INTO $target_pre$user_email$underscore$table SELECT * FROM $table")->execute();
        }
    }
    function hook_login_listen($user_id) {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('wp_user_id')
            ->from('wp_mp_demo_users')
            ->where('user_id='.(int)$user_id)
        ;
        $wp_user_id = $db->setQuery($query)->loadResult();
        $_SESSION['user_id'] = $wp_user_id;
    }
    function demo_delete_my_custom_tables( $tables, $blog_id ) {
        $demo_tables = AdminHelper::get_table_user_demo($blog_id);
        foreach ($demo_tables as $demo_table_item) {
            $tables[] = $demo_table_item;
        }
        return $tables;
    }


    public function prefix_table_plugin($prefix='') {
        $prefix = WPBOOKINGPRO_PREFIX_TABLE;
        return $prefix;
    }

}