<?php
namespace WpBookingPro\Mvc\View;
use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Object\CMSObject;
use WpBookingPro\Utilities\Utility;

class View extends CMSObject
{
    public $view="";
    public $list="";
    public $header="";
    public $item="";
    public $filterForm;
    public $_defaultModel;
    public $form="";
    protected $_escape = 'htmlspecialchars';
    public function getModel($model=""){
        $model=$model?$model:$this->view;
        $model=ucfirst($model);
        $model_path=WPBOOKINGPRO_APP_PATH."/models/$model.php";
        if(file_exists($model_path)){
            $model_class=Model::getInstance($model);
            $model_class->model=$model;
            return $model_class;
        }else{
            throw new Exception(Text::_("Error: model <b>$model_path</b> not exists, please create first"));
        }

    }
    public static $instance=array();

    public static function getInstance($view, $prefix = '', $config = array()):View
    {
        $view = preg_replace('/[^A-Z0-9_\.-]/i', '', $view);
        $UCFview = ucfirst($view);
        $view_path = WPBOOKINGPRO_APP_PATH . "/views/$view/{$UCFview}View.php";
        if (file_exists($view_path)) {
            require_once $view_path;
            if (!array_key_exists($view, self::$instance)) {
                if(strpos(WPBOOKINGPRO_APP_PATH,"admin/app")!==false){
                    $class_name="WpBookingProAdmin\\app\\views\\$view\\".$UCFview."View";
                }else{
                    $class_name="WpBookingProFrontend\\app\\views\\$view\\".$UCFview."View";
                }
                self::$instance[$view] = new $class_name();
                self::$instance[$view]->model = $view;
            }

        } else {
            throw new Exception(Text::_("can not found model:" . Utility::get_short_file_by_path($view_path) . ',please create it'));
        }
        return self::$instance[$view];
    }


    public function __construct()
    {

    }
    public function get($property, $default = null)
    {
        // If $model is null we use the default model
        if ($default === null)
        {
            $model = $this->_defaultModel;
        }
        else
        {
            $model = strtolower($default);
        }

        // First check to make sure the model requested exists
        if (isset($this->_models[$model]))
        {
            // Model exists, let's build the method name
            $method = 'get' . ucfirst($property);

            // Does the method exist?
            if (method_exists($this->_models[$model], $method))
            {
                // The method exists, let's call it and return what we get
                $result = $this->_models[$model]->$method();

                return $result;
            }
        }

        // Degrade to \JObject::get
        $result = parent::get($property, $default);

        return $result;
    }


    public function escape($var)
    {
        if (in_array($this->_escape, array('htmlspecialchars', 'htmlentities')))
        {
            return call_user_func($this->_escape, $var, ENT_COMPAT, isset($this->_charset)?$this->_charset:"");
        }

        return call_user_func($this->_escape, $var);
    }

    public static function goToLink($view_layout, $items_var=array()){

        list($view,$layout)=explode(".",$view_layout);
        $openSource=Factory::getOpenSource();
        $key_woo_booking=$openSource->getKeyWooBooking();
        $http_list_var=array();
        if(is_array($items_var)){
            foreach ($items_var as $key=> $value){
                $http_list_var[]="$key=$value";
            }
        }else{
            $http_list_var[]=  $items_var;
        }


        $link=Factory::getRootUrl()."wp-admin/admin.php?page=wb_$view&layout=$layout".implode("&",$http_list_var);
        return $link;
    }
    public function redirect($url){
        $root_url=Factory::getRootUrl();

        $html = '<html><head>';
        $html .= '<meta http-equiv="content-type" content="text/html; charset=utf-8" />';
        $html .= '<script>document.location.href=' . json_encode(str_replace("'", '&apos;', $root_url.'/'.$url)) . ';</script>';
        $html .= '</head><body></body></html>';
        echo ($html);
    }

    public static function frontendGoToLink($view_layout, $items_var=array()){

        list($view,$layout)=explode(".",$view_layout);
        $openSource=Factory::getOpenSource();
        $key_woo_booking=$openSource->getKeyWooBooking();
        $http_list_var=array();
        if(is_array($items_var)){
            foreach ($items_var as $key=> $value){
                $http_list_var[]="$key=$value";
            }
        }else{
            $http_list_var[]=  $items_var;
        }


        $link=Factory::getRootUrl()."wp-booking-pro/?page=$view-$layout&".implode("&",$http_list_var);
        return $link;
    }
    public static function getFrontendLink($view_layout, $items_var=array()){

        list($view,$layout)=explode(".",$view_layout);
        $openSource=Factory::getOpenSource();
        $key_woo_booking=$openSource->getKeyWooBooking();
        $http_list_var=array();
        if(is_array($items_var)){
            foreach ($items_var as $key=> $value){
                $http_list_var[]="$key=$value";
            }
        }else{
            $http_list_var[]=  $items_var;
        }


        $link=Factory::getRootUrl()."wp-booking-pro/?page=$view-$layout&".implode("&",$http_list_var);
        return $link;
    }

    public static function goToTaskLinkBackend($view,$task, $items_var=array()){


        $http_list_var=array();
        if(is_array($items_var)){
            foreach ($items_var as $key=> $value){
                $http_list_var[]="$key=$value";
            }
        }else{
            $http_list_var[]=  $items_var;
        }


        $link=Factory::getRootUrl()."wp-admin/admin.php?page=wb_$view&task=$view.$task".(is_array($items_var)&&count($items_var)?'&':null).implode("&",$http_list_var);
        return $link;
    }
    public static function goToTaskLinkFrontend($view,$task, $items_var=array()){


        $http_list_var=array();
        if(is_array($items_var)){
            foreach ($items_var as $key=> $value){
                $http_list_var[]="$key=$value";
            }
        }else{
            $http_list_var[]=  $items_var;
        }


        $link=Factory::getRootUrl()."wp-booking-pro/?page=$view-list&task=$view.$task".(is_array($items_var)&&count($items_var)?'&':null).implode("&",$http_list_var);
        return $link;
    }
    public static function goToTaskLink($view,$task, $items_var=array()){


        $http_list_var=array();
        if(is_array($items_var)){
            foreach ($items_var as $key=> $value){
                $http_list_var[]="$key=$value";
            }
        }else{
            $http_list_var[]=  $items_var;
        }


        $link=Factory::getRootUrl()."/wp-admin/admin.php?page=wb_$view&task=$view.$task".(is_array($items_var)&&count($items_var)?'&':null).implode("&",$http_list_var);
        return $link;
    }
    public function loadTemplate($tpl){
        $client=Factory::getApplicationClient();
        $tmpl_short_path="/views/".$this->view."/tmpl/".$tpl.".php";
        $open_source=Factory::getOpenSource($client);
        $plugin_name=WPBOOKINGPRO_PLUGIN_NAME;
        //Đường dẫn đến theme đang sd trong wp
        $template_path=get_template_directory();

        if($client==0) {
            $template1_path="$template_path/$plugin_name/"."frontend/app/{$this->view}/tmpl/{$tpl}.php";
        } elseif ($client == 1) {
            $template1_path="$template_path/$plugin_name/"."admin/app/{$this->view}/tmpl/{$tpl}.php";
        } else {
            $template1_path="$template_path/$plugin_name/"."admin_woopanel/app/{$this->view}/tmpl/{$tpl}.php";
        }
        $template2_path= WPBOOKINGPRO_APP_PATH.$tmpl_short_path;
        if(file_exists($template1_path)){
            $tmpl_path= $template1_path;
        }else{
            $tmpl_path= $template2_path;
        }

        if(file_exists($tmpl_path)){
            ob_start();
            include $tmpl_path;
            $content=ob_get_clean();
            echo  $content;
        }else{
            throw new Exception("Error:tpl <b>$tpl</b> not exits, please create it");
        }
    }

    public function loadBlock($block){
        $client = Factory::getApplicationClient();

        $tmpl_short_path="/frontend/blocks/block_$block/$block.php";

        $plugin_name=WPBOOKINGPRO_PLUGIN_NAME;
        $template_path=get_template_directory();
        if($client==0) {
            $template1_path="$template_path/$plugin_name/"."frontend/blocks/block_$block/$block.php";
        } elseif ($client==1) {
            $template1_path="$template_path/$plugin_name/"."admin/blocks/block_$block/$block.php";
        } else {
            $template1_path="$template_path/$plugin_name/"."admin_woopanel/blocks/block_$block/$block.php";
        }

        $template2_path= WPBOOKINGPRO_APP_PATH.$tmpl_short_path;
        if(file_exists($template1_path)){
            $tmpl_path= $template1_path;
        }else{
            $tmpl_path= $template2_path;
        }

        if(file_exists($tmpl_path)){
            ob_start();
            include $tmpl_path;
            $content=ob_get_clean();
            echo  $content;
        }else{
            throw new Exception("Error:not exists block");
        }
    }

    public function loadSharedTemplate($template){
        list($template,$layout)=explode(".",$template);
        $tmpl_short_path="/shared/".$template."/$layout.php";

        $tmpl_path=WPBOOKINGPRO_APP_PATH.$tmpl_short_path;

        if(file_exists($tmpl_path)){
            ob_start();
            require $tmpl_path;
            $content=ob_get_clean();
            echo ($content);
        }else{
            throw new Exception(Text::_("Error:tpl <b>$tmpl_short_path</b> not exits, please create it"));
        }
    }
    public function loadTemplateFromOtherView($view,$tpl){
        $tmpl_short_path="/views/".$view."/tmpl/".$tpl.".php";
        $tmpl_path=WPBOOKINGPRO_APP_PATH.$tmpl_short_path;

        if(file_exists($tmpl_path)){
            ob_start();
            require $tmpl_path;
            $content=ob_get_clean();
            echo ($content);
        }else{
            throw new Exception(Text::_("Error:tpl <b>$tpl</b> not exits, please create it"));
        }
    }
    public function display($tpl){
        $client = Factory::getApplicationClient();
        $tmpl_short_path="/views/".$this->view."/tmpl/".$tpl.".php";
        $plugin_name=WPBOOKINGPRO_PLUGIN_NAME;
        $template_path=get_template_directory();
        if($client==0) {
            $template1_path="$template_path/$plugin_name/"."frontend/app/{$this->view}/tmpl/{$tpl}.php";
        } elseif ($client == 1) {
            $template1_path="$template_path/$plugin_name/"."admin/app/{$this->view}/tmpl/{$tpl}.php";
        } else {
            $template1_path="$template_path/$plugin_name/"."admin_woopanel/app/{$this->view}/tmpl/{$tpl}.php";
        }
        $template2_path= WPBOOKINGPRO_APP_PATH.$tmpl_short_path;
        if(file_exists($template1_path)){
            $tmpl_path= $template1_path;
        }else{
            $tmpl_path= $template2_path;
        }

        $wordpress = Factory::getWordpress($client);
        $appConfig=Factory::getAppConfig();
        $debug="";
        if(!$wordpress->is_rest_api() && ($appConfig->get('debug_dev')==1 || $appConfig->get('debug_end_user') )) {
            ob_start();
            ?>
            <div class="wrapper-woo-booking-debug">
                <h3>Debug</h3>
                <?php if($appConfig->get('debug_dev')==1){ ?>
                    <div class="dev-debug">
                        <h4>Dev debug</h4>
                        <div class="panel-group" id="dev-accordion" role="tablist" aria-multiselectable="true">
                            <div class="panel panel-default">
                                <div class="panel-heading" role="tab" id="dev-headingOne">
                                    <h4 class="panel-title">
                                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#dev-collapseOne"
                                           aria-expanded="true" aria-controls="dev-collapseOne">
                                            title debbug
                                        </a>
                                    </h4>
                                </div>
                                <div id="dev-collapseOne" class="panel-collapse collapse in" role="tabpanel"
                                     aria-labelledby="dev-headingOne">
                                    <div class="panel-body">
                                        content debug
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <?php if($appConfig->get('debug_end_user')==1){ ?>
                    <div class="user-debug">
                        <h4>user debug</h4>
                        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                            <div class="panel panel-default">
                                <div class="panel-heading" role="tab" id="user-debug-headingOne">
                                    <h4 class="panel-title">
                                        <a role="button" data-toggle="collapse" data-parent="#user-debug-accordion" href="#user-debug-collapseOne"
                                           aria-expanded="true" aria-controls="user-debug-collapseOne">
                                            title debug
                                        </a>
                                    </h4>
                                </div>
                                <div id="user-debug-collapseOne" class="panel-collapse collapse in" role="tabpanel"
                                     aria-labelledby="user-debug-headingOne">
                                    <div class="panel-body">
                                        content debug
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <?php
            $debug=ob_get_clean();
        }


        ob_start();
        ?>
        <div id="loader-wrapper">
            <div id="loader"></div>

            <div class="loader-section section-left"></div>
            <div class="loader-section section-right"></div>

        </div>

        <?php
        $loading=ob_get_clean();

        if(file_exists($tmpl_path)){
            ob_start();
            include $tmpl_path;
            $content=ob_get_clean();
            if(!trim($content)){
                $content="<div class='wrapper-woo-booking'><p>layout <b>$tmpl_short_path</b> empty please add content to it</p>$debug</div>";
            }
            $content="<div class=\"wrapper-woo-booking\">$loading $content $debug</div>";
            $doc=Factory::getDocument();


            $headDocument=$doc->loadRenderer('head');
            $headDocument->render('head');
            $wordpress->wp_add_inline_script();
            return $content;
        }else{
            throw new Exception("Error:tpl <b>$tpl</b> not exits, please create it in view <b>".$this->view."</b>");
        }


    }

    public function display_block($block_id,$tpl){

        $tmpl_short_path="/views/".$this->view."/tmpl/".$tpl.".php";
        $tmpl_path=WPBOOKINGPRO_APP_PATH.$tmpl_short_path;
        $wordpress = Factory::getWordpress(Factory::getApplicationClient());
        $debug="";
        if(!$wordpress->is_rest_api()) {
            ob_start();
            ?>
            <div class="wrapper-woo-booking-debug">
                <h3>Debug</h3>
                <div class="dev-debug">
                    <h4>Dev debug</h4>
                    <div class="panel-group" id="dev-accordion" role="tablist" aria-multiselectable="true">
                        <div class="panel panel-default">
                            <div class="panel-heading" role="tab" id="dev-headingOne">
                                <h4 class="panel-title">
                                    <a role="button" data-toggle="collapse" data-parent="#accordion" href="#dev-collapseOne"
                                       aria-expanded="true" aria-controls="dev-collapseOne">
                                        Collapsible Group Item #1
                                    </a>
                                </h4>
                            </div>
                            <div id="dev-collapseOne" class="panel-collapse collapse in" role="tabpanel"
                                 aria-labelledby="dev-headingOne">
                                <div class="panel-body">
                                    Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
                                    richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
                                    brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt
                                    aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.
                                    Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente
                                    ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                    farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them
                                    accusamus labore sustainable VHS.
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-heading" role="tab" id="dev-headingTwo">
                                <h4 class="panel-title">
                                    <a class="dev-collapsed" role="button" data-toggle="collapse" data-parent="#dev-accordion"
                                       href="#dev-collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        Collapsible Group Item #2
                                    </a>
                                </h4>
                            </div>
                            <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel"
                                 aria-labelledby="headingTwo">
                                <div class="panel-body">
                                    Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
                                    richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
                                    brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt
                                    aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.
                                    Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente
                                    ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                    farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them
                                    accusamus labore sustainable VHS.
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-heading" role="tab" id="dev-headingThree">
                                <h4 class="panel-title">
                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#dev-accordion"
                                       href="#dev-collapseThree" aria-expanded="false" aria-controls="dev-collapseThree">
                                        Collapsible Group Item #3
                                    </a>
                                </h4>
                            </div>
                            <div id="dev-collapseThree" class="panel-collapse collapse" role="tabpanel"
                                 aria-labelledby="dev-headingThree">
                                <div class="panel-body">
                                    Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
                                    richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
                                    brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt
                                    aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.
                                    Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente
                                    ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                    farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them
                                    accusamus labore sustainable VHS.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="user-debug">
                    <h4>user debug</h4>
                    <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                        <div class="panel panel-default">
                            <div class="panel-heading" role="tab" id="user-debug-headingOne">
                                <h4 class="panel-title">
                                    <a role="button" data-toggle="collapse" data-parent="#user-debug-accordion" href="#user-debug-collapseOne"
                                       aria-expanded="true" aria-controls="user-debug-collapseOne">
                                        Collapsible Group Item #1
                                    </a>
                                </h4>
                            </div>
                            <div id="user-debug-collapseOne" class="panel-collapse collapse in" role="tabpanel"
                                 aria-labelledby="user-debug-headingOne">
                                <div class="panel-body">
                                    Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
                                    richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
                                    brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt
                                    aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.
                                    Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente
                                    ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                    farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them
                                    accusamus labore sustainable VHS.
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-heading" role="tab" id="user-debug-headingTwo">
                                <h4 class="panel-title">
                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#user-debug-accordion"
                                       href="#user-debug-collapseTwo" aria-expanded="false" aria-controls="user-debug-collapseTwo">
                                        Collapsible Group Item #2
                                    </a>
                                </h4>
                            </div>
                            <div id="user-debug-collapseTwo" class="panel-collapse collapse" role="tabpanel"
                                 aria-labelledby="user-debug-headingTwo">
                                <div class="panel-body">
                                    Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
                                    richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
                                    brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt
                                    aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.
                                    Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente
                                    ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                    farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them
                                    accusamus labore sustainable VHS.
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-heading" role="tab" id="user-debug-headingThree">
                                <h4 class="panel-title">
                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#user-debug-accordion"
                                       href="#user-debug-collapseThree" aria-expanded="false" aria-controls="user-debug-collapseThree">
                                        Collapsible Group Item #3
                                    </a>
                                </h4>
                            </div>
                            <div id="collapseThree" class="panel-collapse collapse" role="tabpanel"
                                 aria-labelledby="user-debug-headingThree">
                                <div class="panel-body">
                                    Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
                                    richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
                                    brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt
                                    aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.
                                    Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente
                                    ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                    farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them
                                    accusamus labore sustainable VHS.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $debug=ob_get_clean();
        }

        ob_start();
        ?>
        <div id="loader-wrapper">
            <div id="loader"></div>

            <div class="loader-section section-left"></div>
            <div class="loader-section section-right"></div>

        </div>

        <?php
        $loading=ob_get_clean();

        if(file_exists($tmpl_path)){
            ob_start();
            include $tmpl_path;
            $content=ob_get_clean();
            if(!trim($content)){
                $content="<div class='wrapper-woo-booking'><p>layout <b>$tmpl_short_path</b> empty please add content to it</p>$debug</div>";
            }
            $content="<div class=\"wrapper-woo-booking\">$loading $content $debug</div>";
            $doc=Factory::getDocument();


            $headDocument=$doc->loadRenderer('head');
            $headDocument->render('head');
            $wordpress->wp_add_inline_script();
            return $content;
        }else{
            throw new Exception("Error:tpl <b>$tpl</b> not exits, please create it in view <b>".$this->view."</b>");
        }
    }

    public function displayList(){
        if(!$this->list){
            $model=$this->getModel();
            $this->list=$model->getList();
            $this->header=$model->getHeader();
        }
        $this->view="default";
        echo (self::display("list"));

    }
    public function displayForm(){
        if(!$this->form){
            $model=$this->getModel();
            $this->form=$model->getForm();
        }
        $this->view="default";
        echo (self::display("form"));
    }
}