<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace WpBookingPro\Form\fields;
defined('_WPBOOKINGPRO_EXEC') or die;
use WpBookingPro\Form\FormField;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingPro_FormFieldRatingstar extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'ratingstar';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.ratingstar.ratingstar';

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();
        $extraData = array(
            'field_name_rating_ambience'   => $this->element['field_name_rating_ambience'],
            'field_name_rating_cleanliness'   => $this->element['field_name_rating_cleanliness'],
            'field_name_rating_staff'   => $this->element['field_name_rating_staff'],
            'field_name_rating_value'   => $this->element['field_name_rating_value'],
        );

        return array_merge($data, $extraData);
    }


}
