<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace WpBookingPro\Form\fields;
defined('_WPBOOKINGPRO_EXEC') or die;
use WpBookingPro\Form\FormField;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingPro_FormFieldCustomAddress extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'customaddress';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.customaddress.customaddress';

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        $extraData = array(
            'name_custom_address'   => $this->element['name_custom_address']
        );

        return array_merge($data, $extraData);
    }

}
