<?php
use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$vendor = $this->vendor;
if(!empty($vendor)) {
    $rating_avg = 0;
    $service_rating = 0;
    $list_review = isset($vendor->list_review)?$vendor->list_review : array();
    $rating_vendor_sum = 0;
    foreach ($list_review as $review) {
        $rating_vendor_sum += $review->rating_vendor;
    }

    $rating_vendor_avg = !empty($list_review) ? $rating_vendor_sum/ count ($list_review): 0;
    $list_star_sum= HtmlFrontend::get_rating_star($rating_vendor_avg);
    $one_star = array();
    $two_star = array();
    $three_star = array();
    $four_star = array();
    $five_star = array();
    if(!empty($list_review)) {
        $rating_sum = 0;
        foreach ($list_review as $review) {
            if (isset($review->rating_vendor)) {
                if ($review->rating_vendor > 0 && $review->rating_vendor <= 1) {
                    array_push($one_star, $review);
                } elseif ($review->rating_vendor > 1 && $review->rating_vendor <= 2) {
                    array_push($two_star, $review);
                } elseif ($review->rating_vendor > 2 && $review->rating_vendor <= 3) {
                    array_push($three_star, $review);
                } elseif ($review->rating_vendor > 3 && $review->rating_vendor <= 4) {
                    array_push($four_star, $review);
                } elseif ($review->rating_vendor > 4 && $review->rating_vendor <= 5) {
                    array_push($five_star, $review);
                }
            }
        }

    }
}


$page_vendor_detail = ConfigHelper::get_page_vendor_detail();
if($page_vendor_detail) {
    $this->page_vendor_detail = get_permalink($page_vendor_detail);
} else {
    $this->page_vendor_detail = '';
}

$page_list_vendor = ConfigHelper::get_page_list_vendor();
if($page_list_vendor) {
    $this->page_list_vendor = get_permalink($page_list_vendor);
} else {
    $this->page_list_vendor = '';
}

$page_service_detail = ConfigHelper::get_page_service_detail();
if($page_service_detail) {
    $this->page_service_detail = get_permalink($page_service_detail);
} else {
    $this->page_service_detail = '';
}

$limit = 8;

?>
    <div class="view-vendor-detail">
        <?php if(!empty((array)$this->vendor)) {?>
            <div class="block-alert"></div>
           <div class="block-vendor-info">
               <div class="vendor-info-left">
                   <div class="img-block">
                       <div>
                           <img src="<?php echo (esc_url(isset($vendor->image)?$vendor->image:'')) ?>" alt="vendor-image">
                       </div>
                   </div>
                   <div class="content-info ">
                       <h3><?php echo (esc_html(isset($vendor->first_name) || isset($vendor->last_name)?Utility::get_full_name($vendor->first_name, $vendor->last_name):''))?></h3>
                       <div class="created info-item">
                           <span><?php esc_html_e('Created date:','wpbookingpro');?></span>
                           <span><?php echo (esc_html(isset($vendor->created)?date('d M, Y',strtotime($vendor->created)):'')) ?></span>
                       </div>
                       <div class="email info-item">
                           <i class="icon-nb-email"></i>
                           <span><?php echo (esc_html(isset($vendor->email)?$vendor->email:''))?></span>
                       </div>
                       <div class="address info-item">
                           <i class="icon-nb-pin"></i>
                           <span><?php echo (esc_html(isset($vendor->address)?$vendor->address:''))?></span>
                       </div>
                       <div class="phone info-item">
                           <i class="icon-nb-phone-call"></i>
                           <span>
                               <?php
                               $mobile = isset($vendor->mobile)?$vendor->mobile:'';
                               if($mobile['0'] == 0) {
                                   $mobile = substr($mobile,1);
                               }
                               $phonecode = isset($vendor->phonecode)?$vendor->phonecode:'';
                               echo (esc_html('+'.$phonecode .' '. $mobile));
                               ?>
                           </span>
                       </div>
                   </div>
               </div>
               <div class="vendor-info-right">
                   <h4><?php esc_html_e('Vendor Rating','wpbookingpro');?></h4>
                   <ul class="list-rating-star">
                       <?php if($rating_vendor_avg > 0) {?>
                           <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                               <li class="item-star"><i class="fas fa-star"></i></li>
                           <?php }?>
                           <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                               <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                           <?php }?>
                           <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                               <li class="item-star"><i class="far fa-star"></i></li>
                           <?php }?>
                       <?php } else {?>
                           <?php for ($i=0; $i < 5;$i++) {?>
                               <li class="item-star"><i class="far fa-star"></i></li>
                           <?php }?>
                       <?php }?>
                   </ul>
                   <div class="block-link-social">
                       <?php if($vendor->params->get('facebook')) {?>
                           <a id="fb" class="link-social btn-web" href="<?php echo ($vendor->params->get('facebook'))?>"><i class="fab fa-facebook-f"></i></a>
                       <?php }?>
                       <?php if($vendor->params->get('twitter')) {?>
                           <a id="twitter" class="link-social btn-web" href="<?php echo ($vendor->params->get('twitter'))?>"><i class="fab fa-twitter"></i></a>
                       <?php }?>
                       <?php if($vendor->params->get('youtube')) {?>
                           <a id="youtube" class="link-social btn-web" href="<?php echo ($vendor->params->get('youtube'))?>"><i class="fab fa-youtube"></i></a>
                       <?php }?>
                       <?php if($vendor->params->get('pinterest')) {?>
                           <a id="pinterest" class="link-social btn-web" href="<?php echo ($vendor->params->get('pinterest'))?>"><i class="fab fa-pinterest"></i></a>
                       <?php }?>
                       <?php if($vendor->params->get('instagram')) {?>
                           <a id="instagram" class="link-social btn-web" href="<?php echo ($vendor->params->get('instagram'))?>"><i class="fab fa-instagram"></i></a>
                       <?php }?>
                   </div>
               </div>
           </div>
            <div class="block-slide-graphic">
                <div class="gallery-graphic-slider">
                    <?php if(isset($vendor->gallery) && !empty($vendor->gallery)) {?>
                        <?php foreach ($vendor->gallery as $gallery_item) {?>
                            <div class="gallery-graphic-slider-item">
                                <div>
                                    <img src="<?php echo (esc_url(isset($gallery_item->path)?Factory::getRootUrlPlugin().$gallery_item->path:''))?>" alt="graphic-image">
                                </div>
                            </div>
                        <?php }?>
                    <?php } else {?>
                        <div class="gallery-graphic-slider-item">
                            <div>
                                <img src="<?php echo (esc_url(Factory::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg'))?>" alt="graphic-image">
                            </div>
                        </div>
                    <?php }?>
                </div>
            </div>
            <div class="block-all-product">
                <form action="" method="post" name="filter-all">
                    <div class="title">
                        <div class="line line-1"></div>
                        <h2><?php esc_html_e('All products','wpbookingpro');?></h2>
                        <div class="line line-2"></div>
                    </div>
                    <div class="block-filter">
                        <div class="block-filter-price block-filter-price-more-option">
                            <input type="text" id="amount_1" class="amount_1" readonly/>
                            <div id="slider-container-1" class="slider-container-1"></div>
                            <input type="hidden" name="price_search">
                        </div>
                        <div class="sort-by-block">
                            <div class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                    <span class="select-by-default"><?php esc_attr_e('Sort by', 'wpbookingpro') ?></span>
                                    <i class="fas fa-chevron-down"></i>
                                </a>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <ul class="sort-display">
                                        <li ><a  class="select-sort-item" data-key_sort="service.name" data-direction="ASC"  href="javascript:void(0)"><?php esc_attr_e('Name A-Z', 'wpbookingpro') ?></i></a></li>
                                        <li ><a class="select-sort-item" data-key_sort="service.name" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Name Z-A', 'wpbookingpro') ?></a></li>
                                        <li ><a class="select-sort-item" data-key_sort="service.price" data-direction="ASC"   href="javascript:void(0)"><?php esc_attr_e('Price ascending', 'wpbookingpro') ?></a></li>
                                        <li ><a class="select-sort-item" data-key_sort="service.price" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Price descending', 'wpbookingpro') ?></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="input-search">
                            <i class="icon-nb-search icon-keyword-search"></i>
                            <input type="text" value="" id="bh-sl-search" class="search form-control" name="keyword"
                                   placeholder="<?php esc_attr_e('What are you looking for', 'wpbookingpro') ?>"/>
                        </div>
                    </div>
                    <div class="all-product-slider">
                        <div class="wrapper-product-slider">
                            <?php
                            foreach($vendor->list_service as $service) {
                                $this->service = $service;
                                $this->loadTemplate('all_product');
                            }
                            ?>
                        </div>
                        <div class="arrow-left" style="display: flex;"><i class="fas fa-arrow-left"></i></div>
                        <div class="arrow-right" style="display: flex;"><i class="fas fa-arrow-right"></i></div>
                    </div>
                    <input type="hidden" name="sort" value="service.ordering">
                    <input type="hidden" name="direction">
                    <input type="hidden" name="page_service_detail" value="<?php echo (esc_attr($this->page_service_detail))?>">
                </form>
            </div>
            <div class="block-category-product">
                <?php foreach($vendor->list_category as $category) {?>
                    <form action="" method="post" name="filter-category-<?php echo (esc_attr($category->id)) ?>">
                        <div class="block-category-product-item">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="title">
                                        <div class="line line-1"></div>
                                        <h2><?php echo (esc_html(isset($category->name)?$category->name:''))?></h2>
                                        <div class="line line-2"></div>
                                    </div>
                                    <div class="block-filter">
                                        <div class="block-filter-price block-filter-price-more-option">
                                            <input type="text" id="amount_category_<?php echo (esc_attr($category->id))?>" class="amount_category_<?php echo (esc_attr($category->id))?>" readonly/>
                                            <div id="slider-container-category-<?php echo (esc_attr($category->id))?>" class="slider-container-category-<?php echo (esc_attr($category->id))?>"></div>
                                            <input type="hidden" name="price_search">
                                        </div>
                                        <div class="sort-by-block">
                                            <div class="dropdown">
                                                <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                                    <span class="select-by-default"><?php esc_attr_e('Sort by', 'wpbookingpro') ?></span>
                                                    <i class="fas fa-chevron-down"></i>
                                                </a>
                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                    <ul class="sort-display">
                                                        <li ><a  class="select-sort-item" data-key_sort="service.name" data-direction="ASC"  href="javascript:void(0)"><?php esc_attr_e('Name A-Z', 'wpbookingpro') ?></i></a></li>
                                                        <li ><a class="select-sort-item" data-key_sort="service.name" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Name Z-A', 'wpbookingpro') ?></a></li>
                                                        <li ><a class="select-sort-item" data-key_sort="service.price" data-direction="ASC"   href="javascript:void(0)"><?php esc_attr_e('Price ascending', 'wpbookingpro') ?></a></li>
                                                        <li ><a class="select-sort-item" data-key_sort="service.price" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Price descending', 'wpbookingpro') ?></a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="input-search">
                                            <i class="icon-nb-search icon-keyword-search"></i>
                                            <input type="text" value="" id="bh-sl-search" class="search form-control" name="keyword"
                                                   placeholder="<?php esc_attr_e('What are you looking for', 'wpbookingpro') ?>"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row category-<?php echo (esc_attr($category->id))?>">
                                <?php
                                    $modelCategory = Model::getInstance('category');
                                    $list_service = $modelCategory->getServiceByCategoryId($category->id);
                                ?>
                                <?php foreach($list_service as $service_item) {?>
                                        <div class="col-sm-6 col-md-3">
                                            <?php
                                            $this->service_category = $service_item;
                                            $this->loadTemplate('category_product');
                                            ?>
                                        </div>

                                <?php }?>
                            </div>
                        </div>
                        <ul class="pagination-category-<?php echo (esc_attr($category->id))?>"></ul>
                        <input type="hidden" name="start">
                        <input type="hidden" name="limit" value="<?php echo (esc_attr($limit))?>">
                        <input type="hidden" name="page_service_detail" value="<?php echo (esc_attr($this->page_service_detail))?>">
                        <input type="hidden" name="sort" value="service.ordering">
                        <input type="hidden" name="direction">
                    </form>
                <?php }?>
            </div>
            <div class="block-review-vendor">
                <div class="title">
                    <div class="line line-1"></div>
                    <h2><?php esc_html_e('Add Reviews','wpbookingpro');?></h2>
                    <div class="line line-2"></div>
                </div>
                <div class="rating-review">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="title-rating">
                                <h4><?php esc_html_e('Ratings','wpbookingpro');?></h4>
                            </div>
                            <div class="quality-star">
                                <div class="number-star">
                                    <span><?php echo (!empty($list_review)?number_format((float)$rating_vendor_avg,2):0);?></span>
                                </div>
                                <span class="text-star">
                                    <span><?php esc_html_e('Overall Rating of','wpbookingpro');?></span>
                                    <span><?php echo (esc_html(count($list_review)));?></span>
                                    <span><?php esc_html_e('guest rating', 'wpbookingpro');?></span>
                                </span>
                            </div>
                            <div class="overall-rating">
                                <div class="block-item-rating">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 5; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <div class="progress">
                                        <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($five_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($five_star)/count($list_review):0);?>)">
                                        </div>
                                    </div>
                                    <div class="number-rating"><?php echo (esc_html(count($five_star)));?></div>
                                </div>
                                <div class="block-item-rating">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 4; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    </ul>
                                    <div class="progress">
                                        <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($four_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($four_star)/count($list_review):0);?>)">
                                        </div>
                                    </div>
                                    <div class="number-rating"><?php echo (esc_html(count($four_star)));?></div>
                                </div>
                                <div class="block-item-rating">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 3; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for($i = 1; $i <= 2; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <div class="progress">
                                        <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($three_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($three_star)/count($list_review):0);?>)">
                                        </div>
                                    </div>
                                    <div class="number-rating"><?php echo (esc_html(count($three_star)));?></div>
                                </div>
                                <div class="block-item-rating">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 2; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for($i = 1; $i <= 3; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <div class="progress">
                                        <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($two_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($two_star)/count($list_review):0);?>)">
                                        </div>
                                    </div>
                                    <div class="number-rating"><?php echo (esc_html(count($two_star)));?></div>
                                </div>
                                <div class="block-item-rating">
                                    <ul class="list-rating-star">
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php for($i = 1; $i <= 4; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <div class="progress">
                                        <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($one_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($one_star)/count($list_review):0);?>)">
                                        </div>
                                    </div>
                                    <div class="number-rating"><?php echo (esc_html(count($one_star)));?></div>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-7">
                            <form action="" method="post" name="form-review">
                                <div class="title-review">
                                    <h4><?php esc_html_e('Your Reviews','wpbookingpro');?></h4>
                                </div>
                                <div class="block-rating-star">
                                    <?php
                                    $field = $this->form_review->getField('rating_vendor');
                                    echo ($field->input);
                                    ?>
                                </div>
                                <div class="input-review">
                                    <div class="row row-form-review">
                                        <div class="col-md-12">
                                            <div class="block-name">
                                                <?php
                                                $field = $this->form_review->getField('name');
                                                echo ($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row row-form-review">
                                        <div class="col-md-12">
                                            <div class="block-email">
                                                <?php
                                                $field = $this->form_review->getField('email');
                                                echo ($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row row-form-review">
                                        <div class="col-md-12">
                                            <div class="block-title">
                                                <?php
                                                $field = $this->form_review->getField('title');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row row-form-review">
                                        <div class="col-md-12">
                                            <div class="block-comment">
                                                <?php
                                                $field = $this->form_review->getField('comments');
                                                echo ($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="btn-submit">
                                            <button type="button" class="btn btn-primary btn-save-review"><?php esc_html_e('Submit','wpbookingpro');?></button>
                                        </div>
                                    </div>
                                </div>
                                <?php echo ($this->form_review->renderField('id')) ?>
                                <input type="hidden" name="task" value="review.save_review">
                                <input type="hidden" name="link_redirect" value="<?php echo (esc_attr($this->page_vendor_detail.'?user_id='.$vendor->id));?>">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="block-review-by-customer">
                <div class="title">
                    <div class="line line-1"></div>
                    <h2><?php esc_html_e('Reviews By Customer','wpbookingpro');?></h2>
                    <div class="line line-2"></div>
                </div>
                <form action="" method="post" name="form-list_review">
                    <div class="wrapper-list-review">
                        <?php if (!empty($list_review)) {?>
                            <?php foreach ($list_review as $review_item) {?>
                                <div class="block-review-item">

                                    <div class="img-block">
                                        <div>
                                            <img src="<?php echo (Factory::getRootUrlPlugin())?>frontend/app/assets/images/avatar-reviewer.jpg" alt="avatar-reviewer">
                                        </div>
                                    </div>
                                    <div class="block-content">
                                        <h5><?php echo (esc_html(isset($review_item->name)?$review_item->name:''))?></h5>
                                        <ul class="list-rating-star">
                                            <?php $list_star_sum_review = HtmlFrontend::get_rating_star($review_item->rating_vendor);?>
                                            <?php for ($i=0; $i < $list_star_sum_review[0]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i < $list_star_sum_review[1]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i < $list_star_sum_review[2]; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <p><?php echo (esc_html(isset($review_item->comments)?$review_item->comments:''))?></p>
                                    </div>
                                    <div class="block-time-review">
                                        <h6><?php esc_html_e('Visited', 'wpbookingpro');?> <?php echo (esc_html(date('F d, Y',strtotime($review_item->created_date))))?></h6>
                                    </div>
                                </div>
                            <?php }?>
                        <?php }?>
                    </div>
                    <ul class="pagination-review"></ul>
                    <input type="hidden" name="start">
                    <input type="hidden" name="limit" value="<?php echo (esc_attr($limit))?>">
                </form>
            </div>
        <?php } else {?>
            <div class="row">
                <div class="col-md-12 text-center">
                    <h3 class="heading-not-found"><?php esc_html_e('Can not found vendor','wpbookingpro');?></h3>
                    <a class="btn btn-primary btn-back-to-service-list" href="<?php esc_html_e($this->page_list_vendor);?>"><?php esc_html_e('Click here to back list vendor','wpbookingpro');?></a>
                </div>
            </div>
        <?php }?>
    </div>

<?php

$doc = Factory::getDocument();
