<?php

use WpBookingPro\Factory;
use WpBookingPro\Router\Route;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$service = $this->service;
$rating_avg = $service->rating_avg;
$list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
$list_review = isset($service->list_review)?$service->list_review:array();
$near_me = 0;
$unit_for_search= '';
$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
<div class="block-service-item" data-service_id="<?php echo (esc_attr(isset($service->id)?$service->id:''))?>">
    <div class="content-top">
        <a href="<?php echo (esc_url(Route::_($this->page_service_detail.'?service_id='.$service->id)))?>">
            <div class="block-img">
                <div>
                    <?php if($check_user_demo['is_demo']) {?>
                        <img src="<?php echo (esc_url(isset($service->image)?$uploads['baseurl'].'/'.$service->image:Factory::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg')) ?>" alt="service-image">
                    <?php } else {?>
                        <img src="<?php echo (esc_url(isset($service->image)?Factory::getRootUrlPlugin().$service->image:Factory::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg')) ?>" alt="service-image">
                    <?php } ?>
                </div>
            </div>
        </a>
        <div class="block-feature">
            <div class="label-feature <?php echo (esc_attr(isset($service->is_feature) && $service->is_feature==1 ? 'visible':''));?>">
                <span><?php esc_attr_e('Featured','wpbookingpro');?></span>
            </div>
            <?php if(is_user_logged_in()) {?>
                <i class="fas fa-heart <?php echo (esc_attr(isset($service->wishlist)? 'active':'')) ?>"></i>
            <?php }?>
        </div>
    </div>
    <div class="content-bottom">
        <p class="place-service" title="<?php echo (isset($service->location->address)?$service->location->address:'')?>">
            <i class="icon-nb-pin"></i>
            <?php echo (isset($service->location->address)?$service->location->address:'')?>
        </p>
        <a href="<?php echo (esc_url(Route::_($this->page_service_detail.'?service_id='.$service->id)))?>">
            <h4 class="name-service" title="<?php echo (esc_attr(isset($service->name)?$service->name:''))?>">
                <?php echo (esc_html(isset($service->name)?$service->name:''))?>
            </h4>
        </a>
        <div class="block-rating">
            <ul class="list-rating-star">
                <?php if($rating_avg > 0) {?>
                    <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                        <li class="item-star"><i class="fas fa-star"></i></li>
                    <?php }?>
                    <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                    <?php }?>
                    <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                        <li class="item-star"><i class="far fa-star"></i></li>
                    <?php }?>
                <?php } else {?>
                    <?php for ($i=0; $i < 5;$i++) {?>
                        <li class="item-star"><i class="far fa-star"></i></li>
                    <?php }?>
                <?php }?>
            </ul>
            <div class="rating-review">
                <span><?php echo (esc_html(count($list_review)))?> <?php esc_attr_e('Reviews','wpbookingpro');?></span>
            </div>
        </div>
        <div class="block-trip-price">
            <div class="time-trip">
                <i class="icon-nb-clock"></i>
                <span><?php echo (esc_html(isset($service->duration)?$service->duration:0))?> <?php esc_attr_e('hours','wpbookingpro');?></span>
            </div>
            <div class="price-service">
                <span><i class="fas fa-bolt"></i><span><?php esc_attr_e('From','wpbookingpro');?></span></span>
                <span class="price"><?php echo (esc_html(HtmlFrontend::render_price(isset($service->price)?$service->price:0)))?></span>
            </div>
        </div>
        <?php if($near_me == 1) {?>
            <div class="distance-between-your-location">
                <i class="fas fa-map-pin"></i>
                <span>
                    <?php echo (esc_html(isset($service->distance)?$service->distance:0))?>
                    <?php
                    if($unit_for_search == 'Km') {
                        echo (esc_html('Km'));
                    } elseif ($unit_for_search='Mi') {
                        echo (esc_html('Mile'));
                    }
                    ?>
                </span>
            </div>
        <?php }?>
    </div>
</div>
