<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc = Factory::getDocument();
$page_login= ConfigHelperAlias::get_page_login();
if($page_login) {
    $this->page_login = get_page_link($page_login);
}else{
    $this->page_login="";
}

$page_signup= ConfigHelperAlias::get_page_signup();
if($page_signup) {
    $this->page_signup = get_page_link($page_signup);
}else{
    $this->page_signup="";
}

$page_user_account= ConfigHelperAlias::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}

$uri =Factory::getUri();
$status = $uri->getVar('status_signup','');
?>
<div class="view-signup">
    <?php if(is_user_logged_in()) {?>
        <?php Utility::redirect($this->page_user_account);?>
    <?php } else {?>
        <?php if($status == 'success') {?>
            <div class="row">
                <div class="col-md-12">
                    <div class="block-success-message">
                        <div class="content-left">
                            <i class="fas fa-check"></i>
                        </div>
                        <div class="content-right">
                            <h2><?php esc_html_e('Congratulation!','wpbookingpro');?></h2>
                            <div class="message">
                                <span><?php esc_html_e('You have successfully create account.','wpbookingpro');?></span>
                                <a href="<?php echo (esc_url($this->page_login))?>"><?php esc_html_e('Login here', 'wpbookingpro');?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php }else {?>
            <form action="" method="post" class="form-signup" name="signup_form">
                <div class="row">
                    <div class="col-md-12">
                        <div class="wrapper-signup">
                            <div class="block-content-left">
                                <h1><?php esc_html_e('Hello Friend', 'wpbookingpro');?></h1>
                                <p><?php esc_html_e('Enter your personal details and start journey with us', 'wpbookingpro');?></p>
                                <div class="have-account">
                                    <span><?php esc_html_e('Already have an account?','wpbookingpro');?></span>
                                    <a href="<?php echo (esc_url($this->page_login))?>"><?php esc_html_e('Login','wpbookingpro');?></a>
                                </div>
                            </div>
                            <div class="block-content-right">
                                <h1><?php esc_html_e('Create Account', 'wpbookingpro');?></h1>
                                <p><?php esc_html_e('Please fill in this form to create an account', 'wpbookingpro');?></p>
                                <span class="email-exist" style="display: none"><?php esc_html_e('Email already exist!','wpbookingpro');?></span>
                                <span class="username-exist" style="display: none"><?php esc_html_e('Username already exist!','wpbookingpro');?></span>
                                <div class="form-info-user">
                                    <input id="first_name" type="text" name="first_name" placeholder="<?php esc_attr_e('First name *', 'wpbookingpro');?>" required/>
                                    <input id="last_name" type="text" name="last_name" placeholder="<?php esc_attr_e('Last name *', 'wpbookingpro');?>" required/>
                                    <div class="user-name-block">
                                        <input id="user_name" type="text" name="user_name" placeholder="<?php esc_attr_e('User name *', 'wpbookingpro');?>" required/>
                                        <i class="far fa-check-circle" style="display: none"></i>
                                    </div>
                                    <div class="email-block">
                                        <input id="email" type="email" name="email" placeholder="<?php esc_attr_e('Email *', 'wpbookingpro');?>" autocomplete="off" required/>
                                        <i class="far fa-check-circle" style="display: none"></i>
                                    </div>
                                    <input id="password" type="password" name="password" placeholder="<?php esc_attr_e('Password *', 'wpbookingpro');?>" autocomplete="off" required/>
                                    <div class="terms-of-use">
                                        <div class="content-terms">
                                            <input id="terms_and_privacy" type="checkbox" name="terms_and_privacy" value="1" required />
                                            <span><?php esc_html_e('I accept the', 'wpbookingpro');?></span>
                                            <a href="#"><?php esc_html_e('Terms of Use','wpbookingpro');?></a>
                                            <span>&</span>
                                            <a href="#"><?php esc_html_e('Privacy Policy','wpbookingpro');?></a>
                                        </div>
                                    </div>
                                    <button type="button" class="sign-up-button"><?php esc_html_e('Sign up','wpbookingpro');?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="task" value="signup.create_user_account">
                <input type="hidden" name="link_redirect" value="<?php echo(esc_url($this->page_signup)) ?>">
            </form>
        <?php }?>
    <?php }?>
</div>

<?php
$doc->addScriptApplySelector('.view-signup','view_signup',array(

),"frontend/app/assets/js/view_signup.js");