<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Router\Route;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$service = $this->service;
$rating_avg=isset($service->rating_avg)?$service->rating_avg:0;
if($rating_avg > 0) {
    $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
}
$list_review = isset($service->list_review)?$service->list_review:array();
$input = Factory::getInput();
$near_me=$input->getInt('near_me',0);
$appConfig = Factory::getAppConfig();
$unit_for_search = $appConfig->get('unit_for_search', '');
$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $service->image);
?>
<div class="row">
    <div class="col-md-12">
        <div class="block-service-item-display-list" data-service_id="<?php echo (esc_attr($service->id))?>">
            <div class="block-info-content">
                <a href="<?php echo  (esc_url(Route::_($this->page_service_detail.'?service_id='.$service->id))); ?>">
                    <div class="img-block">
                        <div>
                            <?php if($check_user_demo['is_demo']) {?>
                                <?php if($check_image_size) {?>
                                    <img src="<?php echo (esc_url($uploads['baseurl'].'/'.$service->image)) ;?>" alt="service">
                                <?php } else {?>
                                    <img src="<?php echo (esc_url(Factory::getRootUrlPlugin().$service->image)) ;?>" alt="service">
                                <?php }?>

                            <?php } else {?>
                                <img src="<?php echo (esc_url(Factory::getRootUrlPlugin().$service->image)) ;?>" alt="service" >
                            <?php } ?>
                        </div>
                    </div>
                </a>
                <div class="block-feature">
                    <div class="label-feature <?php echo (esc_attr(isset($service->is_feature) && $service->is_feature == 1?'visible':''));?>">
                        <span><?php esc_html_e('Featured','wpbookingpro');?></span>
                    </div>
                    <?php if(is_user_logged_in()) {?>
                        <i class="fas fa-heart <?php echo (esc_attr(isset($service->wishlist)? 'active':'')) ?>"></i>
                    <?php }?>
                </div>
            </div>
            <div class="content-infor-service">
                <p class="place-service" title="<?php echo (esc_html(isset($service->location->address)?$service->location->address:''));?>">
                    <i class="icon-nb-pin"></i>
                    <span>
                        <?php echo (esc_html(isset($service->location->address)?$service->location->address:''));?>
                    </span>
                </p>
                <a href="<?php echo  (esc_url(Route::_($this->page_service_detail.'?service_id='.$service->id))); ?>">
                    <h4 class="name-service" title="<?php echo (esc_html(isset($service->name)?$service->name:''));?>">
                        <?php echo (esc_html(isset($service->name)?$service->name:''));?>
                    </h4>
                </a>
                <div class="block-rating">
                    <ul class="list-rating-star">
                        <?php if($rating_avg > 0) {?>
                            <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                <li class="item-star"><i class="fas fa-star"></i></li>
                            <?php }?>
                            <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                            <?php }?>
                            <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                <li class="item-star"><i class="far fa-star"></i></li>
                            <?php }?>
                        <?php } else {?>
                            <?php for ($i=0; $i < 5;$i++) {?>
                                <li class="item-star"><i class="far fa-star"></i></li>
                            <?php }?>
                        <?php }?>
                    </ul>
                    <div class="rating-review">
                        <span><?php echo (esc_html(count($list_review)))?> <?php esc_html_e('reviews','wpbookingpro');?></span>
                    </div>
                </div>
                <div class="description">
                    <?php echo (esc_html(isset($service->description)?$service->description:''));?>
                </div>
            </div>
            <div class="content-right">
                <div class="price-service">
                    <p class="new-price">
                        <span><i class="fas fa-bolt"></i><span><?php esc_html_e('from','wpbookingpro');?></span></span>
                        <span class="price"><?php echo (esc_html(FrontendHelper::format_currency(number_format((float)$service->price,2))));?></span>
                    </p>
                </div>
                <div class="trip-time">
                    <i class="icon-nb-clock"></i>
                    <span><?php echo (esc_html($service->duration));?> <?php esc_attr_e('hours','wpbookingpro');?></span>
                </div>
                <?php if($near_me == 1) {?>
                    <div class="distance-between-your-location">
                        <i class="fas fa-map-pin"></i>
                        <span>
                            <?php echo (esc_html(isset($service->distance)?$service->distance:0))?>
                            <?php
                            if($unit_for_search == 'Km') {
                                echo (esc_html('Km'));
                            } elseif ($unit_for_search='Mi') {
                                echo (esc_html('Mile'));
                            }
                            ?>
                        </span>
                    </div>
                <?php }?>
                <div class="view-more">
                    <button type="button" class="btn btn-primary"><?php esc_html_e('View service','wpbookingpro');?></button>
                </div>
            </div>
        </div>
    </div>
</div>
